//
// Jala Project [http://opensvn.csie.org/traccgi/jala]
//
// Copyright 2004 ORF Online und Teletext GmbH
//
// Licensed under the Apache License, Version 2.0 (the ``License'');
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an ``AS IS'' BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// $Revision: 228 $
// $LastChangedBy: stefanp $
// $LastChangedDate: 2007-05-10 14:02:46 +0200 (Do, 10 Mai 2007) $
// $HeadURL: https://robert@opensvn.csie.org/jala/branches/release-1.2/code/all.js $
//


/**
 * @fileoverview Wrapper for automatic inclusion of all Jala modules.
 */


// Define the global namespace for Jala modules
if (!global.jala) {
   global.jala = {};
}


(function() {
   var packages = [
      "AsyncRequest",
      "BitTorrent",
      "Date",
      "DnsClient",
      "Captcha", 
      "Form",
      "History",
      "HtmlDocument",
      "HopObject",
      "i18n",
      "ImageFilter",
      "IndexManager",
      "ListRenderer",
      "Mp3",
      "PodCastWriter",
      "RemoteContent",
      "Rss20Writer",
      "Utilities",
      "XmlRpcRequest",
      "XmlWriter"
   ];
   var jalaDir = getProperty("jala.dir", "modules/jala");
   for (var i in packages) {
      app.addRepository(jalaDir + "/code/" + packages[i] + ".js");
   }
   return;
})();


/**
 * Get a string representation of the Jala library.
 * @returns [Jala JavaScript Application Library]
 * @type String
 */
jala.toString = function() {
   return "[Jala JavaScript Application Library]";
};
