/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.html.dom.HTMLBuilder;
import org.ccil.cowan.tagsoup.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class XmlUtils {
    private static DocumentBuilderFactory domBuilderFactory = null;

    public static Document parseXml(Object obj) throws SAXException, IOException, ParserConfigurationException {
        Document doc;
        if (domBuilderFactory == null) {
            domBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        DocumentBuilder parser = domBuilderFactory.newDocumentBuilder();
        if (obj instanceof String) {
            try {
                new URL(obj.toString());
                doc = parser.parse(obj.toString());
            }
            catch (MalformedURLException nourl) {
                doc = parser.parse(new InputSource(new StringReader(obj.toString())));
            }
        } else if (obj instanceof InputStream) {
            doc = parser.parse(new InputSource((InputStream)obj));
        } else if (obj instanceof Reader) {
            doc = parser.parse(new InputSource((Reader)obj));
        } else {
            throw new RuntimeException("Unrecognized argument to parseXml: " + obj);
        }
        doc.normalize();
        return doc;
    }

    public static HTMLDocument parseHtml(Object obj) throws IOException, SAXException {
        try {
            Class.forName("org.apache.html.dom.HTMLDocumentImpl");
        }
        catch (Throwable notfound) {
            throw new RuntimeException("Couldn't load Xerces HTML DOM classes. Make sure you have xercesImpl.jar and xml-apis.jar in your classpath.");
        }
        if (obj instanceof String) {
            try {
                URL url = new URL(obj.toString());
                return XmlUtils.getHtmlDocument(new InputStreamReader(url.openStream()));
            }
            catch (MalformedURLException nourl) {
                return XmlUtils.getHtmlDocument(new StringReader(obj.toString()));
            }
        }
        if (obj instanceof InputStream) {
            return XmlUtils.getHtmlDocument(new InputStreamReader((InputStream)obj));
        }
        if (obj instanceof Reader) {
            return XmlUtils.getHtmlDocument((Reader)obj);
        }
        throw new RuntimeException("Unrecognized argument to parseHtml: " + obj);
    }

    private static HTMLDocument getHtmlDocument(Reader reader) throws IOException, SAXException {
        XMLReaderAdapter parser = new XMLReaderAdapter((XMLReader)new Parser());
        HTMLBuilder builder = new HTMLBuilder();
        parser.setDocumentHandler((DocumentHandler)builder);
        parser.parse(new InputSource(reader));
        return builder.getHTMLDocument();
    }
}

