/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class WrappedMap
implements Map {
    protected Map wrapped = null;
    protected boolean readonly = false;

    public WrappedMap(Map map) {
        this(map, false);
    }

    public WrappedMap(Map map, boolean readonly) {
        if (map == null) {
            throw new NullPointerException("null Map passed to WrappedMap constructor");
        }
        this.wrapped = map;
        this.readonly = readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public int size() {
        return this.wrapped.size();
    }

    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    public Object get(Object key) {
        return this.wrapped.get(key);
    }

    public Object put(Object key, Object value) {
        if (this.readonly) {
            throw new RuntimeException("Attempt to modify readonly map");
        }
        return this.wrapped.put(key, value);
    }

    public Object remove(Object key) {
        if (this.readonly) {
            throw new RuntimeException("Attempt to modify readonly map");
        }
        return this.wrapped.remove(key);
    }

    public void putAll(Map t) {
        if (this.readonly) {
            throw new RuntimeException("Attempt to modify readonly map");
        }
        this.wrapped.putAll(t);
    }

    public void clear() {
        if (this.readonly) {
            throw new RuntimeException("Attempt to modify readonly map");
        }
        this.wrapped.clear();
    }

    public Set keySet() {
        return this.wrapped.keySet();
    }

    public Collection values() {
        return this.wrapped.values();
    }

    public Set entrySet() {
        return this.wrapped.entrySet();
    }

    public boolean equals(Object o) {
        return ((Object)this.wrapped).equals(o);
    }

    public int hashCode() {
        return ((Object)this.wrapped).hashCode();
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

