/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class UrlEncoded {
    private static Method encode = null;
    private static Method decode = null;

    public static String encode(String str, String encoding) throws UnsupportedEncodingException {
        int l = str.length();
        boolean needsSpaceEncoding = false;
        for (int i = 0; i < l; ++i) {
            block7: {
                char c = str.charAt(i);
                if (c == ' ') {
                    needsSpaceEncoding = true;
                    continue;
                }
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                if (encode != null) {
                    try {
                        return (String)encode.invoke(null, str, encoding);
                    }
                    catch (IllegalAccessException e) {
                        encode = null;
                        System.err.println("UrlEncoded: Can't access JDK 1.4 encode method (" + e + "). Using deprecated version from now on.");
                    }
                    catch (InvocationTargetException e) {
                        Throwable ex = e.getTargetException();
                        if (!(ex instanceof UnsupportedEncodingException)) break block7;
                        throw (UnsupportedEncodingException)ex;
                    }
                }
            }
            return URLEncoder.encode(str);
        }
        if (needsSpaceEncoding) {
            return str.replace(' ', '+');
        }
        return str;
    }

    public static String decode(String str, String encoding) throws UnsupportedEncodingException {
        block5: {
            if (str.indexOf(43) == -1 && str.indexOf(37) == -1) {
                return str;
            }
            if (decode != null) {
                try {
                    return (String)decode.invoke(null, str, encoding);
                }
                catch (IllegalAccessException e) {
                    decode = null;
                    System.err.println("UrlEncoded: Can't access JDK 1.4 decode method (" + e + "). Using deprecated version from now on.");
                }
                catch (InvocationTargetException e) {
                    Throwable ex = e.getTargetException();
                    if (!(ex instanceof UnsupportedEncodingException)) break block5;
                    throw (UnsupportedEncodingException)ex;
                }
            }
        }
        return URLDecoder.decode(str);
    }

    static {
        try {
            Class[] args = new Class[]{String.class, String.class};
            encode = URLEncoder.class.getMethod("encode", args);
            decode = URLDecoder.class.getMethod("decode", args);
        }
        catch (NoSuchMethodException e) {
            System.err.println("UrlEncoded: Can't find JDK 1.4 encode and decode methods. Using JDK 1.3 versions.");
        }
    }
}

