/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class Timer {
    private Vector timeline = new Vector();
    private Hashtable events = new Hashtable();

    public void reset() {
        this.timeline.setSize(0);
        this.events.clear();
    }

    public void beginEvent(String name) {
        this.timeline.addElement(name);
        this.events.put(name, new Event(name));
    }

    public void endEvent(String name) {
        Event event = (Event)this.events.get(name);
        if (event != null) {
            event.terminate();
        }
    }

    public void dump(PrintStream out) {
        for (int i = 0; i < this.timeline.size(); ++i) {
            String name = (String)this.timeline.elementAt(i);
            Event event = (Event)this.events.get(name);
            out.println(event);
        }
    }

    class Event {
        String name;
        long start;
        long end;

        Event(String name) {
            this.name = name;
            this.start = System.currentTimeMillis();
        }

        void terminate() {
            this.end = System.currentTimeMillis();
        }

        public String toString() {
            long now = System.currentTimeMillis();
            if (this.end == 0L) {
                return " + " + (now - this.start) + " " + this.name;
            }
            return "   " + (this.end - this.start) + " " + this.name;
        }
    }
}

