/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class SystemProperties
extends Properties {
    static final long cacheTime = 1500L;
    private SystemProperties defaultProps;
    private File file;
    private long lastread;
    private long lastcheck;
    private long lastadd;
    private HashMap additionalProps = null;
    private boolean ignoreCase = true;

    public SystemProperties() {
        this(null, null);
    }

    public SystemProperties(String filename) {
        this(filename, null);
    }

    public SystemProperties(SystemProperties defaultProps) {
        this(null, defaultProps);
    }

    public SystemProperties(String filename, SystemProperties defaultProps) {
        super(defaultProps);
        this.defaultProps = defaultProps;
        this.file = filename == null ? null : new File(filename);
        this.lastadd = 0L;
        this.lastread = 0L;
        this.lastcheck = 0L;
    }

    public long lastModified() {
        if (this.file == null || !this.file.exists()) {
            return this.lastadd;
        }
        return Math.max(this.file.lastModified(), this.lastadd);
    }

    public void update() {
        this.checkFile();
    }

    public long getChecksum() {
        if (this.defaultProps == null) {
            return this.lastModified();
        }
        return this.lastModified() + this.defaultProps.lastModified();
    }

    private void checkFile() {
        if (this.file != null && this.file.lastModified() > this.lastread) {
            this.reload();
        }
        this.lastcheck = System.currentTimeMillis();
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reload() {
        this.clear();
        if (this.file != null && this.file.exists()) {
            FileInputStream bpin = null;
            try {
                bpin = new FileInputStream(this.file);
                this.load(bpin);
            }
            catch (Exception x) {
                System.err.println("Error reading properties from file " + this.file + ": " + x);
            }
            finally {
                try {
                    bpin.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.additionalProps != null) {
            Iterator i = this.additionalProps.values().iterator();
            while (i.hasNext()) {
                this.putAll((Map<?, ?>)((Properties)i.next()));
            }
        }
        this.lastread = System.currentTimeMillis();
    }

    public synchronized void addProps(String key, InputStream in) throws IOException {
        SystemProperties newProps = new SystemProperties();
        newProps.load(in);
        if (this.additionalProps == null) {
            this.additionalProps = new HashMap();
        }
        this.additionalProps.put(key, newProps);
        this.reload();
        this.lastadd = System.currentTimeMillis();
    }

    public synchronized void removeProps(String key) {
        Object p;
        if (this.additionalProps != null && (p = this.additionalProps.remove(key)) != null) {
            this.reload();
            this.lastadd = System.currentTimeMillis();
        }
    }

    public Object put(Object key, Object value) {
        if (value != null) {
            value = value.toString().trim();
        }
        return super.put(this.ignoreCase ? key.toString().toLowerCase() : key, value);
    }

    public Object get(Object key) {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.get(this.ignoreCase ? key.toString().toLowerCase() : key);
    }

    public Object remove(Object key) {
        return super.remove(this.ignoreCase ? key.toString().toLowerCase() : key);
    }

    public boolean contains(Object obj) {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.contains(obj);
    }

    public boolean containsKey(Object key) {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.containsKey(this.ignoreCase ? key.toString().toLowerCase() : key);
    }

    public boolean isEmpty() {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.isEmpty();
    }

    public String getProperty(String name) {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.getProperty(this.ignoreCase ? name.toLowerCase() : name);
    }

    public String getProperty(String name, String defaultValue) {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.getProperty(this.ignoreCase ? name.toLowerCase() : name.toLowerCase(), defaultValue);
    }

    public Enumeration keys() {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.keys();
    }

    public Set keySet() {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.keySet();
    }

    public Enumeration elements() {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.elements();
    }

    public int size() {
        if (System.currentTimeMillis() - this.lastcheck > 1500L) {
            this.checkFile();
        }
        return super.size();
    }

    public String toString() {
        return super.toString();
    }

    public void setIgnoreCase(boolean ignore) {
        if (!super.isEmpty()) {
            throw new RuntimeException("setIgnoreCase() can only be called on empty Properties");
        }
        this.ignoreCase = ignore;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }
}

