/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import helma.framework.core.Application;
import helma.framework.repository.Repository;
import helma.framework.repository.Resource;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class ResourceProperties
extends Properties {
    private final long CACHE_TIME = 1500L;
    protected ResourceProperties defaultProperties;
    private boolean ignoreCase = true;
    private long lastChecksum = 0L;
    private long lastCheck = 0L;
    private long lastModified = 0L;
    private Application app;
    private String resourceName;
    private Set resources;
    private Properties keyMap = new Properties();

    public ResourceProperties() {
        this.resources = new HashSet();
    }

    public ResourceProperties(Application app) {
        this.resources = new TreeSet(app.getResourceComparator());
    }

    public ResourceProperties(Application app, String resourceName) {
        this.app = app;
        this.resourceName = resourceName;
        this.resources = new TreeSet(app.getResourceComparator());
    }

    public ResourceProperties(Application app, String resourceName, ResourceProperties defaultProperties) {
        this(app, resourceName);
        this.defaultProperties = defaultProperties;
        this.forceUpdate();
    }

    public ResourceProperties(Application app, String resourceName, ResourceProperties defaultProperties, boolean ignoreCase) {
        this(app, resourceName);
        this.defaultProperties = defaultProperties;
        this.ignoreCase = ignoreCase;
        this.forceUpdate();
    }

    private void forceUpdate() {
        this.lastChecksum = -1L;
        this.update();
    }

    public void setDefaultProperties(ResourceProperties defaultProperties) {
        this.defaultProperties = defaultProperties;
        this.update();
    }

    public void addResource(Resource resource) {
        if (resource != null && !this.resources.contains(resource)) {
            this.resources.add(resource);
            this.forceUpdate();
        }
    }

    public void removeResource(Resource resource) {
        if (this.resources.contains(resource)) {
            this.resources.remove(resource);
            this.forceUpdate();
        }
    }

    public Iterator getResources() {
        return this.resources.iterator();
    }

    public synchronized void update() {
        this.lastCheck = System.currentTimeMillis();
        if (this.getChecksum() != this.lastChecksum) {
            Iterator iterator;
            ResourceProperties temp = new ResourceProperties();
            temp.setIgnoreCase(this.ignoreCase);
            if (this.defaultProperties != null) {
                this.defaultProperties.update();
                temp.putAll((Map<?, ?>)this.defaultProperties);
            }
            if (this.resourceName != null) {
                iterator = this.app.getRepositories().iterator();
                while (iterator.hasNext()) {
                    try {
                        Repository repository = (Repository)iterator.next();
                        Resource res = repository.getResource(this.resourceName);
                        if (res == null || !res.exists()) continue;
                        temp.load(res.getInputStream());
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                    }
                }
            }
            if (this.resources != null) {
                iterator = this.resources.iterator();
                while (iterator.hasNext()) {
                    try {
                        Resource res = (Resource)iterator.next();
                        if (!res.exists()) continue;
                        temp.load(res.getInputStream());
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                    }
                }
            }
            this.putAll((Map<?, ?>)temp);
            Iterator<Object> it = super.keySet().iterator();
            while (it.hasNext()) {
                if (temp.containsKey(it.next())) continue;
                it.remove();
            }
            this.keyMap = temp.keyMap;
            this.lastChecksum = this.getChecksum();
            this.lastCheck = this.lastModified = System.currentTimeMillis();
        }
    }

    public ResourceProperties getSubProperties(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        ResourceProperties subprops = new ResourceProperties();
        subprops.setIgnoreCase(this.ignoreCase);
        Iterator<Map.Entry<Object, Object>> it = this.entrySet().iterator();
        int prefixLength = prefix.length();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String key = entry.getKey().toString();
            if (!key.regionMatches(this.ignoreCase, 0, prefix, 0, prefixLength)) continue;
            subprops.put(key.substring(prefixLength), entry.getValue());
        }
        return subprops;
    }

    public boolean contains(Object value) {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        return super.contains(value.toString());
    }

    public boolean containsKey(Object key) {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        if (this.ignoreCase) {
            return this.keyMap.containsKey(key.toString().toLowerCase());
        }
        return super.containsKey(key.toString());
    }

    public Enumeration elements() {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        return super.elements();
    }

    public Object get(Object key) {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        String strkey = key.toString();
        if (this.ignoreCase && (strkey = this.keyMap.getProperty(strkey.toLowerCase())) == null) {
            return null;
        }
        return (String)super.get(strkey);
    }

    public long lastModified() {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        return this.lastModified;
    }

    public long getChecksum() {
        Iterator iterator;
        long checksum = 0L;
        if (this.resourceName != null) {
            iterator = this.app.getRepositories().iterator();
            while (iterator.hasNext()) {
                Repository repository = (Repository)iterator.next();
                Resource resource = repository.getResource(this.resourceName);
                if (resource == null) continue;
                checksum += resource.lastModified();
            }
        }
        if (this.resources != null) {
            iterator = this.resources.iterator();
            while (iterator.hasNext()) {
                checksum += ((Resource)iterator.next()).lastModified();
            }
        }
        if (this.defaultProperties != null) {
            checksum += this.defaultProperties.getChecksum();
        }
        return checksum;
    }

    public String getProperty(String key, String defaultValue) {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        if (this.ignoreCase && (key = this.keyMap.getProperty(key.toLowerCase())) == null) {
            return defaultValue;
        }
        return super.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        if (this.ignoreCase && (key = this.keyMap.getProperty(key.toLowerCase())) == null) {
            return null;
        }
        return super.getProperty(key);
    }

    public boolean isEmpty() {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        return super.isEmpty();
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Enumeration keys() {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        return super.keys();
    }

    public Set keySet() {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        return super.keySet();
    }

    public Object put(Object key, Object value) {
        if (value != null) {
            value = value.toString().trim();
        }
        String strkey = key.toString();
        if (this.ignoreCase) {
            this.keyMap.put(strkey.toLowerCase(), strkey);
        }
        return super.put(strkey, value);
    }

    public Object remove(Object key) {
        String strkey = key.toString();
        if (this.ignoreCase && (strkey = (String)this.keyMap.remove(strkey.toLowerCase())) == null) {
            return null;
        }
        return super.remove(strkey);
    }

    public void setIgnoreCase(boolean ignore) {
        if (!super.isEmpty()) {
            throw new RuntimeException("setIgnoreCase() can only be called on empty Properties");
        }
        this.ignoreCase = ignore;
    }

    public int size() {
        if (System.currentTimeMillis() - this.lastCheck > 1500L) {
            this.update();
        }
        return super.size();
    }

    public void clear() {
        this.keyMap.clear();
        super.clear();
    }

    public String toString() {
        return super.toString();
    }
}

