/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import helma.util.InetAddressFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ParanoidServerSocket
extends ServerSocket {
    private InetAddressFilter filter;

    public ParanoidServerSocket(int port) throws IOException {
        super(port);
    }

    public ParanoidServerSocket(int port, InetAddressFilter filter) throws IOException {
        super(port);
        this.filter = filter;
    }

    public Socket accept() throws IOException {
        Socket s = null;
        while (s == null) {
            s = super.accept();
            if (this.filter == null || this.filter.matches(s.getInetAddress())) continue;
            System.err.println("Refusing connection from " + s.getInetAddress());
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            s = null;
        }
        return s;
    }

    public void setFilter(InetAddressFilter filter) {
        this.filter = filter;
    }

    public InetAddressFilter getFilter() {
        return this.filter;
    }
}

