/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.fileupload.FileItem;

public class MimePart
implements Serializable {
    private final String name;
    private int contentLength;
    private String contentType;
    private byte[] content;
    private Date lastModified;
    private String eTag;
    private FileItem fileItem;

    public MimePart(String name, byte[] content, String contentType) {
        this.name = MimePart.normalizeFilename(name);
        this.content = content == null ? new byte[]{} : content;
        this.contentType = contentType;
        this.contentLength = content == null ? 0 : content.length;
    }

    public MimePart(FileItem fileItem) {
        this.name = MimePart.normalizeFilename(fileItem.getName());
        this.contentType = fileItem.getContentType();
        this.contentLength = (int)fileItem.getSize();
        if (fileItem.isInMemory()) {
            this.content = fileItem.get();
        } else {
            this.fileItem = fileItem;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getContent() {
        if (this.content == null && this.fileItem != null) {
            this.loadContent();
        }
        return this.content;
    }

    private synchronized void loadContent() {
        this.content = new byte[this.contentLength];
        try {
            int r;
            InputStream in = this.fileItem.getInputStream();
            for (int read = 0; read < this.contentLength && (r = in.read(this.content, read, this.contentLength - read)) != -1; read += r) {
            }
            in.close();
        }
        catch (IOException iox) {
            this.content = new byte[0];
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.fileItem != null) {
            return this.fileItem.getInputStream();
        }
        return new ByteArrayInputStream(this.getContent());
    }

    public String getText() {
        if (this.contentType == null || this.contentType.startsWith("text/") || this.contentType.startsWith("application/text")) {
            String charset = MimePart.getSubHeader(this.contentType, "charset");
            byte[] content = this.getContent();
            if (charset != null) {
                try {
                    return new String(content, charset);
                }
                catch (UnsupportedEncodingException uee) {
                    return new String(content);
                }
            }
            return new String(content);
        }
        return null;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String writeToFile(String dir) {
        return this.writeToFile(dir, null);
    }

    public String writeToFile(String dir, String fname) {
        try {
            File base = new File(dir);
            if (!base.exists()) {
                base.mkdirs();
            }
            String filename = this.name;
            if (fname != null) {
                if (fname.indexOf(".") < 0) {
                    int ndot;
                    int n = ndot = this.name == null ? -1 : this.name.lastIndexOf(".");
                    filename = ndot > -1 ? fname + this.name.substring(ndot) : fname;
                } else {
                    filename = fname;
                }
            }
            File file = new File(base, filename);
            if (this.fileItem != null) {
                this.fileItem.write(file);
            } else {
                FileOutputStream fout = new FileOutputStream(file);
                fout.write(this.getContent());
                fout.close();
            }
            return filename;
        }
        catch (Exception x) {
            return null;
        }
    }

    public static String getSubHeader(String header, String subHeaderName) {
        if (header == null) {
            return null;
        }
        StringTokenizer headerTokenizer = new StringTokenizer(header, ";");
        while (headerTokenizer.hasMoreTokens()) {
            String hname;
            String token = headerTokenizer.nextToken().trim();
            int i = token.indexOf("=");
            if (i <= 0 || !(hname = token.substring(0, i).trim()).equalsIgnoreCase(subHeaderName)) continue;
            String value = token.substring(i + 1);
            return value.replace('\"', ' ').trim();
        }
        return null;
    }

    public static String normalizeFilename(String filename) {
        if (filename == null) {
            return null;
        }
        int idx = filename.lastIndexOf(47);
        if (idx > -1) {
            filename = filename.substring(idx + 1);
        }
        if ((idx = filename.lastIndexOf(92)) > -1) {
            filename = filename.substring(idx + 1);
        }
        return filename;
    }
}

