/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import helma.util.FileLogger;
import helma.util.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class Logging
extends LogFactory {
    static Runner runner;
    static ArrayList loggers;
    static HashMap loggerMap;
    String logdir = System.getProperty("helma.logdir", "log");
    static Logger consoleLog;

    public Log getInstance(String logname) {
        if (logname == null) {
            throw new LogConfigurationException("No logname specified!");
        }
        if ("console".equals(this.logdir)) {
            return Logging.getConsoleLog();
        }
        return this.getFileLog(logname);
    }

    public static Log getConsoleLog() {
        Logging.ensureRunning();
        return consoleLog;
    }

    public synchronized Logger getFileLog(String logname) {
        Logger log = (Logger)loggerMap.get(logname);
        if (log == null) {
            log = new FileLogger(this.logdir, logname);
            loggerMap.put(logname, log);
            loggers.add(log);
        }
        Logging.ensureRunning();
        return log;
    }

    public synchronized Log getInstance(Class clazz) {
        return this.getInstance(clazz.getPackage().getName());
    }

    public void setAttribute(String name, Object value) {
    }

    public Object getAttribute(String name) {
        if ("logdir".equals(name)) {
            return this.logdir;
        }
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public void removeAttribute(String parm1) {
    }

    public void release() {
        Logging.shutdown();
    }

    public static synchronized void ensureRunning() {
        if (runner == null || !runner.isAlive()) {
            runner = new Runner();
            runner.setDaemon(true);
            runner.start();
        }
    }

    public static synchronized void shutdown() {
        if (runner != null && runner.isAlive()) {
            runner.interrupt();
        }
        runner = null;
        Thread.yield();
        Logging.closeAll();
    }

    static void closeAll() {
        consoleLog.write();
        int nloggers = loggers.size();
        for (int i = nloggers - 1; i >= 0; --i) {
            FileLogger log = (FileLogger)loggers.get(i);
            log.write();
            log.closeFile();
        }
        loggers.clear();
        loggerMap.clear();
        consoleLog = null;
    }

    static void rotateLogs() {
        int nloggers = loggers.size();
        ArrayList<File> files = new ArrayList<File>(nloggers);
        for (int i = nloggers - 1; i >= 0; --i) {
            FileLogger log = (FileLogger)loggers.get(i);
            try {
                File file = log.rotateLogFile();
                if (file == null) continue;
                files.add(file);
                continue;
            }
            catch (IOException io) {
                System.err.println("Error rotating log " + log.getName() + ": " + io.toString());
            }
        }
        if (!files.isEmpty()) {
            new FileLogger.GZipper(files).start();
        }
    }

    static long nextMidnight() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1 + cal.get(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 1);
        return cal.getTime().getTime();
    }

    static long lastMidnight() {
        return Logging.nextMidnight() - 86400000L;
    }

    static {
        loggers = new ArrayList();
        loggerMap = new HashMap();
        consoleLog = new Logger(System.out);
    }

    static class Runner
    extends Thread {
        Runner() {
        }

        public synchronized void run() {
            long nextMidnight = Logging.nextMidnight();
            while (runner == this && !this.isInterrupted()) {
                long now = System.currentTimeMillis();
                if (nextMidnight < now) {
                    Logging.rotateLogs();
                    nextMidnight = Logging.nextMidnight();
                }
                consoleLog.write();
                int nloggers = loggers.size();
                for (int i = nloggers - 1; i >= 0; --i) {
                    try {
                        FileLogger log = (FileLogger)loggers.get(i);
                        log.write();
                        if (now - log.lastMessage <= 1800000L) continue;
                        log.closeFile();
                        continue;
                    }
                    catch (Exception x) {
                        System.err.println("Error in Logger main loop: " + x);
                    }
                }
                try {
                    this.wait(333L);
                }
                catch (InterruptedException ix) {
                    break;
                }
            }
        }
    }
}

