/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;

public class Logger
implements Log {
    List entries = Collections.synchronizedList(new LinkedList());
    PrintWriter writer;
    String canonicalName;
    static DateFormat dformat = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss] ");
    static long dateLastRendered;
    static String dateCache;
    public static final int TRACE = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    public static final int WARN = 4;
    public static final int ERROR = 5;
    public static final int FATAL = 6;
    int logLevel = 3;
    long lastMessage = System.currentTimeMillis();

    Logger() {
        this.init();
    }

    protected Logger(PrintStream out) {
        this.init();
        this.writer = new PrintWriter(out);
        this.canonicalName = out.toString();
    }

    private void init() {
        String level = System.getProperty("helma.loglevel");
        if ("trace".equalsIgnoreCase(level)) {
            this.logLevel = 1;
        } else if ("debug".equalsIgnoreCase(level)) {
            this.logLevel = 2;
        } else if ("info".equalsIgnoreCase(level)) {
            this.logLevel = 3;
        } else if ("warn".equalsIgnoreCase(level)) {
            this.logLevel = 4;
        } else if ("error".equalsIgnoreCase(level)) {
            this.logLevel = 5;
        } else if ("fatal".equalsIgnoreCase(level)) {
            this.logLevel = 6;
        }
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.canonicalName + "," + this.logLevel + "]";
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    protected void log(String level, Object msg, Throwable exception) {
        this.lastMessage = System.currentTimeMillis();
        if (this.lastMessage - 1000L > dateLastRendered) {
            Logger.renderDate();
        }
        if (this.entries.size() < 2000) {
            String message = msg == null ? "null" : msg.toString();
            this.entries.add(new Entry(dateCache, level, message, exception));
        }
    }

    protected synchronized void write() {
        block4: {
            if (this.entries.isEmpty()) {
                return;
            }
            try {
                this.ensureOpen();
                int l = this.entries.size();
                for (int i = 0; i < l; ++i) {
                    Entry entry = (Entry)this.entries.remove(0);
                    this.writer.print(entry.date);
                    this.writer.print(entry.level);
                    this.writer.println(entry.message);
                    if (entry.exception == null) continue;
                    entry.exception.printStackTrace(this.writer);
                }
                this.writer.flush();
            }
            catch (Exception x) {
                int size = this.entries.size();
                if (size <= 1000) break block4;
                System.err.println("Error writing log file " + this + ": " + x);
                System.err.println("Discarding " + size + " log entries.");
                this.entries.clear();
            }
        }
    }

    protected void ensureOpen() {
    }

    protected static synchronized void renderDate() {
        Date date = new Date();
        dateCache = dformat.format(date);
        dateLastRendered = date.getTime();
    }

    public boolean isTraceEnabled() {
        return this.logLevel <= 1;
    }

    public boolean isDebugEnabled() {
        return this.logLevel <= 2;
    }

    public boolean isInfoEnabled() {
        return this.logLevel <= 3;
    }

    public boolean isWarnEnabled() {
        return this.logLevel <= 4;
    }

    public boolean isErrorEnabled() {
        return this.logLevel <= 5;
    }

    public boolean isFatalEnabled() {
        return this.logLevel <= 6;
    }

    public void trace(Object parm1) {
        if (this.logLevel <= 1) {
            this.log("[TRACE] ", parm1, null);
        }
    }

    public void trace(Object parm1, Throwable parm2) {
        if (this.logLevel <= 1) {
            this.log("[TRACE] ", parm1, parm2);
        }
    }

    public void debug(Object parm1) {
        if (this.logLevel <= 2) {
            this.log("[DEBUG] ", parm1, null);
        }
    }

    public void debug(Object parm1, Throwable parm2) {
        if (this.logLevel <= 2) {
            this.log("[DEBUG] ", parm1, parm2);
        }
    }

    public void info(Object parm1) {
        if (this.logLevel <= 3) {
            this.log("[INFO] ", parm1, null);
        }
    }

    public void info(Object parm1, Throwable parm2) {
        if (this.logLevel <= 3) {
            this.log("[INFO] ", parm1, parm2);
        }
    }

    public void warn(Object parm1) {
        if (this.logLevel <= 4) {
            this.log("[WARN] ", parm1, null);
        }
    }

    public void warn(Object parm1, Throwable parm2) {
        if (this.logLevel <= 4) {
            this.log("[WARN] ", parm1, parm2);
        }
    }

    public void error(Object parm1) {
        if (this.logLevel <= 5) {
            this.log("[ERROR] ", parm1, null);
        }
    }

    public void error(Object parm1, Throwable parm2) {
        if (this.logLevel <= 5) {
            this.log("[ERROR] ", parm1, parm2);
        }
    }

    public void fatal(Object parm1) {
        if (this.logLevel <= 6) {
            this.log("[FATAL] ", parm1, null);
        }
    }

    public void fatal(Object parm1, Throwable parm2) {
        if (this.logLevel <= 6) {
            this.log("[FATAL] ", parm1, parm2);
        }
    }

    public static String getStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        writer.close();
        return stringWriter.toString();
    }

    class Entry {
        final String date;
        final String level;
        final String message;
        final Throwable exception;

        Entry(String date, String level, String message, Throwable exception) {
            this.date = date;
            this.level = level;
            this.message = message;
            this.exception = exception;
        }
    }
}

