/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.io.IOException;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class InetAddressFilter {
    private Vector patterns = new Vector();

    public void addAddress(String address) throws IOException {
        boolean v6 = false;
        String separator = ".";
        int length = 4;
        int loop = 4;
        if (address.indexOf(":") > -1) {
            v6 = true;
            separator = ":.";
            length = 16;
            loop = 8;
        }
        int[] pattern = new int[length];
        StringTokenizer st = new StringTokenizer(address, separator);
        if (st.countTokens() != loop) {
            throw new IOException("\"" + address + "\" does not represent a valid IP address");
        }
        for (int i = 0; i < loop; ++i) {
            String next = st.nextToken();
            if (v6) {
                if ("*".equals(next)) {
                    pattern[i * 2 + 1] = 256;
                    pattern[i * 2] = 256;
                    continue;
                }
                if (next.length() == 0) {
                    pattern[i * 2 + 1] = 0;
                    pattern[i * 2] = 0;
                    continue;
                }
                int n = Integer.parseInt(next, 16);
                pattern[i * 2] = (byte)((n & 0xFF00) >> 8);
                pattern[i * 2 + 1] = (byte)(n & 0xFF);
                continue;
            }
            pattern[i] = "*".equals(next) ? 256 : (int)((byte)Integer.parseInt(next));
        }
        this.patterns.addElement(pattern);
    }

    public boolean matches(InetAddress address) {
        if (address == null) {
            return false;
        }
        byte[] add = address.getAddress();
        if (add == null) {
            return false;
        }
        int l = this.patterns.size();
        for (int k = 0; k < l; ++k) {
            int[] pattern = (int[])this.patterns.elementAt(k);
            if (pattern.length != add.length) continue;
            for (int i = 0; i < add.length && (pattern[i] >= 255 || pattern[i] == add[i]); ++i) {
                if (i != add.length - 1) continue;
                return true;
            }
        }
        return false;
    }
}

