/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public final class HtmlEncoder {
    static final String[] transform = new String[]{"&euro;", "", "&#8218;", "&#402;", "&#8222;", "&#8230;", "&#8224;", "&#8225;", "&#710;", "&#8240;", "&#352;", "&#8249;", "&#338;", "", "&#381;", "", "", "&#8216;", "&#8217;", "&#8220;", "&#8221;", "&#8226;", "&#8211;", "&#8212;", "&#732;", "&#8482;", "&#353;", "&#8250;", "&#339;", "", "&#382;", "&#376;", "&nbsp;", "&iexcl;", "&cent;", "&pound;", "&curren;", "&yen;", "&brvbar;", "&sect;", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "&shy;", "&reg;", "&macr;", "&deg;", "&plusmn;", "&sup2;", "&sup3;", "&acute;", "&micro;", "&para;", "&middot;", "&cedil;", "&sup1;", "&ordm;", "&raquo;", "&frac14;", "&frac12;", "&frac34;", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&times;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&yacute;", "&thorn;", "&yuml;"};
    static final HashSet allTags = new HashSet();
    static final HashSet internalTags;
    static final HashSet blockTags;
    static final HashSet semiBlockTags;
    static final HashSet emptyTags;
    static final byte TAG_NAME = 0;
    static final byte TAG_SPACE = 1;
    static final byte TAG_ATT_NAME = 2;
    static final byte TAG_ATT_VAL = 3;
    static final byte TEXT = 0;
    static final byte SEMIBLOCK = 1;
    static final byte BLOCK = 2;
    static final byte INTERNAL = 3;
    static final String newLine;

    public static final String encode(String str) {
        if (str == null) {
            return null;
        }
        int l = str.length();
        if (l == 0) {
            return "";
        }
        StringBuffer ret = new StringBuffer(Math.round((float)l * 1.4f));
        HtmlEncoder.encode(str, ret, false, null);
        return ret.toString();
    }

    public static final void encode(String str, StringBuffer ret) {
        HtmlEncoder.encode(str, ret, false, null);
    }

    public static final void encode(String str, StringBuffer ret, boolean paragraphs, Set allowedTags) {
        if (str == null) {
            return;
        }
        int l = str.length();
        int paragraphStart = ret.length();
        int entering = 0;
        int exiting = 0;
        Stack<String> openTags = new Stack<String>();
        boolean insideTag = false;
        boolean insideHtmlTag = false;
        boolean insideCloseTag = false;
        int htmlTagMode = 0;
        boolean insideCodeTag = false;
        boolean insidePreTag = false;
        boolean insideMacroTag = false;
        boolean insideComment = false;
        char htmlQuoteChar = '\u0000';
        char macroQuoteChar = '\u0000';
        int linebreaks = 0;
        boolean escape = false;
        boolean triggerBreak = false;
        block15: for (int i = 0; i < l; ++i) {
            char c = str.charAt(i);
            if (c == '<' && i < l - 2) {
                if (!insideMacroTag && '%' == str.charAt(i + 1)) {
                    if (!insideCodeTag) {
                        insideTag = true;
                        insideMacroTag = true;
                        macroQuoteChar = '\u0000';
                    }
                } else if ('!' == str.charAt(i + 1)) {
                    if (!insideCodeTag) {
                        if (str.regionMatches(i + 2, "--", 0, 2)) {
                            insideTag = true;
                            insideComment = true;
                        } else if (str.regionMatches(true, i + 2, "doctype", 0, 7)) {
                            insideTag = true;
                            insideHtmlTag = true;
                        }
                    }
                } else if (!insideTag) {
                    int tagStart;
                    int j;
                    insideCloseTag = '/' == str.charAt(i + 1);
                    for (j = tagStart = insideCloseTag ? i + 2 : i + 1; j < l && Character.isLetterOrDigit(str.charAt(j)); ++j) {
                    }
                    if (j > tagStart && j < l) {
                        String tagName = str.substring(tagStart, j).toLowerCase();
                        if ("code".equals(tagName) && insideCloseTag && insideCodeTag) {
                            insideCodeTag = false;
                        }
                        if ((allowedTags == null || allowedTags.contains(tagName)) && allTags.contains(tagName) && !insideCodeTag) {
                            insideTag = true;
                            insideHtmlTag = true;
                            htmlQuoteChar = '\u0000';
                            htmlTagMode = 0;
                            exiting = entering;
                            entering = 0;
                            if (internalTags.contains(tagName)) {
                                entering = 3;
                            } else if (blockTags.contains(tagName)) {
                                entering = 2;
                            } else if (semiBlockTags.contains(tagName)) {
                                int n = entering = paragraphs ? 2 : 1;
                            }
                            if (entering > 0) {
                                boolean bl = triggerBreak = !insidePreTag;
                            }
                            if (insideCloseTag) {
                                int t = openTags.search(tagName);
                                if (t == -1) {
                                    i = j;
                                    insideTag = false;
                                    insideHtmlTag = false;
                                    continue;
                                }
                                if (t > 1) {
                                    for (int k = 1; k < t; ++k) {
                                        Object tag = openTags.pop();
                                        if (emptyTags.contains(tag)) continue;
                                        ret.append("</");
                                        ret.append(tag);
                                        ret.append(">");
                                    }
                                }
                                openTags.pop();
                            } else {
                                openTags.push(tagName);
                            }
                            if ("code".equals(tagName) && !insideCloseTag) {
                                insideCodeTag = true;
                            }
                            if ("pre".equals(tagName)) {
                                boolean bl = insidePreTag = !insideCloseTag;
                            }
                        }
                    }
                }
            }
            if ((triggerBreak || linebreaks > 0) && !Character.isWhitespace(c)) {
                if (!insideTag) {
                    exiting = entering;
                    entering = 0;
                    if (exiting >= 1) {
                        paragraphStart = ret.length();
                    }
                }
                if (entering != 3 && exiting != 3) {
                    int swallowBreaks = 0;
                    if (paragraphs && (entering != 2 || exiting != 2) && exiting < 2 && linebreaks > 1 && paragraphStart < ret.length()) {
                        ret.insert(paragraphStart, "<p>");
                        ret.append("</p>");
                        swallowBreaks = 2;
                    }
                    int _entering = entering == 1 ? 0 : entering;
                    for (int k = linebreaks - 1; k >= 0; --k) {
                        if (k >= swallowBreaks && k >= _entering && k >= exiting) {
                            ret.append("<br />");
                        }
                        ret.append(newLine);
                    }
                    if (exiting >= 1 || linebreaks > 1) {
                        paragraphStart = ret.length();
                    }
                }
                linebreaks = 0;
                triggerBreak = false;
            }
            switch (c) {
                case '<': {
                    if (insideTag) {
                        ret.append('<');
                        continue block15;
                    }
                    ret.append("&lt;");
                    continue block15;
                }
                case '&': {
                    if (i < l - 3 && !insideCodeTag) {
                        int j;
                        if (str.charAt(i + 1) == '#') {
                            for (j = i + 2; j < l && Character.isDigit(str.charAt(j)); ++j) {
                            }
                            if (j < l && str.charAt(j) == ';') {
                                ret.append("&");
                                continue block15;
                            }
                        } else {
                            for (j = i + 1; j < l && Character.isLetterOrDigit(str.charAt(j)); ++j) {
                            }
                            if (j < l && str.charAt(j) == ';') {
                                ret.append("&");
                                continue block15;
                            }
                        }
                    }
                    ret.append("&amp;");
                    continue block15;
                }
                case '\\': {
                    ret.append(c);
                    if (!insideTag || insideComment) continue block15;
                    escape = !escape;
                    continue block15;
                }
                case '\"': 
                case '\'': {
                    ret.append(c);
                    if (insideComment) continue block15;
                    if (insideMacroTag) {
                        if (escape) {
                            escape = false;
                            continue block15;
                        }
                        if (macroQuoteChar == c) {
                            macroQuoteChar = '\u0000';
                            continue block15;
                        }
                        if (macroQuoteChar != '\u0000') continue block15;
                        macroQuoteChar = c;
                        continue block15;
                    }
                    if (!insideHtmlTag) continue block15;
                    if (escape) {
                        escape = false;
                        continue block15;
                    }
                    if (htmlQuoteChar == c) {
                        htmlQuoteChar = '\u0000';
                        htmlTagMode = 1;
                        continue block15;
                    }
                    if (htmlQuoteChar != '\u0000') continue block15;
                    htmlQuoteChar = c;
                    continue block15;
                }
                case '\n': {
                    if (insideTag || insidePreTag) {
                        ret.append('\n');
                        continue block15;
                    }
                    ++linebreaks;
                    continue block15;
                }
                case '\r': {
                    if (!insideTag && !insidePreTag) continue block15;
                    ret.append('\r');
                    continue block15;
                }
                case '>': {
                    if (insideComment) {
                        ret.append('>');
                        insideComment = str.charAt(i - 2) != '-' || str.charAt(i - 1) != '-';
                    } else if (insideMacroTag) {
                        ret.append('>');
                        insideMacroTag = str.charAt(i - 1) != '%' || macroQuoteChar != '\u0000';
                    } else if (insideHtmlTag) {
                        ret.append('>');
                        boolean bl = insideHtmlTag = htmlQuoteChar != '\u0000';
                        if (str.charAt(i - 1) == '/' && !openTags.empty() && htmlTagMode != 3 && htmlTagMode != 2) {
                            openTags.pop();
                        }
                        if ((exiting = entering) > 0) {
                            triggerBreak = !insidePreTag;
                        }
                    } else {
                        ret.append("&gt;");
                    }
                    insideCloseTag = insideTag = insideComment || insideMacroTag || insideHtmlTag;
                    continue block15;
                }
                default: {
                    if (insideHtmlTag && !insideCloseTag) {
                        switch (htmlTagMode) {
                            case 0: {
                                if (Character.isLetterOrDigit(c)) break;
                                htmlTagMode = 1;
                                break;
                            }
                            case 1: {
                                if (!Character.isLetterOrDigit(c)) break;
                                htmlTagMode = 2;
                                break;
                            }
                            case 2: {
                                if (c == '=') {
                                    htmlTagMode = 3;
                                    break;
                                }
                                if (c != ' ') break;
                                htmlTagMode = 1;
                                break;
                            }
                            case 3: {
                                if (!Character.isWhitespace(c) || htmlQuoteChar != '\u0000') break;
                                htmlTagMode = 1;
                            }
                        }
                    }
                    if (c < '\u0080') {
                        ret.append(c);
                    } else if (c >= '\u0080' && c < '\u0100') {
                        ret.append(transform[c - 128]);
                    } else {
                        ret.append("&#");
                        ret.append((int)c);
                        ret.append(";");
                    }
                    escape = false;
                }
            }
        }
        int o = openTags.size();
        if (o > 0) {
            for (int k = 0; k < o; ++k) {
                Object tag = openTags.pop();
                if (emptyTags.contains(tag)) continue;
                ret.append("</");
                ret.append(tag);
                ret.append(">");
            }
        }
        int swallowBreaks = 0;
        if (paragraphs && entering < 2) {
            ret.insert(paragraphStart, "<p>");
            ret.append("</p>");
            swallowBreaks = 2;
        }
        if (linebreaks > 0) {
            for (int i = linebreaks - 1; i >= 0; --i) {
                if (i >= swallowBreaks && i > exiting) {
                    ret.append("<br />");
                }
                ret.append(newLine);
            }
        }
    }

    public static final String encodeFormValue(String str) {
        if (str == null) {
            return null;
        }
        int l = str.length();
        if (l == 0) {
            return "";
        }
        StringBuffer ret = new StringBuffer(Math.round((float)l * 1.2f));
        HtmlEncoder.encodeAll(str, ret, false);
        return ret.toString();
    }

    public static final void encodeFormValue(String str, StringBuffer ret) {
        HtmlEncoder.encodeAll(str, ret, false);
    }

    public static final String encodeAll(String str) {
        if (str == null) {
            return null;
        }
        int l = str.length();
        if (l == 0) {
            return "";
        }
        StringBuffer ret = new StringBuffer(Math.round((float)l * 1.2f));
        HtmlEncoder.encodeAll(str, ret, true);
        return ret.toString();
    }

    public static final void encodeAll(String str, StringBuffer ret) {
        HtmlEncoder.encodeAll(str, ret, true);
    }

    public static final void encodeAll(String str, StringBuffer ret, boolean encodeNewline) {
        if (str == null) {
            return;
        }
        int l = str.length();
        block7: for (int i = 0; i < l; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    ret.append("&lt;");
                    continue block7;
                }
                case '>': {
                    ret.append("&gt;");
                    continue block7;
                }
                case '&': {
                    ret.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    ret.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (encodeNewline) {
                        ret.append("<br />");
                    }
                    ret.append('\n');
                    continue block7;
                }
                default: {
                    if (c < '\u0080') {
                        ret.append(c);
                        continue block7;
                    }
                    if (c >= '\u0080' && c < '\u0100') {
                        ret.append(transform[c - 128]);
                        continue block7;
                    }
                    ret.append("&#");
                    ret.append((int)c);
                    ret.append(";");
                }
            }
        }
    }

    public static final String encodeXml(String str) {
        if (str == null) {
            return null;
        }
        int l = str.length();
        if (l == 0) {
            return "";
        }
        StringBuffer ret = new StringBuffer(Math.round((float)l * 1.2f));
        HtmlEncoder.encodeXml(str, ret);
        return ret.toString();
    }

    public static final void encodeXml(String str, StringBuffer ret) {
        if (str == null) {
            return;
        }
        int l = str.length();
        block7: for (int i = 0; i < l; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    ret.append("&lt;");
                    continue block7;
                }
                case '>': {
                    ret.append("&gt;");
                    continue block7;
                }
                case '&': {
                    ret.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    ret.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    ret.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c < ' ') {
                        if ((9728L >> c & 1L) == 0L) continue block7;
                        ret.append(c);
                        continue block7;
                    }
                    ret.append(c);
                }
            }
        }
    }

    public static String printCharRange(int from, int to) {
        StringBuffer response = new StringBuffer();
        for (int i = from; i < to; ++i) {
            response.append(i);
            response.append("      ");
            response.append((char)i);
            response.append("      ");
            if (i < 128) {
                response.append((char)i);
            } else if (i >= 128 && i < 256) {
                response.append(transform[i - 128]);
            } else {
                response.append("&#");
                response.append(i);
                response.append(";");
            }
            response.append("\r\n");
        }
        return response.toString();
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.err.println(HtmlEncoder.encode(args[i]));
        }
    }

    static {
        allTags.add("a");
        allTags.add("abbr");
        allTags.add("acronym");
        allTags.add("address");
        allTags.add("applet");
        allTags.add("area");
        allTags.add("b");
        allTags.add("base");
        allTags.add("basefont");
        allTags.add("bdo");
        allTags.add("bgsound");
        allTags.add("big");
        allTags.add("blink");
        allTags.add("blockquote");
        allTags.add("bq");
        allTags.add("body");
        allTags.add("br");
        allTags.add("button");
        allTags.add("caption");
        allTags.add("center");
        allTags.add("cite");
        allTags.add("code");
        allTags.add("col");
        allTags.add("colgroup");
        allTags.add("del");
        allTags.add("dfn");
        allTags.add("dir");
        allTags.add("div");
        allTags.add("dl");
        allTags.add("dt");
        allTags.add("dd");
        allTags.add("em");
        allTags.add("embed");
        allTags.add("fieldset");
        allTags.add("font");
        allTags.add("form");
        allTags.add("frame");
        allTags.add("frameset");
        allTags.add("h1");
        allTags.add("h2");
        allTags.add("h3");
        allTags.add("h4");
        allTags.add("h5");
        allTags.add("h6");
        allTags.add("head");
        allTags.add("html");
        allTags.add("hr");
        allTags.add("i");
        allTags.add("iframe");
        allTags.add("img");
        allTags.add("input");
        allTags.add("ins");
        allTags.add("isindex");
        allTags.add("kbd");
        allTags.add("label");
        allTags.add("legend");
        allTags.add("li");
        allTags.add("link");
        allTags.add("listing");
        allTags.add("map");
        allTags.add("marquee");
        allTags.add("menu");
        allTags.add("meta");
        allTags.add("nobr");
        allTags.add("noframes");
        allTags.add("noscript");
        allTags.add("object");
        allTags.add("ol");
        allTags.add("option");
        allTags.add("optgroup");
        allTags.add("p");
        allTags.add("param");
        allTags.add("plaintext");
        allTags.add("pre");
        allTags.add("q");
        allTags.add("s");
        allTags.add("samp");
        allTags.add("script");
        allTags.add("select");
        allTags.add("small");
        allTags.add("span");
        allTags.add("strike");
        allTags.add("strong");
        allTags.add("style");
        allTags.add("sub");
        allTags.add("sup");
        allTags.add("table");
        allTags.add("tbody");
        allTags.add("td");
        allTags.add("textarea");
        allTags.add("tfoot");
        allTags.add("th");
        allTags.add("thead");
        allTags.add("title");
        allTags.add("tr");
        allTags.add("tt");
        allTags.add("u");
        allTags.add("ul");
        allTags.add("var");
        allTags.add("wbr");
        allTags.add("xmp");
        internalTags = new HashSet();
        blockTags = new HashSet();
        semiBlockTags = new HashSet();
        semiBlockTags.add("address");
        semiBlockTags.add("dir");
        semiBlockTags.add("div");
        semiBlockTags.add("table");
        blockTags.add("blockquote");
        blockTags.add("center");
        blockTags.add("dl");
        blockTags.add("fieldset");
        blockTags.add("form");
        blockTags.add("h1");
        blockTags.add("h2");
        blockTags.add("h3");
        blockTags.add("h4");
        blockTags.add("h5");
        blockTags.add("h6");
        blockTags.add("hr");
        blockTags.add("isindex");
        blockTags.add("ol");
        blockTags.add("p");
        blockTags.add("pre");
        blockTags.add("ul");
        internalTags.add("menu");
        internalTags.add("noframes");
        internalTags.add("noscript");
        semiBlockTags.add("th");
        blockTags.add("br");
        blockTags.add("dd");
        blockTags.add("dt");
        blockTags.add("frameset");
        blockTags.add("li");
        blockTags.add("td");
        internalTags.add("tbody");
        internalTags.add("tfoot");
        internalTags.add("thead");
        internalTags.add("tr");
        emptyTags = new HashSet();
        emptyTags.add("area");
        emptyTags.add("base");
        emptyTags.add("basefont");
        emptyTags.add("br");
        emptyTags.add("col");
        emptyTags.add("frame");
        emptyTags.add("hr");
        emptyTags.add("img");
        emptyTags.add("input");
        emptyTags.add("isindex");
        emptyTags.add("link");
        emptyTags.add("meta");
        emptyTags.add("param");
        newLine = System.getProperty("line.separator");
    }
}

