/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import helma.util.Logger;
import helma.util.Logging;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;

public class FileLogger
extends Logger
implements Log {
    private String name;
    private File logdir;
    private File logfile;
    DecimalFormat nformat = new DecimalFormat("000");
    DateFormat aformat = new SimpleDateFormat("yyyy-MM-dd");

    protected FileLogger(String directory, String name) {
        this.name = name;
        this.logdir = new File(directory);
        if (!this.logdir.isAbsolute()) {
            this.logdir = this.logdir.getAbsoluteFile();
        }
        this.logfile = new File(this.logdir, name + ".log");
        if (!this.logdir.exists()) {
            this.logdir.mkdirs();
        }
    }

    private synchronized void openFile() {
        try {
            File archive;
            if (this.logfile.exists() && this.logfile.lastModified() < Logging.lastMidnight() && (archive = this.rotateLogFile()) != null) {
                new GZipper(archive).start();
            }
            this.writer = new PrintWriter((Writer)new FileWriter(this.logfile.getAbsolutePath(), true), false);
        }
        catch (IOException iox) {
            System.err.println("Error creating log " + this.name + ": " + iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeFile() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.writer = null;
            }
        }
    }

    protected synchronized void ensureOpen() {
        if (this.writer == null || !this.logfile.exists()) {
            this.openFile();
        }
    }

    protected synchronized File rotateLogFile() throws IOException {
        if (this.logfile == null) {
            return null;
        }
        this.closeFile();
        if (this.logfile.exists() && this.logfile.length() > 0L) {
            String today = this.aformat.format(new Date());
            int ct = 0;
            String archname = this.name + "-" + today + ".log";
            File archive = new File(this.logdir, archname);
            File zipped = new File(this.logdir, archname + ".gz");
            while (archive.exists() || zipped.exists()) {
                String archidx = ct > 999 ? Integer.toString(ct) : this.nformat.format(++ct);
                archname = this.name + "-" + today + "-" + archidx + ".log";
                archive = new File(this.logdir, archname);
                zipped = new File(this.logdir, archname + ".gz");
            }
            if (this.logfile.renameTo(archive)) {
                return archive;
            }
            System.err.println("Error rotating log file " + this.canonicalName + ". Will append to old file.");
        }
        return null;
    }

    public String toString() {
        return "FileLogger[" + this.name + "]";
    }

    public String getName() {
        return this.name;
    }

    static class GZipper
    extends Thread {
        List files;
        static final int BUFFER_SIZE = 8192;

        public GZipper(List files) {
            this.files = files;
            this.setPriority(1);
        }

        public GZipper(File file) {
            this.files = new ArrayList(1);
            this.files.add(file);
            this.setPriority(1);
        }

        public void run() {
            Iterator it = this.files.iterator();
            File file = null;
            while (it.hasNext()) {
                try {
                    int len;
                    file = (File)it.next();
                    File zipped = new File(file.getAbsolutePath() + ".gz");
                    GZIPOutputStream zip = new GZIPOutputStream(new FileOutputStream(zipped));
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                    byte[] b = new byte[8192];
                    while ((len = in.read(b, 0, 8192)) != -1) {
                        zip.write(b, 0, len);
                    }
                    zip.close();
                    in.close();
                    file.delete();
                }
                catch (Exception e) {
                    System.err.println("Error gzipping " + file);
                    System.err.println(e.toString());
                }
            }
        }
    }
}

