/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class CronJob {
    private static HashSet all = new HashSet(2);
    private static String ALL_VALUE = "*";
    private HashSet year;
    private HashSet month;
    private HashSet day;
    private HashSet weekday;
    private HashSet hour;
    private HashSet minute;
    private String name = null;
    private String function = null;
    private long timeout = 600000L;

    public static CronJob newJob(String functionName, String year, String month, String day, String weekday, String hour, String minute) {
        CronJob job = new CronJob(functionName);
        job.setFunction(functionName);
        if (year != null) {
            job.parseYear(year);
        }
        if (month != null) {
            job.parseMonth(month);
        }
        if (day != null) {
            job.parseDay(day);
        }
        if (weekday != null) {
            job.parseWeekDay(weekday);
        }
        if (hour != null) {
            job.parseHour(hour);
        }
        if (minute != null) {
            job.parseMinute(minute);
        }
        return job;
    }

    public static List parse(Properties props) {
        Hashtable<String, CronJob> jobs = new Hashtable<String, CronJob>();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("cron.")) continue;
            try {
                String jobSpec;
                StringTokenizer st = new StringTokenizer(key.trim(), ".");
                st.nextElement();
                String jobName = st.nextToken();
                if (jobName == null || jobName.equals("") || (jobSpec = st.nextToken()) == null || jobSpec.equals("")) continue;
                CronJob job = (CronJob)jobs.get(jobName);
                if (job == null) {
                    job = new CronJob(jobName);
                    jobs.put(jobName, job);
                }
                String value = props.getProperty(key);
                if (jobSpec.equalsIgnoreCase("function")) {
                    job.setFunction(value);
                    continue;
                }
                if (jobSpec.equalsIgnoreCase("year")) {
                    job.parseYear(value);
                    continue;
                }
                if (jobSpec.equalsIgnoreCase("month")) {
                    job.parseMonth(value);
                    continue;
                }
                if (jobSpec.equalsIgnoreCase("day")) {
                    job.parseDay(value);
                    continue;
                }
                if (jobSpec.equalsIgnoreCase("weekday")) {
                    job.parseWeekDay(value);
                    continue;
                }
                if (jobSpec.equalsIgnoreCase("hour")) {
                    job.parseHour(value);
                    continue;
                }
                if (jobSpec.equalsIgnoreCase("minute")) {
                    job.parseMinute(value);
                    continue;
                }
                if (!jobSpec.equalsIgnoreCase("timeout")) continue;
                job.parseTimeout(value);
            }
            catch (NoSuchElementException nsee) {}
        }
        Iterator it = jobs.values().iterator();
        while (it.hasNext()) {
            CronJob job = (CronJob)it.next();
            if (job.getFunction() != null) continue;
            it.remove();
        }
        ArrayList jobVec = new ArrayList(jobs.values());
        return CronJob.sort(jobVec);
    }

    public static List sort(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                CronJob cron1 = (CronJob)o1;
                CronJob cron2 = (CronJob)o2;
                if (cron1.getTimeout() > cron2.getTimeout()) {
                    return 1;
                }
                if (cron1.getTimeout() < cron2.getTimeout()) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object o1, Object o2) {
                if (o1 != null) {
                    return o1.equals(o2);
                }
                return false;
            }
        });
        return list;
    }

    public void parseYear(String value) {
        if (value.equals("*")) {
            this.setAllYears(true);
        } else {
            StringTokenizer st = new StringTokenizer(value.trim(), ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.indexOf("-") != -1) {
                    int start = Integer.parseInt(s.substring(0, s.indexOf("-")));
                    int finish = Integer.parseInt(s.substring(s.indexOf("-") + 1));
                    for (int i = start; i <= finish; ++i) {
                        this.addYear(i);
                    }
                    continue;
                }
                int y = Integer.parseInt(s);
                this.addYear(y);
            }
        }
    }

    public void parseMonth(String value) {
        if (value.equals("*")) {
            this.setAllMonths(true);
        } else {
            StringTokenizer st = new StringTokenizer(value.trim(), ",");
            while (st.hasMoreTokens()) {
                String m = st.nextToken();
                if (m.equalsIgnoreCase("january")) {
                    this.addMonth(0);
                }
                if (m.equalsIgnoreCase("february")) {
                    this.addMonth(1);
                }
                if (m.equalsIgnoreCase("march")) {
                    this.addMonth(2);
                }
                if (m.equalsIgnoreCase("april")) {
                    this.addMonth(3);
                }
                if (m.equalsIgnoreCase("may")) {
                    this.addMonth(4);
                }
                if (m.equalsIgnoreCase("june")) {
                    this.addMonth(5);
                }
                if (m.equalsIgnoreCase("july")) {
                    this.addMonth(6);
                }
                if (m.equalsIgnoreCase("august")) {
                    this.addMonth(7);
                }
                if (m.equalsIgnoreCase("september")) {
                    this.addMonth(8);
                }
                if (m.equalsIgnoreCase("october")) {
                    this.addMonth(9);
                }
                if (m.equalsIgnoreCase("november")) {
                    this.addMonth(10);
                }
                if (!m.equalsIgnoreCase("december")) continue;
                this.addMonth(11);
            }
        }
    }

    public void parseDay(String day) {
        if (day.equals("*")) {
            this.setAllDays(true);
        } else {
            StringTokenizer st = new StringTokenizer(day.trim(), ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.indexOf("-") != -1) {
                    int start = Integer.parseInt(s.substring(0, s.indexOf("-")));
                    int finish = Integer.parseInt(s.substring(s.indexOf("-") + 1));
                    for (int i = start; i <= finish; ++i) {
                        this.addDay(i);
                    }
                    continue;
                }
                int d = Integer.parseInt(s);
                this.addDay(d);
            }
        }
    }

    public void parseWeekDay(String weekday) {
        if (weekday.equals("*")) {
            this.setAllWeekdays(true);
        } else {
            StringTokenizer st = new StringTokenizer(weekday.trim(), ",");
            while (st.hasMoreTokens()) {
                String d = st.nextToken();
                if (d.equalsIgnoreCase("monday")) {
                    this.addWeekday(2);
                }
                if (d.equalsIgnoreCase("tuesday")) {
                    this.addWeekday(3);
                }
                if (d.equalsIgnoreCase("wednesday")) {
                    this.addWeekday(4);
                }
                if (d.equalsIgnoreCase("thursday")) {
                    this.addWeekday(5);
                }
                if (d.equalsIgnoreCase("friday")) {
                    this.addWeekday(6);
                }
                if (d.equalsIgnoreCase("saturday")) {
                    this.addWeekday(7);
                }
                if (!d.equalsIgnoreCase("sunday")) continue;
                this.addWeekday(1);
            }
        }
    }

    public void parseHour(String hour) {
        if (hour.equals("*")) {
            this.setAllHours(true);
        } else {
            StringTokenizer st = new StringTokenizer(hour.trim(), ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.indexOf("-") != -1) {
                    int start = Integer.parseInt(s.substring(0, s.indexOf("-")));
                    int finish = Integer.parseInt(s.substring(s.indexOf("-") + 1));
                    for (int i = start; i <= finish; ++i) {
                        this.addHour(i);
                    }
                    continue;
                }
                int h = Integer.parseInt(s);
                this.addHour(h);
            }
        }
    }

    public void parseMinute(String minute) {
        if (minute.equals("*")) {
            this.setAllMinutes(true);
        } else {
            StringTokenizer st = new StringTokenizer(minute.trim(), ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.indexOf("-") != -1) {
                    int start = Integer.parseInt(s.substring(0, s.indexOf("-")));
                    int finish = Integer.parseInt(s.substring(s.indexOf("-") + 1));
                    for (int i = start; i <= finish; ++i) {
                        this.addMinute(i);
                    }
                    continue;
                }
                int m = Integer.parseInt(s);
                this.addMinute(m);
            }
        }
    }

    public void parseTimeout(String timeout) {
        long timeoutValue = 1000L * Long.valueOf(timeout);
        this.setTimeout(timeoutValue);
    }

    public static long nextFullMinute() {
        long now = System.currentTimeMillis();
        long millisAfterMinute = now % 60000L;
        return now + 60000L - millisAfterMinute;
    }

    public static long millisToNextFullMinute() {
        long now = System.currentTimeMillis();
        long millisAfterMinute = now % 60000L;
        return 61000L - millisAfterMinute;
    }

    public CronJob(String name) {
        this.name = name;
        this.year = new HashSet(all);
        this.month = new HashSet(all);
        this.day = new HashSet(all);
        this.weekday = new HashSet(all);
        this.hour = new HashSet(all);
        this.minute = new HashSet(all);
    }

    public boolean appliesToDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        Integer theYear = new Integer(cal.get(1));
        if (!this.year.contains(ALL_VALUE) && !this.year.contains(theYear)) {
            return false;
        }
        Integer theMonth = new Integer(cal.get(2));
        if (!this.month.contains(ALL_VALUE) && !this.month.contains(theMonth)) {
            return false;
        }
        Integer theDay = new Integer(cal.get(5));
        if (!this.day.contains(ALL_VALUE) && !this.day.contains(theDay)) {
            return false;
        }
        Integer theWeekDay = new Integer(cal.get(7));
        if (!this.weekday.contains(ALL_VALUE) && !this.weekday.contains(theWeekDay)) {
            return false;
        }
        Integer theHour = new Integer(cal.get(11));
        if (!this.hour.contains(ALL_VALUE) && !this.hour.contains(theHour)) {
            return false;
        }
        Integer theMinute = new Integer(cal.get(12));
        return this.minute.contains(ALL_VALUE) || this.minute.contains(theMinute);
    }

    public void addYear(int year) {
        this.year.remove(ALL_VALUE);
        this.year.add(new Integer(year));
    }

    public void removeYear(int year) {
        this.year.remove(new Integer(year));
    }

    public void setAllYears(boolean set) {
        if (set) {
            this.year.add(ALL_VALUE);
        } else {
            this.year.remove(ALL_VALUE);
        }
    }

    public void addMonth(int month) {
        this.month.remove(ALL_VALUE);
        this.month.add(new Integer(month));
    }

    public void removeMonth(int month) {
        this.month.remove(new Integer(month));
    }

    public void setAllMonths(boolean set) {
        if (set) {
            this.month.add(ALL_VALUE);
        } else {
            this.month.remove(ALL_VALUE);
        }
    }

    public void addDay(int day) {
        this.day.remove(ALL_VALUE);
        this.day.add(new Integer(day));
    }

    public void removeDay(int day) {
        this.day.remove(new Integer(day));
    }

    public void setAllDays(boolean set) {
        if (set) {
            this.day.add(ALL_VALUE);
        } else {
            this.day.remove(ALL_VALUE);
        }
    }

    public void addWeekday(int weekday) {
        this.weekday.remove(ALL_VALUE);
        this.weekday.add(new Integer(weekday));
    }

    public void removeWeekday(int weekday) {
        this.weekday.remove(new Integer(weekday));
    }

    public void setAllWeekdays(boolean set) {
        if (set) {
            this.weekday.add(ALL_VALUE);
        } else {
            this.weekday.remove(ALL_VALUE);
        }
    }

    public void addHour(int hour) {
        this.hour.remove(ALL_VALUE);
        this.hour.add(new Integer(hour));
    }

    public void removeHour(int hour) {
        this.hour.remove(new Integer(hour));
    }

    public void setAllHours(boolean set) {
        if (set) {
            this.hour.add(ALL_VALUE);
        } else {
            this.hour.remove(ALL_VALUE);
        }
    }

    public void addMinute(int minute) {
        this.minute.remove(ALL_VALUE);
        this.minute.add(new Integer(minute));
    }

    public void removeMinute(int minute) {
        this.minute.remove(new Integer(minute));
    }

    public void setAllMinutes(boolean set) {
        if (set) {
            this.minute.add(ALL_VALUE);
        } else {
            this.minute.remove(ALL_VALUE);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getFunction() {
        return this.function;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "[CronJob " + this.name + "]";
    }

    static {
        all.add(ALL_VALUE);
    }
}

