/*
 * Decompiled with CFR 0.152.
 */
package helma.util;

import helma.framework.core.Application;
import helma.objectmodel.ObjectCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CacheMap
implements ObjectCache {
    private float loadFactor;
    private int threshold;
    private int eachCapacity;
    private Map oldTable;
    private Map newTable;
    private Application app = null;

    public CacheMap() {
        this(1000, 0.75f);
    }

    public CacheMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.threshold = initialCapacity / 2;
        this.eachCapacity = (int)((float)this.threshold / loadFactor) + 2;
        this.oldTable = new HashMap();
        this.newTable = this.createTable(this.eachCapacity, loadFactor);
    }

    public CacheMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public int size() {
        return this.newTable.size() + this.oldTable.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void setCapacity(int capacity) {
        int newThreshold = capacity / 2;
        if (newThreshold != this.threshold) {
            if (this.app != null) {
                this.app.logEvent("Setting cache capacity to " + capacity);
            }
            this.updateThreshold(newThreshold);
        }
    }

    private synchronized void updateThreshold(int newThreshold) {
        this.threshold = newThreshold;
        this.eachCapacity = (int)((float)this.threshold / this.loadFactor) + 2;
        if (this.newTable.size() > this.threshold) {
            this.oldTable = this.newTable;
            this.newTable = this.createTable(this.eachCapacity, this.loadFactor);
        }
    }

    public synchronized boolean containsValue(Object value) {
        if (this.newTable.containsValue(value)) {
            return true;
        }
        return this.oldTable.containsValue(value);
    }

    public synchronized boolean containsKey(Object key) {
        if (this.newTable.containsKey(key)) {
            return true;
        }
        if (this.oldTable.containsKey(key)) {
            Object value = this.oldTable.get(key);
            this.newTable.put(key, value);
            this.oldTable.remove(key);
            return true;
        }
        return false;
    }

    public synchronized int containsKeys(Object[] keys) {
        int notfound = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (this.newTable.containsKey(keys[i])) {
                keys[i] = null;
                continue;
            }
            if (this.oldTable.containsKey(keys[i])) {
                Object value = this.oldTable.get(keys[i]);
                this.newTable.put(keys[i], value);
                this.oldTable.remove(keys[i]);
                keys[i] = null;
                continue;
            }
            ++notfound;
        }
        return notfound;
    }

    public synchronized Object get(Object key) {
        Object value = this.newTable.get(key);
        if (value != null) {
            return value;
        }
        value = this.oldTable.get(key);
        if (value != null) {
            this.newTable.put(key, value);
            this.oldTable.remove(key);
            return value;
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        Object oldValue = this.newTable.put(key, value);
        if (oldValue != null) {
            return oldValue;
        }
        oldValue = this.oldTable.get(key);
        if (oldValue != null) {
            this.oldTable.remove(key);
        }
        if (this.newTable.size() >= this.threshold) {
            if (this.app != null) {
                this.app.logEvent("Rotating Cache tables at " + this.newTable.size() + "/" + this.oldTable.size() + " (new/old)");
            }
            this.oldTable = this.newTable;
            this.newTable = this.createTable(this.eachCapacity, this.loadFactor);
        }
        return oldValue;
    }

    public synchronized Object remove(Object key) {
        Object oldValue = this.newTable.remove(key);
        if (oldValue == null) {
            oldValue = this.oldTable.remove(key);
        }
        return oldValue;
    }

    public synchronized boolean clear() {
        this.newTable.clear();
        this.oldTable.clear();
        return true;
    }

    public synchronized void shutdown() {
        this.clear();
    }

    public void init(Application app) {
        this.app = app;
        int cacheSize = Integer.parseInt(app.getProperty("cachesize", "1000"));
        this.setCapacity(cacheSize);
    }

    public void updateProperties(Properties props) {
        int cacheSize = Integer.parseInt(props.getProperty("cachesize", "1000"));
        this.setCapacity(cacheSize);
    }

    public synchronized Object[] getCachedObjects() {
        Object[] k1 = this.newTable.keySet().toArray();
        Object[] k2 = this.oldTable.keySet().toArray();
        Object[] k = new Object[k1.length + k2.length];
        System.arraycopy(k1, 0, k, 0, k1.length);
        System.arraycopy(k2, 0, k, k1.length, k2.length);
        return k;
    }

    public String toString() {
        return this.newTable.toString() + this.oldTable.toString() + this.hashCode();
    }

    protected Map createTable(int capacity, float loadFactor) {
        return new HashMap(capacity, loadFactor);
    }
}

