/*
 * Decompiled with CFR 0.152.
 */
package helma.servlet;

import helma.framework.core.Application;
import helma.framework.repository.FileRepository;
import helma.framework.repository.Repository;
import helma.servlet.AbstractServletClient;
import java.io.File;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public final class StandaloneServletClient
extends AbstractServletClient {
    private Application app = null;
    private String appName;
    private String appDir;
    private String dbDir;

    public void init(ServletConfig init) throws ServletException {
        super.init(init);
        this.appName = init.getInitParameter("application");
        if (this.appName == null || this.appName.trim().length() == 0) {
            throw new ServletException("application parameter not specified");
        }
        this.appDir = init.getInitParameter("appdir");
        if (this.appDir == null || this.appDir.trim().length() == 0) {
            throw new ServletException("appdir parameter not specified");
        }
        this.dbDir = init.getInitParameter("dbdir");
        if (this.dbDir == null || this.dbDir.trim().length() == 0) {
            throw new ServletException("dbdir parameter not specified");
        }
    }

    Application getApplication() {
        if (this.app == null) {
            this.createApp();
        }
        return this.app;
    }

    synchronized void createApp() {
        if (this.app != null) {
            return;
        }
        try {
            Repository[] repositories = new Repository[]{new FileRepository(new File(this.appDir))};
            File dbHome = new File(this.dbDir);
            this.app = new Application(this.appName, repositories, dbHome);
            this.app.init();
            this.app.start();
        }
        catch (Exception x) {
            this.log("Error starting Application " + this.appName + ": " + x);
            x.printStackTrace();
        }
    }

    public void destroy() {
        if (this.app != null) {
            try {
                this.app.stop();
            }
            catch (Exception x) {
                this.log("Error shutting down app " + this.app.getName() + ": ");
                x.printStackTrace();
            }
        }
        this.app = null;
    }
}

