/*
 * Decompiled with CFR 0.152.
 */
package helma.servlet;

import helma.framework.CookieTrans;
import helma.framework.RequestTrans;
import helma.framework.ResponseTrans;
import helma.framework.UploadStatus;
import helma.framework.core.Application;
import helma.util.Base64;
import helma.util.MimePart;
import helma.util.UrlEncoded;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public abstract class AbstractServletClient
extends HttpServlet {
    String host = null;
    int port = 0;
    String hopUrl;
    int uploadLimit = 1024;
    int totalUploadLimit = 1024;
    String cookieDomain;
    String sessionCookieName = "HopSession";
    boolean protectedSessionCookie = true;
    boolean caching;
    boolean debug;
    boolean uploadSoftfail = false;

    public void init(ServletConfig init) throws ServletException {
        super.init(init);
        String upstr = init.getInitParameter("uploadLimit");
        try {
            this.uploadLimit = upstr == null ? 1024 : Integer.parseInt(upstr);
        }
        catch (NumberFormatException x) {
            this.log("Bad number format for uploadLimit: " + upstr);
            this.uploadLimit = 1024;
        }
        upstr = init.getInitParameter("totalUploadLimit");
        try {
            this.totalUploadLimit = upstr == null ? this.uploadLimit : Integer.parseInt(upstr);
        }
        catch (NumberFormatException x) {
            this.log("Bad number format for totalUploadLimit: " + upstr);
            this.totalUploadLimit = this.uploadLimit;
        }
        this.uploadSoftfail = "true".equalsIgnoreCase(init.getInitParameter("uploadSoftfail"));
        this.cookieDomain = init.getInitParameter("cookieDomain");
        if (this.cookieDomain != null) {
            this.cookieDomain = this.cookieDomain.toLowerCase();
        }
        this.sessionCookieName = init.getInitParameter("sessionCookieName");
        if (this.sessionCookieName == null) {
            this.sessionCookieName = "HopSession";
        }
        this.protectedSessionCookie = !"false".equalsIgnoreCase(init.getInitParameter("protectedSessionCookie"));
        this.debug = "true".equalsIgnoreCase(init.getInitParameter("debug"));
        this.caching = !"false".equalsIgnoreCase(init.getInitParameter("caching"));
    }

    abstract Application getApplication();

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTrans reqtrans = new RequestTrans(request, response, this.getPathInfo(request));
        try {
            String resCookieDomain;
            Cookie[] reqCookies;
            String encoding = request.getCharacterEncoding();
            if (encoding == null) {
                encoding = this.getApplication().getCharset();
            }
            if ((reqCookies = request.getCookies()) != null) {
                for (int i = 0; i < reqCookies.length; ++i) {
                    try {
                        String key = reqCookies[i].getName();
                        if (this.sessionCookieName.equals(key)) {
                            reqtrans.setSession(reqCookies[i].getValue());
                            continue;
                        }
                        reqtrans.setCookie(key, reqCookies[i]);
                        continue;
                    }
                    catch (Exception badCookie) {
                        this.log("Error setting cookie", badCookie);
                    }
                }
            }
            if ((resCookieDomain = this.cookieDomain) != null) {
                String proxiedHost = request.getHeader("x-forwarded-host");
                if (proxiedHost != null) {
                    if (proxiedHost.toLowerCase().indexOf(resCookieDomain) == -1) {
                        resCookieDomain = null;
                    }
                } else if (this.host != null && this.host.toLowerCase().indexOf(resCookieDomain) == -1) {
                    resCookieDomain = null;
                }
            }
            this.checkSessionCookie(request, response, reqtrans, resCookieDomain);
            this.parseParameters(request, reqtrans, encoding);
            List uploads = null;
            ServletRequestContext reqcx = new ServletRequestContext(request);
            if (ServletFileUpload.isMultipartContent((RequestContext)reqcx)) {
                UploadStatus uploadStatus = this.getApplication().getUploadStatus(reqtrans);
                try {
                    uploads = this.parseUploads(reqcx, reqtrans, uploadStatus, encoding);
                }
                catch (Exception upx) {
                    String message;
                    this.log("Error in file upload", upx);
                    boolean tooLarge = upx instanceof FileUploadBase.SizeLimitExceededException;
                    if (tooLarge) {
                        message = "File upload size exceeds limit of " + this.uploadLimit + " kB";
                    } else {
                        message = upx.getMessage();
                        if (message == null || message.length() == 0) {
                            message = upx.toString();
                        }
                    }
                    if (uploadStatus != null) {
                        uploadStatus.setError(message);
                    }
                    if (this.uploadSoftfail || uploadStatus != null) {
                        reqtrans.set("helma_upload_error", message);
                    }
                    int errorCode = tooLarge ? 413 : 500;
                    this.sendError(response, errorCode, "Error in file upload: " + message);
                    return;
                }
            }
            ResponseTrans restrans = this.getApplication().execute(reqtrans);
            if (uploads != null) {
                for (int i = 0; i < uploads.size(); ++i) {
                    ((FileItem)uploads.get(i)).delete();
                }
            }
            if (response.isCommitted()) {
                return;
            }
            if (restrans.countCookies() > 0) {
                CookieTrans[] resCookies = restrans.getCookies();
                for (int i = 0; i < resCookies.length; ++i) {
                    try {
                        Cookie c = resCookies[i].getCookie("/", resCookieDomain);
                        response.addCookie(c);
                        continue;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
            this.writeResponse(request, response, reqtrans, restrans);
        }
        catch (Exception x) {
            this.log("Exception in execute", x);
            try {
                if (this.debug) {
                    this.sendError(response, 500, "Server error: " + x);
                } else {
                    this.sendError(response, 500, "The server encountered an error while processing your request. Please check back later.");
                }
            }
            catch (IOException iox) {
                this.log("Exception in sendError", iox);
            }
        }
    }

    protected void writeResponse(HttpServletRequest req, HttpServletResponse res, RequestTrans hopreq, ResponseTrans hopres) throws IOException {
        if (hopres.getForward() != null) {
            this.sendForward(res, req, hopres);
            return;
        }
        if (hopres.getETag() != null) {
            res.setHeader("ETag", hopres.getETag());
        }
        if (hopres.getRedirect() != null) {
            this.sendRedirect(req, res, hopres.getRedirect());
        } else if (hopres.getNotModified()) {
            res.setStatus(304);
        } else {
            long modified;
            if (!hopres.isCacheable() || !this.caching) {
                if (this.isOneDotOne(req.getProtocol())) {
                    res.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=0");
                } else {
                    res.setDateHeader("Expires", System.currentTimeMillis() - 10000L);
                    res.setHeader("Pragma", "no-cache");
                }
            }
            if (hopres.getRealm() != null) {
                res.setHeader("WWW-Authenticate", "Basic realm=\"" + hopres.getRealm() + "\"");
            }
            if (hopres.getStatus() > 0) {
                res.setStatus(hopres.getStatus());
            }
            if ((modified = hopres.getLastModified()) > -1L) {
                res.setDateHeader("Last-Modified", modified);
            }
            res.setContentLength(hopres.getContentLength());
            res.setContentType(hopres.getContentType());
            if ("HEAD".equalsIgnoreCase(req.getMethod())) {
                return;
            }
            try {
                ServletOutputStream out = res.getOutputStream();
                out.write(hopres.getContent());
                out.flush();
            }
            catch (Exception iox) {
                this.log("Exception in writeResponse: " + iox);
            }
        }
    }

    void sendError(HttpServletResponse response, int code, String message) throws IOException {
        response.reset();
        response.setStatus(code);
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write("<html><body><h3>");
        ((Writer)writer).write("Error in application ");
        try {
            ((Writer)writer).write(this.getApplication().getName());
        }
        catch (Exception besafe) {
            // empty catch block
        }
        ((Writer)writer).write("</h3>");
        ((Writer)writer).write(message);
        ((Writer)writer).write("</body></html>");
        ((Writer)writer).flush();
    }

    void sendRedirect(HttpServletRequest req, HttpServletResponse res, String url) {
        String location = url;
        if (url.indexOf("://") == -1) {
            String scheme = req.getScheme();
            StringBuffer loc = new StringBuffer(scheme);
            loc.append("://");
            loc.append(req.getServerName());
            int p = req.getServerPort();
            if (p > 0 && ("http".equals(scheme) && p != 80 || "https".equals(scheme) && p != 443)) {
                loc.append(":");
                loc.append(p);
            }
            if (!url.startsWith("/")) {
                String requri = req.getRequestURI();
                int lastSlash = requri.lastIndexOf("/");
                if (lastSlash == requri.length() - 1) {
                    loc.append(requri);
                } else if (lastSlash > -1) {
                    loc.append(requri.substring(0, lastSlash + 1));
                } else {
                    loc.append("/");
                }
            }
            loc.append(url);
            location = loc.toString();
        }
        if (this.isOneDotOne(req.getProtocol())) {
            res.setStatus(303);
        } else {
            res.setStatus(302);
        }
        res.setContentType("text/html");
        res.setHeader("Location", location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendForward(HttpServletResponse res, HttpServletRequest req, ResponseTrans hopres) throws IOException {
        int length;
        String forward = hopres.getForward();
        ServletContext cx = this.getServletConfig().getServletContext();
        String path = cx.getRealPath(forward);
        if (path == null) {
            throw new IOException("Resource " + forward + " not found");
        }
        File file = new File(path);
        if (this.checkNotModified(file, req, res)) {
            res.setStatus(304);
            return;
        }
        res.setContentLength(length);
        res.setContentType(hopres.getContentType());
        InputStream in = cx.getResourceAsStream(forward);
        if (in == null) {
            throw new IOException("Can't read " + path);
        }
        try {
            int l;
            ServletOutputStream out = res.getOutputStream();
            int bufferSize = 4096;
            byte[] buffer = new byte[bufferSize];
            for (length = (int)file.length(); length > 0; length -= l) {
                l = length < bufferSize ? in.read(buffer, 0, length) : in.read(buffer, 0, bufferSize);
                if (l == -1) {
                    break;
                }
                out.write(buffer, 0, l);
            }
        }
        finally {
            in.close();
        }
    }

    private boolean checkNotModified(File file, HttpServletRequest req, HttpServletResponse res) {
        long ifModifiedSince;
        long lastModified;
        int i;
        byte[] checksum = new byte[16];
        long n = file.lastModified();
        for (i = 0; i < 8; ++i) {
            checksum[i] = (byte)n;
            n >>>= 8;
        }
        n = file.length();
        for (i = 8; i < 16; ++i) {
            checksum[i] = (byte)n;
            n >>>= 8;
        }
        String etag = "\"" + new String(Base64.encode(checksum)) + "\"";
        res.setHeader("ETag", etag);
        String etagHeader = req.getHeader("If-None-Match");
        if (etagHeader != null) {
            StringTokenizer st = new StringTokenizer(etagHeader, ", \r\n");
            while (st.hasMoreTokens()) {
                if (!etag.equals(st.nextToken())) continue;
                return true;
            }
        }
        if ((lastModified = file.lastModified() / 1000L * 1000L) == (ifModifiedSince = req.getDateHeader("If-Modified-Since"))) {
            return true;
        }
        res.setDateHeader("Last-Modified", lastModified);
        return false;
    }

    private void checkSessionCookie(HttpServletRequest request, HttpServletResponse response, RequestTrans reqtrans, String domain) {
        if (this.protectedSessionCookie) {
            StringBuffer b = new StringBuffer();
            this.addIPAddress(b, request.getRemoteAddr());
            this.addIPAddress(b, request.getHeader("X-Forwarded-For"));
            this.addIPAddress(b, request.getHeader("Client-ip"));
            if (reqtrans.getSession() == null || !reqtrans.getSession().startsWith(b.toString())) {
                response.addCookie(this.createSessionCookie(b, reqtrans, domain));
            }
        } else if (reqtrans.getSession() == null) {
            response.addCookie(this.createSessionCookie(new StringBuffer(), reqtrans, domain));
        }
    }

    private Cookie createSessionCookie(StringBuffer b, RequestTrans reqtrans, String domain) {
        b.append(Long.toString(Math.round(Math.random() * 9.223372036854776E18) - System.currentTimeMillis(), 36));
        reqtrans.setSession(b.toString());
        Cookie cookie = new Cookie(this.sessionCookieName, reqtrans.getSession());
        cookie.setPath("/");
        if (domain != null) {
            cookie.setDomain(domain);
        }
        return cookie;
    }

    private void addIPAddress(StringBuffer b, String addr) {
        if (addr != null) {
            int cut = addr.indexOf(44);
            if (cut > -1) {
                addr = addr.substring(0, cut);
            }
            if ((cut = addr.lastIndexOf(46)) == -1) {
                cut = addr.lastIndexOf(58);
            }
            if (cut > -1) {
                b.append(addr.substring(0, cut + 1));
            }
        }
    }

    private static void putMapEntry(Map map, String name, String value) {
        String[] newValues = null;
        String[] oldValues = (String[])map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
        }
        map.put(name, newValues);
    }

    protected List parseUploads(ServletRequestContext reqcx, RequestTrans reqtrans, final UploadStatus uploadStatus, String encoding) throws FileUploadException, UnsupportedEncodingException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        FileUpload upload = new FileUpload((FileItemFactory)factory);
        upload.setFileSizeMax((long)(this.uploadLimit * 1024));
        upload.setSizeMax((long)(this.totalUploadLimit * 1024));
        if (uploadStatus != null) {
            upload.setProgressListener(new ProgressListener(){

                public void update(long bytesRead, long contentLength, int itemsRead) {
                    uploadStatus.update(bytesRead, contentLength, itemsRead);
                }
            });
        }
        List uploads = upload.parseRequest((RequestContext)reqcx);
        Iterator it = uploads.iterator();
        while (it.hasNext()) {
            FileItem item = (FileItem)it.next();
            String name = item.getFieldName();
            Object value = item.isFormField() ? item.getString(encoding) : new MimePart(item);
            reqtrans.addPostParam(name, value);
        }
        return uploads;
    }

    protected void parseParameters(HttpServletRequest request, RequestTrans reqtrans, String encoding) throws IOException {
        boolean isFormPost;
        String queryString = request.getQueryString();
        String contentType = request.getContentType();
        boolean bl = isFormPost = "post".equals(request.getMethod().toLowerCase()) && contentType != null && contentType.toLowerCase().startsWith("application/x-www-form-urlencoded");
        if (queryString == null && !isFormPost) {
            return;
        }
        HashMap parameters = new HashMap();
        if (queryString != null) {
            AbstractServletClient.parseParameters(parameters, queryString.getBytes(), encoding, false);
            if (!parameters.isEmpty()) {
                reqtrans.setParameters(parameters, false);
                parameters.clear();
            }
        }
        if (isFormPost) {
            int next;
            int max = request.getContentLength();
            byte[] buf = new byte[max];
            ServletInputStream is = request.getInputStream();
            for (int len = 0; len < max && (next = is.read(buf, len, max - len)) >= 0; len += next) {
            }
            AbstractServletClient.parseParameters(parameters, buf, encoding, true);
            if (!parameters.isEmpty()) {
                reqtrans.setParameters(parameters, true);
                parameters.clear();
            }
        }
    }

    public static void parseParameters(Map map, byte[] data, String encoding, boolean isPost) throws UnsupportedEncodingException {
        if (data != null && data.length > 0) {
            int ix = 0;
            int ox = 0;
            String key = null;
            String value = null;
            block6: while (ix < data.length) {
                byte c = data[ix++];
                switch ((char)c) {
                    case '&': {
                        value = new String(data, 0, ox, encoding);
                        if (key != null) {
                            AbstractServletClient.putMapEntry(map, key, value);
                            key = null;
                        }
                        ox = 0;
                        continue block6;
                    }
                    case '=': {
                        key = new String(data, 0, ox, encoding);
                        ox = 0;
                        continue block6;
                    }
                    case '+': {
                        data[ox++] = 32;
                        continue block6;
                    }
                    case '%': {
                        data[ox++] = (byte)((AbstractServletClient.convertHexDigit(data[ix++]) << 4) + AbstractServletClient.convertHexDigit(data[ix++]));
                        continue block6;
                    }
                }
                data[ox++] = c;
            }
            if (key != null) {
                value = new String(data, 0, ox, encoding);
                AbstractServletClient.putMapEntry(map, key, value);
            } else if (ox > 0) {
                value = new String(data, 0, ox, encoding);
                if (isPost) {
                    AbstractServletClient.putMapEntry(map, "http_post_remainder", value);
                } else {
                    AbstractServletClient.putMapEntry(map, "http_get_remainder", value);
                }
            }
        }
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    boolean isOneDotOne(String protocol) {
        if (protocol == null) {
            return false;
        }
        return protocol.endsWith("1.1");
    }

    String getPathInfo(HttpServletRequest req) throws UnsupportedEncodingException {
        StringTokenizer t = new StringTokenizer(req.getContextPath(), "/");
        int prefixTokens = t.countTokens();
        t = new StringTokenizer(req.getServletPath(), "/");
        prefixTokens += t.countTokens();
        String uri = req.getRequestURI();
        t = new StringTokenizer(uri, "/");
        int uriTokens = t.countTokens();
        StringBuffer pathbuffer = new StringBuffer();
        String encoding = this.getApplication().getCharset();
        for (int i = 0; i < uriTokens; ++i) {
            String token = t.nextToken();
            if (i < prefixTokens) continue;
            if (i > prefixTokens) {
                pathbuffer.append('/');
            }
            pathbuffer.append(UrlEncoded.decode(token, encoding));
        }
        if (uri.endsWith("/")) {
            pathbuffer.append('/');
        }
        return pathbuffer.toString();
    }

    public String getServletInfo() {
        return "Helma Servlet Client";
    }
}

