/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino.extensions;

import helma.scripting.rhino.RhinoCore;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class XmlRpcObject
extends BaseFunction {
    String url = null;
    String method = null;

    XmlRpcObject(String url) {
        this.url = url;
        this.method = null;
    }

    XmlRpcObject(String url, String method) {
        this.url = url;
        this.method = method;
    }

    public static Object xmlrpcObjectConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length == 0 || args.length > 2) {
            throw new IllegalArgumentException("Wrong number of arguments in constructor for XML-RPC client");
        }
        if (args.length == 1) {
            String url = args[0].toString();
            return new XmlRpcObject(url);
        }
        String url = args[0].toString();
        String method = args[1].toString();
        return new XmlRpcObject(url, method);
    }

    public static void init(Scriptable scope) {
        Method[] methods = XmlRpcObject.class.getDeclaredMethods();
        Method ctorMember = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!"xmlrpcObjectConstructor".equals(methods[i].getName())) continue;
            ctorMember = methods[i];
            break;
        }
        FunctionObject ctor = new FunctionObject("Remote", ctorMember, scope);
        ScriptableObject.defineProperty((Scriptable)scope, (String)"Remote", (Object)ctor, (int)2);
    }

    public Object get(String name, Scriptable start) {
        String m = this.method == null ? name : this.method + "." + name;
        return new XmlRpcObject(this.url, m);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws EvaluatorException {
        if (this.method == null) {
            throw new EvaluatorException("Invalid method name");
        }
        RhinoCore core = RhinoCore.getCore();
        Scriptable retval = null;
        try {
            retval = Context.getCurrentContext().newObject(core.getScope());
            XmlRpcClient client = new XmlRpcClient(this.url);
            int l = args.length;
            Vector<Object> v = new Vector<Object>();
            for (int i = 0; i < l; ++i) {
                Object arg = core.processXmlRpcResponse(args[i]);
                v.addElement(arg);
            }
            Object result = client.execute(this.method, v);
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            retval.put("result", retval, core.processXmlRpcArgument(result));
        }
        catch (Exception x) {
            String msg = x.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = x.toString();
            }
            retval.put("error", retval, (Object)msg);
        }
        return retval;
    }

    public String getClassName() {
        return "Remote";
    }

    public String toString() {
        return "[Remote " + this.url + "]";
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || hint == String.class) {
            return this.toString();
        }
        return super.getDefaultValue(hint);
    }
}

