/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino.extensions;

import helma.objectmodel.INode;
import helma.objectmodel.db.Node;
import helma.objectmodel.dom.XmlConverter;
import helma.objectmodel.dom.XmlReader;
import helma.objectmodel.dom.XmlWriter;
import helma.scripting.rhino.RhinoCore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;

public class XmlObject {
    RhinoCore core;

    public XmlObject(RhinoCore core) {
        this.core = core;
    }

    public boolean write(INode node, String file) throws IOException {
        if (node == null) {
            throw new RuntimeException("First argument in Xml.write() is not an hopobject");
        }
        if (file == null) {
            throw new RuntimeException("Second argument file name must not be null");
        }
        File tmpFile = new File(file + ".tmp." + XmlWriter.generateID());
        XmlWriter writer = new XmlWriter(tmpFile, "UTF-8");
        writer.setDatabaseMode(false);
        writer.write(node);
        writer.close();
        File finalFile = new File(file);
        if (finalFile.exists()) {
            finalFile.delete();
        }
        tmpFile.renameTo(finalFile);
        this.core.getApplication().logEvent("wrote xml to " + finalFile.getAbsolutePath());
        return true;
    }

    public String writeToString(INode node) throws IOException {
        if (node == null) {
            throw new RuntimeException("First argument in Xml.write() is not an hopobject");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)out, "UTF-8");
        writer.setDatabaseMode(false);
        writer.write(node);
        writer.flush();
        return out.toString("UTF-8");
    }

    public Object read(String file) throws RuntimeException {
        return this.read(file, null);
    }

    public Object read(String file, INode node) throws RuntimeException {
        if (file == null) {
            throw new RuntimeException("Missing arguments in Xml.read()");
        }
        if (node == null) {
            node = new Node(null, null, this.core.getApplication().getWrappedNodeManager());
        }
        try {
            XmlReader reader = new XmlReader(this.core.app.getWrappedNodeManager());
            INode result = reader.read(new File(file), node);
            return this.core.getNodeWrapper(result);
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Can't load XML parser:" + e);
        }
        catch (Exception f) {
            throw new RuntimeException(f.toString());
        }
    }

    public Object readFromString(String str) throws RuntimeException {
        return this.readFromString(str, null);
    }

    public Object readFromString(String str, INode node) throws RuntimeException {
        if (str == null) {
            throw new RuntimeException("Missing arguments in Xml.read()");
        }
        if (node == null) {
            node = new Node(null, null, this.core.getApplication().getWrappedNodeManager());
        }
        try {
            XmlReader reader = new XmlReader(this.core.app.getWrappedNodeManager());
            INode result = reader.read(new StringReader(str), node);
            return this.core.getNodeWrapper(result);
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Can't load XML parser:" + e);
        }
        catch (Exception f) {
            f.printStackTrace();
            throw new RuntimeException(f.toString());
        }
    }

    public Object get(String url) {
        return this.get(url, null);
    }

    public Object get(String url, String conversionRules) {
        if (url == null) {
            throw new RuntimeException("Xml.get() needs a location as an argument");
        }
        try {
            XmlConverter converter = conversionRules != null ? new XmlConverter(conversionRules) : new XmlConverter();
            Node node = new Node(null, null, this.core.getApplication().getWrappedNodeManager());
            INode result = converter.convert(url, (INode)node);
            return this.core.getNodeWrapper(result);
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Can't load dom-capable xml parser.");
        }
    }

    public Object getFromString(String str) {
        return this.getFromString(str, null);
    }

    public Object getFromString(String str, String conversionRules) {
        if (str == null) {
            throw new RuntimeException("Xml.getFromString() needs an XML string as parameter");
        }
        try {
            XmlConverter converter = conversionRules != null ? new XmlConverter(conversionRules) : new XmlConverter();
            Node node = new Node(null, null, this.core.getApplication().getWrappedNodeManager());
            INode result = converter.convertFromString(str, node);
            return this.core.getNodeWrapper(result);
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Can't load dom-capable xml parser.");
        }
    }
}

