/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino.extensions;

import helma.util.MimePart;
import helma.util.MimePartDataSource;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class MailObject
extends ScriptableObject
implements Serializable {
    public static final int OK = 0;
    public static final int SUBJECT = 10;
    public static final int TEXT = 11;
    public static final int MIMEPART = 12;
    public static final int TO = 20;
    public static final int CC = 21;
    public static final int BCC = 22;
    public static final int FROM = 23;
    public static final int REPLYTO = 24;
    public static final int SEND = 30;
    MimeMessage message;
    Multipart multipart;
    String multipartType = "mixed";
    StringBuffer buffer;
    int status = 0;
    Session session = null;
    Properties props = null;
    String host = null;

    MailObject(Session session) {
        this.message = new MimeMessage(session);
    }

    MailObject(Properties mprops) {
        this.props = mprops;
    }

    public String getClassName() {
        return "Mail";
    }

    protected Session getSession() {
        boolean hostChanged;
        if (this.props == null) {
            throw new NullPointerException("getSession() called on non-prototype MailObject");
        }
        System.setProperty("mail.mime.charset", this.props.getProperty("mail.charset", "ISO-8859-15"));
        String newHost = this.props.getProperty("mail.host");
        if (newHost == null) {
            newHost = this.props.getProperty("smtp");
        }
        boolean bl = hostChanged = this.host == null && newHost != null || this.host != null && !this.host.equals(newHost);
        if (this.session == null || hostChanged) {
            this.host = newHost;
            Properties sessionProps = new Properties();
            if (this.host != null) {
                sessionProps.put("mail.smtp.host", this.host);
            }
            this.session = Session.getInstance((Properties)sessionProps);
        }
        return this.session;
    }

    public static MailObject mailObjCtor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        MailObject proto = (MailObject)ctorObj.get("prototype", (Scriptable)ctorObj);
        return new MailObject(proto.getSession());
    }

    public static void init(Scriptable scope, Properties props) {
        Method[] methods = MailObject.class.getDeclaredMethods();
        MailObject proto = new MailObject(props);
        proto.setPrototype(MailObject.getObjectPrototype((Scriptable)scope));
        Method ctorMember = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!"mailObjCtor".equals(methods[i].getName())) continue;
            ctorMember = methods[i];
            break;
        }
        FunctionObject ctor = new FunctionObject("Mail", ctorMember, scope);
        ctor.addAsConstructor(scope, (Scriptable)proto);
        ctor.put("props", (Scriptable)ctor, (Object)props);
        String[] mailFuncs = new String[]{"addBCC", "addCC", "addPart", "addText", "addTo", "send", "setFrom", "setSubject", "setText", "setTo", "setReplyTo", "setMultipartType", "getMultipartType"};
        try {
            proto.defineFunctionProperties(mailFuncs, MailObject.class, 0);
            proto.defineProperty("status", MailObject.class, 0);
        }
        catch (Exception ignore) {
            System.err.println("Error defining function properties: " + ignore);
        }
    }

    protected void setStatus(int status) {
        if (this.status == 0) {
            this.status = status;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void addText(String text) {
        if (text != null) {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            this.buffer.append(text);
        }
    }

    public void setText(String text) {
        if (text != null) {
            this.buffer = new StringBuffer(text);
        }
    }

    public String getMultipartType() {
        return this.multipartType;
    }

    public void setMultipartType(String subtype) {
        this.multipartType = subtype;
    }

    public void addPart(Object obj, Object filename) {
        try {
            if (obj == null || obj == Undefined.instance) {
                throw new IOException("mail.addPart called with wrong number of arguments.");
            }
            if (this.multipart == null) {
                this.multipart = new MimeMultipart(this.multipartType);
            }
            MimeBodyPart part = new MimeBodyPart();
            if (obj instanceof Wrapper) {
                obj = ((Wrapper)obj).unwrap();
            }
            if (obj instanceof String) {
                part.setContent((Object)obj.toString(), "text/plain");
            } else if (obj instanceof File) {
                FileDataSource source = new FileDataSource((File)obj);
                part.setDataHandler(new DataHandler((DataSource)source));
            } else if (obj instanceof MimePart) {
                MimePartDataSource source = new MimePartDataSource((MimePart)obj);
                part.setDataHandler(new DataHandler((DataSource)source));
            }
            if (filename != null && filename != Undefined.instance) {
                try {
                    part.setFileName(filename.toString());
                }
                catch (Exception x) {}
            } else if (obj instanceof File) {
                try {
                    part.setFileName(((File)obj).getName());
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            this.multipart.addBodyPart((BodyPart)part);
        }
        catch (Exception mx) {
            System.err.println("Error in MailObject.addPart(): " + mx);
            this.setStatus(12);
        }
    }

    public void setSubject(Object subject) {
        if (subject == null || subject == Undefined.instance) {
            return;
        }
        try {
            this.message.setSubject(MimeUtility.encodeWord((String)subject.toString()));
        }
        catch (Exception mx) {
            System.err.println("Error in MailObject.setSubject(): " + mx);
            this.setStatus(10);
        }
    }

    public void setReplyTo(String addstr) {
        try {
            if (addstr.indexOf("@") < 0) {
                throw new AddressException();
            }
            Address[] replyTo = new Address[]{new InternetAddress(addstr)};
            this.message.setReplyTo(replyTo);
        }
        catch (Exception mx) {
            System.err.println("Error in MailObject.setReplyTo(): " + mx);
            this.setStatus(24);
        }
    }

    public void setFrom(String addstr, Object name) {
        try {
            if (addstr.indexOf("@") < 0) {
                throw new AddressException();
            }
            InternetAddress address = null;
            address = name != null && name != Undefined.instance ? new InternetAddress(addstr, MimeUtility.encodeWord((String)name.toString())) : new InternetAddress(addstr);
            this.message.setFrom((Address)address);
        }
        catch (Exception mx) {
            System.err.println("Error in MailObject.setFrom(): " + mx);
            this.setStatus(23);
        }
    }

    public void setTo(String addstr, Object name) {
        try {
            this.addRecipient(addstr, name, Message.RecipientType.TO);
        }
        catch (Exception mx) {
            System.err.println("Error in MailObject.setTo(): " + mx);
            this.setStatus(20);
        }
    }

    public void addTo(String addstr, Object name) {
        try {
            this.addRecipient(addstr, name, Message.RecipientType.TO);
        }
        catch (Exception mx) {
            System.err.println("Error in MailObject.addTO(): " + mx);
            this.setStatus(20);
        }
    }

    public void addCC(String addstr, Object name) {
        try {
            this.addRecipient(addstr, name, Message.RecipientType.CC);
        }
        catch (Exception mx) {
            System.err.println("Error in MailObject.addCC(): " + mx);
            this.setStatus(21);
        }
    }

    public void addBCC(String addstr, Object name) {
        try {
            this.addRecipient(addstr, name, Message.RecipientType.BCC);
        }
        catch (Exception mx) {
            System.err.println("Error in MailObject.addBCC(): " + mx);
            this.setStatus(22);
        }
    }

    private void addRecipient(String addstr, Object name, Message.RecipientType type) throws Exception {
        if (addstr.indexOf("@") < 0) {
            throw new AddressException();
        }
        InternetAddress address = null;
        address = name != null && name != Undefined.instance ? new InternetAddress(addstr, MimeUtility.encodeWord((String)name.toString())) : new InternetAddress(addstr);
        this.message.addRecipient(type, (Address)address);
    }

    public void send() {
        if (this.status != 0) {
            System.err.println("Error sending mail. Status=" + this.status);
        }
        try {
            if (this.buffer != null) {
                if (this.multipart != null) {
                    MimeBodyPart part = new MimeBodyPart();
                    part.setContent((Object)this.buffer.toString(), "text/plain");
                    this.multipart.addBodyPart((BodyPart)part, 0);
                    this.message.setContent(this.multipart);
                } else {
                    this.message.setText(this.buffer.toString());
                }
            } else if (this.multipart != null) {
                this.message.setContent(this.multipart);
            } else {
                this.message.setText("");
            }
            Transport.send((Message)this.message);
        }
        catch (Exception mx) {
            System.err.println("Error in MailObject.send(): " + mx);
            this.setStatus(30);
        }
    }
}

