/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino.extensions;

import helma.image.ImageGenerator;
import helma.image.ImageInfo;
import helma.image.ImageWaiter;
import helma.image.ImageWrapper;
import helma.scripting.rhino.extensions.FileObject;
import helma.util.MimePart;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class ImageObject {
    public static void init(Scriptable scope) {
        Method[] methods = ImageObject.class.getDeclaredMethods();
        Method ctorMember = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!"imageCtor".equals(methods[i].getName())) continue;
            ctorMember = methods[i];
            break;
        }
        FunctionObject ctor = new FunctionObject("Image", ctorMember, scope);
        ScriptableObject.defineProperty((Scriptable)scope, (String)"Image", (Object)ctor, (int)2);
        ctor.put("getInfo", (Scriptable)ctor, (Object)new GetInfo());
    }

    public static Object imageCtor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        ImageWrapper img = null;
        try {
            ImageGenerator generator = ImageGenerator.getInstance();
            if (args.length == 1) {
                Object arg = args[0];
                if (arg instanceof Wrapper) {
                    arg = ((Wrapper)arg).unwrap();
                }
                if (arg instanceof byte[]) {
                    img = generator.createImage((byte[])arg);
                } else if (arg instanceof String) {
                    String str = arg.toString();
                    try {
                        URL url = new URL(str);
                        img = generator.createImage(url);
                    }
                    catch (MalformedURLException e) {
                        img = generator.createImage(str);
                    }
                } else if (arg instanceof MimePart) {
                    img = generator.createImage(((MimePart)arg).getContent());
                } else if (arg instanceof File) {
                    img = generator.createImage(((File)arg).getAbsolutePath());
                } else if (arg instanceof FileObject) {
                    img = generator.createImage(((FileObject)((Object)arg)).getFile().getAbsolutePath());
                } else if (arg instanceof InputStream) {
                    img = generator.createImage((InputStream)arg);
                } else {
                    Image image = null;
                    if (arg instanceof BufferedImage) {
                        image = (Image)arg;
                    } else if (arg instanceof Image) {
                        image = ImageWaiter.waitForImage((Image)arg);
                    }
                    if (image != null) {
                        img = new ImageWrapper(image, image.getWidth(null), image.getHeight(null), generator);
                    }
                }
            } else if (args.length == 2) {
                Object wrapper;
                if (args[0] instanceof Number && args[1] instanceof Number) {
                    img = generator.createImage(((Number)args[0]).intValue(), ((Number)args[1]).intValue());
                } else if (args[0] instanceof NativeJavaObject && args[1] instanceof NativeJavaObject && (wrapper = ((NativeJavaObject)args[0]).unwrap()) instanceof ImageWrapper) {
                    Object filter = ((NativeJavaObject)args[1]).unwrap();
                    if (filter instanceof ImageFilter) {
                        img = generator.createImage((ImageWrapper)wrapper, (ImageFilter)filter);
                    } else if (filter instanceof BufferedImageOp) {
                        img = generator.createImage((ImageWrapper)wrapper, (BufferedImageOp)filter);
                    }
                }
            }
        }
        catch (IOException iox) {
            throw new RuntimeException("Error creating Image: " + iox);
        }
        if (img == null) {
            switch (args.length) {
                case 0: {
                    throw new RuntimeException("Error creating Image: Called without arguments");
                }
                case 1: {
                    throw new RuntimeException("Error creating Image from " + args[0]);
                }
                case 2: {
                    throw new RuntimeException("Error creating Image from " + args[0] + ", " + args[1]);
                }
            }
            throw new RuntimeException("Error creating Image: Wrong number of arguments");
        }
        return Context.toObject(img, (Scriptable)ctorObj.getParentScope());
    }

    static class GetInfo
    extends BaseFunction {
        GetInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args.length != 1) {
                throw new IllegalArgumentException("Image.getInfo() expects one argument");
            }
            Object arg = args[0];
            InputStream in = null;
            ImageInfo info = new ImageInfo();
            Scriptable ret = null;
            try {
                if (arg instanceof Wrapper) {
                    arg = ((Wrapper)arg).unwrap();
                }
                if (arg instanceof InputStream) {
                    in = (InputStream)arg;
                } else if (arg instanceof byte[]) {
                    in = new ByteArrayInputStream((byte[])arg);
                } else if (arg instanceof MimePart) {
                    in = new ByteArrayInputStream(((MimePart)arg).getContent());
                } else if (arg instanceof File) {
                    in = new FileInputStream((File)arg);
                } else if (arg instanceof FileObject) {
                    in = new FileInputStream(((FileObject)((Object)arg)).getFile());
                } else if (arg instanceof String) {
                    String str = (String)arg;
                    if (str.indexOf(":") > -1) {
                        try {
                            URL url = new URL(str);
                            in = url.openStream();
                        }
                        catch (MalformedURLException mux) {
                            in = new FileInputStream(str);
                        }
                    } else {
                        in = new FileInputStream(str);
                    }
                }
                if (in == null) {
                    String msg = "Unrecognized argument in Image.getInfo(): ";
                    msg = msg + (arg == null ? "null" : arg.getClass().toString());
                    throw new IllegalArgumentException(msg);
                }
                info.setInput(in);
                if (info.check()) {
                    ret = Context.toObject((Object)info, (Scriptable)scope);
                }
            }
            catch (IOException e) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ee) {}
                }
            }
            return ret;
        }
    }
}

