/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino.extensions;

import com.oroinc.net.ftp.FTPClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class FtpObject
extends ScriptableObject {
    private FTPClient ftpclient;
    private String server;
    private Exception lastError = null;
    private File localDir = null;

    FtpObject(String srvstr) {
        this.server = srvstr;
    }

    FtpObject() {
    }

    public String getClassName() {
        return "FtpClient";
    }

    public String toString() {
        return "[FtpClient]";
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + ((Object)((Object)this)).getClass().getName() + ":" + this.toString() + "]";
    }

    Exception getLastError() {
        if (this.lastError == null) {
            return null;
        }
        return this.lastError;
    }

    public boolean login(String username, String password) {
        if (this.server == null) {
            return false;
        }
        try {
            this.ftpclient = new FTPClient();
            this.ftpclient.connect(this.server);
            return this.ftpclient.login(username, password);
        }
        catch (Exception x) {
            return false;
        }
        catch (NoClassDefFoundError x) {
            return false;
        }
    }

    public boolean cd(String path) {
        if (this.ftpclient == null) {
            return false;
        }
        try {
            this.ftpclient.changeWorkingDirectory(path);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean mkdir(String dir) {
        if (this.ftpclient == null) {
            return false;
        }
        try {
            return this.ftpclient.makeDirectory(dir);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean lcd(String dir) {
        try {
            this.localDir = new File(dir);
            if (!this.localDir.exists()) {
                this.localDir.mkdirs();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean putFile(String localFile, String remoteFile) {
        if (this.ftpclient == null) {
            return false;
        }
        try {
            File f = this.localDir == null ? new File(localFile) : new File(this.localDir, localFile);
            BufferedInputStream fin = new BufferedInputStream(new FileInputStream(f));
            this.ftpclient.storeFile(remoteFile, (InputStream)fin);
            ((InputStream)fin).close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean putString(Object obj, String remoteFile) {
        if (this.ftpclient == null || obj == null) {
            return false;
        }
        try {
            byte[] bytes = null;
            if (obj instanceof byte[]) {
                bytes = (byte[])obj;
            }
            if (bytes == null) {
                bytes = obj.toString().getBytes();
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            this.ftpclient.storeFile(remoteFile, (InputStream)bin);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean getFile(String remoteFile, String localFile) {
        if (this.ftpclient == null) {
            return false;
        }
        try {
            File f = this.localDir == null ? new File(localFile) : new File(this.localDir, localFile);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            this.ftpclient.retrieveFile(remoteFile, (OutputStream)out);
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object getString(String remoteFile) {
        if (this.ftpclient == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.ftpclient.retrieveFile(remoteFile, (OutputStream)bout);
            return bout.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean logout() {
        if (this.ftpclient != null) {
            try {
                this.ftpclient.logout();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                this.ftpclient.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean binary() {
        if (this.ftpclient != null) {
            try {
                this.ftpclient.setFileType(2);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean ascii() {
        if (this.ftpclient != null) {
            try {
                this.ftpclient.setFileType(0);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static FtpObject ftpObjCtor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length != 1 || args[0] == Undefined.instance) {
            throw new IllegalArgumentException("Ftp constructor called without argument");
        }
        return new FtpObject(args[0].toString());
    }

    public static void init(Scriptable scope) {
        Method[] methods = FtpObject.class.getDeclaredMethods();
        FtpObject proto = new FtpObject();
        proto.setPrototype(FtpObject.getObjectPrototype((Scriptable)scope));
        Method ctorMember = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!"ftpObjCtor".equals(methods[i].getName())) continue;
            ctorMember = methods[i];
            break;
        }
        FunctionObject ctor = new FunctionObject("FtpClient", ctorMember, scope);
        ctor.addAsConstructor(scope, (Scriptable)proto);
        String[] ftpFuncs = new String[]{"login", "cd", "mkdir", "lcd", "putFile", "putString", "getFile", "getString", "logout", "binary", "ascii"};
        try {
            proto.defineFunctionProperties(ftpFuncs, FtpObject.class, 0);
        }
        catch (Exception ignore) {
            System.err.println("Error defining function properties: " + ignore);
        }
    }
}

