/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino.extensions;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class FileObject
extends ScriptableObject {
    File file = null;
    Object readerWriter = null;
    boolean atEOF = false;
    String lastLine = null;
    Throwable lastError = null;

    protected FileObject() {
    }

    protected FileObject(String fileName) {
        this.file = new File(fileName).getAbsoluteFile();
    }

    protected FileObject(String pathName, String fileName) {
        this.file = new File(pathName, fileName).getAbsoluteFile();
    }

    public static FileObject fileObjCtor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length == 0 || args[0] == Undefined.instance) {
            throw new IllegalArgumentException("File constructor called without argument");
        }
        if (args.length < 2 || args[1] == Undefined.instance) {
            return new FileObject(args[0].toString());
        }
        return new FileObject(args[0].toString(), args[1].toString());
    }

    public static void init(Scriptable scope) {
        Method[] methods = FileObject.class.getDeclaredMethods();
        FileObject proto = new FileObject();
        proto.setPrototype(FileObject.getObjectPrototype((Scriptable)scope));
        Method ctorMember = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!"fileObjCtor".equals(methods[i].getName())) continue;
            ctorMember = methods[i];
            break;
        }
        FunctionObject ctor = new FunctionObject("File", ctorMember, scope);
        ctor.addAsConstructor(scope, (Scriptable)proto);
        String[] fileFuncs = new String[]{"toString", "getName", "getParent", "isAbsolute", "write", "remove", "list", "flush", "writeln", "close", "getPath", "open", "error", "canRead", "canWrite", "exists", "getAbsolutePath", "getLength", "isDirectory", "isFile", "lastModified", "mkdir", "renameTo", "eof", "isOpened", "readln", "clearError", "readAll"};
        try {
            proto.defineFunctionProperties(fileFuncs, FileObject.class, 0);
        }
        catch (Exception ignore) {
            System.err.println("Error defining function properties: " + ignore);
        }
    }

    public String getClassName() {
        return "File";
    }

    public String toString() {
        if (this.file == null) {
            return "<null>";
        }
        return this.file.toString();
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + ((Object)((Object)this)).getClass().getName() + ":" + (this.file == null ? "null" : this.file.toString()) + "]";
    }

    protected void setError(Throwable e) {
        this.lastError = e;
    }

    public boolean exists() {
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    public boolean open() {
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("File already open"));
            return false;
        }
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        try {
            this.readerWriter = this.file.exists() ? new BufferedReader(new FileReader(this.file)) : new PrintWriter(new FileWriter(this.file));
            return true;
        }
        catch (IOException e) {
            this.setError(e);
            return false;
        }
    }

    public boolean isOpened() {
        return this.readerWriter != null;
    }

    public boolean close() {
        if (this.readerWriter == null) {
            return false;
        }
        try {
            if (this.readerWriter instanceof Reader) {
                ((Reader)this.readerWriter).close();
            } else {
                ((Writer)this.readerWriter).close();
            }
            this.readerWriter = null;
            return true;
        }
        catch (IOException e) {
            this.setError(e);
            this.readerWriter = null;
            return false;
        }
    }

    public boolean write(Object what) {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return false;
        }
        if (!(this.readerWriter instanceof PrintWriter)) {
            this.setError(new IllegalStateException("File not opened for writing"));
            return false;
        }
        PrintWriter writer = (PrintWriter)this.readerWriter;
        if (what != null) {
            writer.print(what.toString());
        }
        return true;
    }

    public boolean writeln(Object what) {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return false;
        }
        if (!(this.readerWriter instanceof PrintWriter)) {
            this.setError(new IllegalStateException("File not opened for writing"));
            return false;
        }
        PrintWriter writer = (PrintWriter)this.readerWriter;
        if (what != null) {
            writer.print(what.toString());
        }
        writer.println();
        return true;
    }

    public String readln() {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return null;
        }
        if (!(this.readerWriter instanceof BufferedReader)) {
            this.setError(new IllegalStateException("File not opened for reading"));
            return null;
        }
        if (this.atEOF) {
            this.setError(new EOFException());
            return null;
        }
        if (this.lastLine != null) {
            String line = this.lastLine;
            this.lastLine = null;
            return line;
        }
        BufferedReader reader = (BufferedReader)this.readerWriter;
        try {
            String line = reader.readLine();
            if (line == null) {
                this.atEOF = true;
                this.setError(new EOFException());
            }
            return line;
        }
        catch (IOException e) {
            this.setError(e);
            return null;
        }
    }

    public boolean eof() {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return true;
        }
        if (!(this.readerWriter instanceof BufferedReader)) {
            this.setError(new IllegalStateException("File not opened for read"));
            return true;
        }
        if (this.atEOF) {
            return true;
        }
        if (this.lastLine != null) {
            return false;
        }
        BufferedReader reader = (BufferedReader)this.readerWriter;
        try {
            this.lastLine = reader.readLine();
            if (this.lastLine == null) {
                this.atEOF = true;
            }
            return this.atEOF;
        }
        catch (IOException e) {
            this.setError(e);
            return true;
        }
    }

    public boolean isFile() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.isFile();
    }

    public boolean isDirectory() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.isDirectory();
    }

    public boolean flush() {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return false;
        }
        if (this.readerWriter instanceof Writer) {
            try {
                ((Writer)this.readerWriter).flush();
            }
            catch (IOException e) {
                this.setError(e);
                return false;
            }
        } else {
            this.setError(new IllegalStateException("File not opened for write"));
            return false;
        }
        return true;
    }

    public double getLength() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return -1.0;
        }
        return this.file.length();
    }

    public double lastModified() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return 0.0;
        }
        return this.file.lastModified();
    }

    public String error() {
        if (this.lastError == null) {
            return "";
        }
        String exceptionName = this.lastError.getClass().getName();
        int l = exceptionName.lastIndexOf(".");
        if (l > 0) {
            exceptionName = exceptionName.substring(l + 1);
        }
        return exceptionName + ": " + this.lastError.getMessage();
    }

    public void clearError() {
        this.lastError = null;
    }

    public boolean remove() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("An openened file cannot be removed"));
            return false;
        }
        return this.file.delete();
    }

    public boolean renameTo(FileObject toFile) {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized source File object"));
            return false;
        }
        if (toFile.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized target File object"));
            return false;
        }
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("An openened file cannot be renamed"));
            return false;
        }
        if (toFile.readerWriter != null) {
            this.setError(new IllegalStateException("You cannot rename to an openened file"));
            return false;
        }
        return this.file.renameTo(toFile.file);
    }

    public boolean canRead() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.canRead();
    }

    public boolean canWrite() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.canWrite();
    }

    public String getParent() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String parent = this.file.getParent();
        return parent == null ? "" : parent;
    }

    public String getName() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String name = this.file.getName();
        return name == null ? "" : name;
    }

    public String getPath() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String path = this.file.getPath();
        return path == null ? "" : path;
    }

    public String getAbsolutePath() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String absolutPath = this.file.getAbsolutePath();
        return absolutPath == null ? "" : absolutPath;
    }

    public boolean isAbsolute() {
        if (this.file == null) {
            return false;
        }
        return this.file.isAbsolute();
    }

    public boolean mkdir() {
        if (this.file == null) {
            return false;
        }
        if (this.readerWriter != null) {
            return false;
        }
        return this.file.mkdirs();
    }

    public Object list() {
        if (this.file == null) {
            return null;
        }
        if (this.readerWriter != null) {
            return null;
        }
        if (!this.file.isDirectory()) {
            return null;
        }
        return this.file.list();
    }

    public String readAll() {
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("File already open"));
            return null;
        }
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return null;
        }
        try {
            String line;
            if (!this.file.exists()) {
                this.setError(new IllegalStateException("File does not exist"));
                return null;
            }
            this.readerWriter = new BufferedReader(new FileReader(this.file));
            if (!this.file.isFile()) {
                this.setError(new IllegalStateException("File is not a regular file"));
                return null;
            }
            StringBuffer buffer = new StringBuffer((int)((double)this.file.length() * 1.1));
            BufferedReader reader = (BufferedReader)this.readerWriter;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            ((Reader)this.readerWriter).close();
            this.readerWriter = null;
            return buffer.toString();
        }
        catch (IOException e) {
            this.readerWriter = null;
            this.setError(e);
            return null;
        }
    }

    protected File getFile() {
        return this.file;
    }
}

