/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino.extensions;

import helma.objectmodel.db.DbSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class DatabaseObject {
    private transient Connection connection = null;
    private transient DatabaseMetaData databaseMetaData = null;
    private transient String driverName = null;
    private transient Exception lastError = null;
    private transient boolean driverOK = false;

    public DatabaseObject(DbSource dbsource) {
        try {
            this.connection = dbsource.getConnection();
            this.driverName = dbsource.getDriverName();
        }
        catch (Exception e) {
            this.lastError = e;
        }
        this.driverOK = true;
    }

    DatabaseObject(String driverName) {
        this.driverName = driverName;
        try {
            Class<?> driverClass = Class.forName(driverName);
            if (!Driver.class.isAssignableFrom(driverClass)) {
                this.lastError = new RuntimeException("Class " + driverClass + " is not a JDBC driver");
            }
            driverClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.lastError = e;
        }
        catch (InstantiationException e) {
            this.lastError = e;
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.driverOK = true;
    }

    DatabaseObject() {
        this.driverName = null;
        this.driverOK = false;
    }

    public String getClassName() {
        return "DatabaseObject";
    }

    public String toString() {
        if (this.driverName == null) {
            return "[database protoype]";
        }
        return "[Database: '" + this.driverName + (this.driverOK ? (this.connection == null ? "' - disconnected] " : " - connected]") : " - in error]");
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
    }

    public Object getLastError() {
        if (this.lastError == null) {
            return null;
        }
        return this.lastError;
    }

    public boolean connect(String url, String userName, String password) {
        if (!this.driverOK) {
            this.lastError = new SQLException("Driver not initialized properly - cannot connect");
            return false;
        }
        this.lastError = null;
        try {
            this.connection = userName == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, userName, password);
        }
        catch (Exception e) {
            this.lastError = e;
            return false;
        }
        return true;
    }

    public boolean disconnect() {
        if (!this.driverOK) {
            this.lastError = new SQLException("Driver not initialized properly - cannot disconnect");
            return false;
        }
        this.lastError = null;
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                this.lastError = null;
            }
            catch (SQLException e) {
                this.lastError = e;
                return false;
            }
        }
        return true;
    }

    public void release() {
        if (this.driverOK) {
            this.disconnect();
        }
    }

    public RowSet executeRetrieval(String sql) {
        if (this.connection == null) {
            this.lastError = new SQLException("JDBC driver not connected");
            return null;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            this.connection.setReadOnly(true);
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(sql);
            return new RowSet(sql, this, statement, resultSet);
        }
        catch (SQLException e) {
            this.lastError = e;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            statement = null;
            return null;
        }
    }

    public int executeCommand(String sql) {
        int count = 0;
        if (this.connection == null) {
            this.lastError = new SQLException("JDBC driver not connected");
            return -1;
        }
        Statement statement = null;
        try {
            this.connection.setReadOnly(false);
            statement = this.connection.createStatement();
            count = statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.lastError = e;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            statement = null;
            return -1;
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return count;
    }

    public Object getMetaData() {
        if (this.databaseMetaData == null) {
            try {
                this.databaseMetaData = this.connection.getMetaData();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.databaseMetaData;
    }

    public static class RowSet {
        private transient String sql = null;
        private transient Statement statement = null;
        private transient ResultSet resultSet = null;
        private transient ResultSetMetaData resultSetMetaData = null;
        private transient Vector colNames = null;
        private transient boolean lastRowSeen = false;
        private transient boolean firstRowSeen = false;
        private transient Exception lastError = null;

        RowSet(String sql, DatabaseObject database, Statement statement, ResultSet resultSet) throws SQLException {
            this.sql = sql;
            this.statement = statement;
            this.resultSet = resultSet;
            if (sql == null) {
                throw new NullPointerException("sql");
            }
            if (resultSet == null) {
                throw new NullPointerException("resultSet");
            }
            if (statement == null) {
                throw new NullPointerException("statement");
            }
            if (database == null) {
                throw new NullPointerException("database");
            }
            try {
                this.resultSetMetaData = resultSet.getMetaData();
                int numcols = this.resultSetMetaData.getColumnCount();
                this.colNames = new Vector(numcols);
                for (int i = 0; i < numcols; ++i) {
                    String colName = this.resultSetMetaData.getColumnLabel(i + 1);
                    this.colNames.addElement(colName);
                }
            }
            catch (SQLException e) {
                this.colNames = new Vector();
                throw new SQLException("Could not get column names: " + e);
            }
        }

        public String getClassName() {
            return "RowSet";
        }

        public String toDetailString() {
            return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
        }

        public int getColumnCount() {
            return this.colNames.size();
        }

        public Object getMetaData() {
            return this.resultSetMetaData;
        }

        public Object getLastError() {
            if (this.lastError == null) {
                return null;
            }
            return this.lastError;
        }

        public void release() {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statement = null;
            this.resultSet = null;
            this.resultSetMetaData = null;
        }

        public boolean hasMoreRows() {
            return !this.lastRowSeen;
        }

        public String getColumnName(int idx) {
            if (this.resultSet == null) {
                this.lastError = new SQLException("Attempt to access a released result set");
                return null;
            }
            if (idx > 0 && idx <= this.colNames.size()) {
                return (String)this.colNames.elementAt(idx - 1);
            }
            this.lastError = new SQLException("Column index (base 1) " + idx + " out of range, max: " + this.colNames.size());
            return null;
        }

        public int getColumnDatatypeNumber(int idx) {
            if (this.resultSet == null) {
                this.lastError = new SQLException("Attempt to access a released result set");
                return -1;
            }
            if (idx > 0 && idx <= this.colNames.size()) {
                try {
                    return this.resultSetMetaData.getColumnType(idx);
                }
                catch (SQLException e) {
                    this.lastError = e;
                    return -1;
                }
            }
            this.lastError = new SQLException("Column index (base 1) " + idx + " out of range, max: " + this.colNames.size());
            return -1;
        }

        public String getColumnDatatypeName(int idx) {
            if (this.resultSet == null) {
                this.lastError = new SQLException("Attempt to access a released result set");
                return null;
            }
            if (idx > 0 && idx <= this.colNames.size()) {
                try {
                    return this.resultSetMetaData.getColumnTypeName(idx);
                }
                catch (SQLException e) {
                    this.lastError = e;
                    return null;
                }
            }
            this.lastError = new SQLException("Column index (base 1) " + idx + " out of range, max: " + this.colNames.size());
            return null;
        }

        public Object getColumnItem(String propertyName) {
            if (this.resultSet == null) {
                this.lastError = new SQLException("Attempt to access a released result set");
                return null;
            }
            if (!this.firstRowSeen) {
                this.lastError = new SQLException("Attempt to access data before the first row is read");
                return null;
            }
            try {
                try {
                    int index = Integer.parseInt(propertyName);
                    return this.getProperty(index);
                }
                catch (NumberFormatException e) {
                    int index = this.resultSet.findColumn(propertyName);
                    return this.getProperty(index);
                }
            }
            catch (SQLException e) {
                this.lastError = e;
                return null;
            }
        }

        /*
         * Exception decompiling
         */
        public Object getProperty(int index) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 4[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Enumeration getProperties() {
            if (this.resultSet == null) {
                return new Vector().elements();
            }
            return this.colNames.elements();
        }

        public String[] getSpecialPropertyNames() {
            return new String[]{"length"};
        }

        public boolean next() {
            boolean status = false;
            if (this.lastRowSeen) {
                this.lastError = new SQLException("Attempt to access a next row after last row has been returned");
                return false;
            }
            if (this.resultSet == null) {
                this.lastError = new SQLException("Attempt to access a released result set");
                return false;
            }
            try {
                status = this.resultSet.next();
                this.lastError = null;
            }
            catch (SQLException e) {
                this.lastError = e;
            }
            if (status) {
                this.firstRowSeen = true;
            } else {
                this.lastRowSeen = true;
            }
            return status;
        }

        public String toString() {
            return "[RowSet: '" + this.sql + "'" + (this.resultSet == null ? " - released]" : (this.lastRowSeen ? " - at end]" : (this.firstRowSeen ? "]" : " - at start]")));
        }
    }
}

