/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino.debug;

import helma.framework.ResponseTrans;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class Tracer
implements Debugger {
    ResponseTrans res;

    public Tracer(ResponseTrans res) {
        this.res = res;
    }

    public void handleCompilationDone(Context cx, DebuggableScript script, String source) {
    }

    public DebugFrame getFrame(Context cx, DebuggableScript script) {
        if (script.isFunction()) {
            return new TracerFrame(script);
        }
        return null;
    }

    static String toString(DebuggableScript script) {
        if (script.isFunction()) {
            return script.getSourceName() + ": " + script.getFunctionName();
        }
        return script.getSourceName();
    }

    class TracerFrame
    implements DebugFrame {
        DebuggableScript script;

        TracerFrame(DebuggableScript script) {
            this.script = script;
        }

        public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
            StringBuffer b = new StringBuffer("Trace: ");
            b.append(Tracer.toString(this.script));
            b.append("(");
            for (int i = 0; i < args.length; ++i) {
                b.append(args[i]);
                if (i >= args.length - 1) continue;
                b.append(", ");
            }
            b.append(")");
            Tracer.this.res.debug(b.toString());
        }

        public void onExceptionThrown(Context cx, Throwable ex) {
            Tracer.this.res.debug("Exception Thrown: " + ex);
        }

        public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        }

        public void onLineChange(Context cx, int lineNumber) {
        }
    }
}

