/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino;

import helma.doc.DocApplication;
import helma.extensions.ConfigurationException;
import helma.extensions.HelmaExtension;
import helma.framework.IPathElement;
import helma.framework.RedirectException;
import helma.framework.RequestTrans;
import helma.framework.ResponseTrans;
import helma.framework.TimeoutException;
import helma.framework.core.Application;
import helma.framework.core.RequestEvaluator;
import helma.framework.core.RequestPath;
import helma.framework.core.Skin;
import helma.framework.repository.Resource;
import helma.main.Server;
import helma.objectmodel.ConcurrencyException;
import helma.objectmodel.INode;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Relation;
import helma.scripting.ScriptingEngine;
import helma.scripting.ScriptingException;
import helma.scripting.rhino.GlobalObject;
import helma.scripting.rhino.PathWrapper;
import helma.scripting.rhino.RhinoCore;
import helma.scripting.rhino.SkinKey;
import helma.scripting.rhino.debug.Tracer;
import helma.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.serialize.ScriptableInputStream;
import org.mozilla.javascript.serialize.ScriptableOutputStream;

public class RhinoEngine
implements ScriptingEngine {
    static final Map coreMap = new WeakHashMap();
    public Application app;
    Context context;
    GlobalObject global;
    RequestEvaluator reval;
    RhinoCore core;
    HashMap extensionGlobals;
    volatile Thread thread;
    static ThreadLocal engines = new ThreadLocal();
    DocApplication doc = null;

    public synchronized void init(Application app, RequestEvaluator reval) {
        this.app = app;
        this.reval = reval;
        this.initRhinoCore(app);
        this.context = this.core.contextFactory.enter();
        try {
            this.extensionGlobals = new HashMap();
            if (Server.getServer() != null) {
                Vector extVec = Server.getServer().getExtensions();
                for (int i = 0; i < extVec.size(); ++i) {
                    HelmaExtension ext = (HelmaExtension)extVec.get(i);
                    try {
                        HashMap tmpGlobals = ext.initScripting(app, this);
                        if (tmpGlobals == null) continue;
                        this.extensionGlobals.putAll(tmpGlobals);
                        continue;
                    }
                    catch (ConfigurationException e) {
                        app.logError("Couldn't initialize extension " + ext.getName(), e);
                    }
                }
            }
        }
        catch (Exception e) {
            app.logError("Cannot initialize interpreter", e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.core.contextFactory.exit();
        }
    }

    public static RhinoEngine getRhinoEngine() {
        return (RhinoEngine)engines.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initRhinoCore(Application app) {
        Map map = coreMap;
        synchronized (map) {
            WeakReference ref = (WeakReference)coreMap.get(app);
            if (ref != null) {
                this.core = (RhinoCore)ref.get();
            }
            if (this.core == null) {
                this.core = new RhinoCore(app);
                this.core.initialize();
                coreMap.put(app, new WeakReference<RhinoCore>(this.core));
            }
        }
    }

    public synchronized void updatePrototypes() throws IOException {
        this.thread = Thread.currentThread();
        this.global = new GlobalObject(this.core, this.app, true);
        this.context = this.core.contextFactory.enter();
        if (this.core.hasTracer) {
            this.context.setDebugger((Debugger)new Tracer(this.getResponse()), null);
        }
        engines.set(this);
        this.core.updatePrototypes();
    }

    public synchronized void enterContext(Map globals) throws ScriptingException {
        this.thread = Thread.currentThread();
        globals.putAll(this.extensionGlobals);
        Iterator i = globals.keySet().iterator();
        while (i.hasNext()) {
            Object scriptable;
            String k = (String)i.next();
            Object v = globals.get(k);
            if (v == null) continue;
            if (v instanceof RequestPath) {
                scriptable = new PathWrapper((RequestPath)v, this.core);
                scriptable.setPrototype((Scriptable)this.core.pathProto);
            } else {
                scriptable = Context.toObject(v, (Scriptable)this.global);
            }
            this.global.put(k, (Scriptable)this.global, scriptable);
        }
    }

    public synchronized void exitContext() {
        engines.set(null);
        this.core.contextFactory.exit();
        this.thread = null;
        this.global = null;
    }

    public Object invoke(Object thisObject, Object function, Object[] args, int argsWrapMode, boolean resolve) throws ScriptingException {
        if (function == null) {
            throw new IllegalArgumentException("Function argument must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Arguments array must not be null");
        }
        try {
            Function func;
            GlobalObject obj;
            GlobalObject globalObject = obj = thisObject == null ? this.global : Context.toObject((Object)thisObject, (Scriptable)this.global);
            if (function instanceof String) {
                Object funcvalue;
                String funcName = (String)function;
                if (resolve) {
                    if (funcName.indexOf(46) > 0) {
                        String[] path = StringUtils.split(funcName, ".");
                        for (int i = 0; i < path.length - 1; ++i) {
                            Object propValue = ScriptableObject.getProperty((Scriptable)obj, (String)path[i]);
                            if (!(propValue instanceof Scriptable)) {
                                throw new RuntimeException("Can't resolve function name " + funcName + " in " + thisObject);
                            }
                            obj = (Scriptable)propValue;
                        }
                        funcName = path[path.length - 1];
                    }
                } else {
                    funcName = funcName.replace('.', '_');
                }
                if (!((funcvalue = ScriptableObject.getProperty((Scriptable)obj, (String)funcName)) instanceof Function)) {
                    return null;
                }
                func = (Function)funcvalue;
            } else {
                if (function instanceof Wrapper) {
                    function = ((Wrapper)function).unwrap();
                }
                if (!(function instanceof Function)) {
                    throw new IllegalArgumentException("Not a function or function name: " + function);
                }
                func = (Function)function;
            }
            block10: for (int i = 0; i < args.length; ++i) {
                switch (argsWrapMode) {
                    case 1: {
                        if (args[i] == null) continue block10;
                        args[i] = Context.javaToJS((Object)args[i], (Scriptable)this.global);
                        continue block10;
                    }
                    case 2: {
                        args[i] = this.core.processXmlRpcArgument(args[i]);
                    }
                }
            }
            Object retval = Context.call((ContextFactory)this.core.contextFactory, (Callable)func, (Scriptable)this.global, (Scriptable)obj, (Object[])args);
            if (retval instanceof Wrapper) {
                retval = ((Wrapper)retval).unwrap();
            }
            if (retval == null || retval == Undefined.instance) {
                return null;
            }
            if (argsWrapMode == 2) {
                return this.core.processXmlRpcResponse(retval);
            }
            return retval;
        }
        catch (RedirectException redirect) {
            throw redirect;
        }
        catch (TimeoutException timeout) {
            throw timeout;
        }
        catch (ConcurrencyException concur) {
            throw concur;
        }
        catch (Exception x) {
            if (this.thread != Thread.currentThread()) {
                throw new TimeoutException();
            }
            if (x instanceof WrappedException) {
                Throwable wrapped = ((WrappedException)x).getWrappedException();
                if (wrapped instanceof ConcurrencyException) {
                    throw (ConcurrencyException)wrapped;
                }
                if (wrapped instanceof RedirectException) {
                    throw (RedirectException)wrapped;
                }
            }
            String msg = x.getMessage();
            throw new ScriptingException(msg, x);
        }
    }

    public void abort() {
        Thread t = this.thread;
        this.thread = null;
        if (t != null && t.isAlive()) {
            t.interrupt();
            try {
                t.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean hasFunction(Object obj, String fname, boolean resolve) {
        String protoname;
        if (resolve) {
            if (fname.indexOf(46) > 0) {
                GlobalObject op = obj == null ? this.global : Context.toObject((Object)obj, (Scriptable)this.global);
                String[] path = StringUtils.split(fname, ".");
                for (int i = 0; i < path.length; ++i) {
                    Object value = ScriptableObject.getProperty((Scriptable)op, (String)path[i]);
                    if (!(value instanceof Scriptable)) {
                        return false;
                    }
                    op = (Scriptable)value;
                }
                return op instanceof Function;
            }
        } else {
            fname = fname.replace('.', '_');
        }
        if (obj instanceof INode && (protoname = ((INode)obj).getPrototype()) != null && this.core.hasFunction(protoname, fname)) {
            return true;
        }
        GlobalObject op = obj == null ? this.global : Context.toObject((Object)obj, (Scriptable)this.global);
        return ScriptableObject.getProperty((Scriptable)op, (String)fname) instanceof Callable;
    }

    public boolean hasProperty(Object obj, String propname) {
        Relation rel;
        DbMapping dbm;
        if (obj == null || propname == null) {
            return false;
        }
        if (obj instanceof Map) {
            return ((Map)obj).containsKey(propname);
        }
        String prototypeName = this.app.getPrototypeName(obj);
        if ("user".equalsIgnoreCase(prototypeName) && "password".equalsIgnoreCase(propname)) {
            return false;
        }
        if (obj instanceof INode && !"hopobject".equalsIgnoreCase(prototypeName) && (dbm = this.app.getDbMapping(prototypeName)) != null && (rel = dbm.propertyToRelation(propname)) != null && (rel.isPrimitive() || rel.isCollection())) {
            return true;
        }
        Scriptable wrapped = Context.toObject((Object)obj, (Scriptable)this.global);
        return wrapped.has(propname, wrapped);
    }

    public Object getProperty(Object obj, String propname) {
        if (obj == null || propname == null) {
            return null;
        }
        if (obj instanceof Map) {
            Object prop = ((Map)obj).get(propname);
            return prop instanceof Function ? null : prop;
        }
        Scriptable so = Context.toObject((Object)obj, (Scriptable)this.global);
        try {
            Object prop = so.get(propname, so);
            if (prop == null || prop == Undefined.instance || prop == ScriptableObject.NOT_FOUND) {
                return null;
            }
            if (prop instanceof Wrapper) {
                return ((Wrapper)prop).unwrap();
            }
            return prop instanceof Function ? null : prop;
        }
        catch (Exception esx) {
            this.app.logError("Error getting property " + propname + ": " + esx);
            return null;
        }
    }

    public boolean isTypedObject(Object obj) {
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        if (obj == null || obj instanceof Map || obj instanceof NativeObject) {
            return false;
        }
        if (obj instanceof IPathElement) {
            String protoName = ((IPathElement)obj).getPrototype();
            return protoName != null && !"hopobject".equalsIgnoreCase(protoName);
        }
        return true;
    }

    public String toString(Object obj) {
        try {
            return ScriptRuntime.toString((Object)obj);
        }
        catch (Exception exception) {
            return obj.toString();
        }
    }

    public DocApplication getDoc() {
        if (this.doc == null) {
            try {
                this.doc = new DocApplication(this.app);
                this.doc.readApplication();
            }
            catch (IOException x) {
                throw new RuntimeException(x.toString(), x);
            }
        }
        return this.doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object obj, OutputStream out) throws IOException {
        this.core.contextFactory.enter();
        try {
            ScriptableOutputStream sout = new ScriptableOutputStream(out, (Scriptable)this.core.global){

                protected Object replaceObject(Object obj) throws IOException {
                    if (obj instanceof Wrapper) {
                        obj = ((Wrapper)obj).unwrap();
                    }
                    return super.replaceObject(obj);
                }
            };
            sout.writeObject(obj);
            sout.flush();
        }
        finally {
            this.core.contextFactory.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(InputStream in) throws IOException, ClassNotFoundException {
        this.core.contextFactory.enter();
        try {
            ScriptableInputStream sin = new ScriptableInputStream(in, (Scriptable)this.core.global);
            Object object = sin.readObject();
            return object;
        }
        finally {
            this.core.contextFactory.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectCodeResource(String typename, Resource resource) {
        if (this.global != null) {
            this.global.startRecording();
        }
        try {
            this.core.injectCodeResource(typename, resource);
        }
        finally {
            if (this.global != null) {
                this.global.stopRecording();
            }
        }
    }

    public Application getApplication() {
        return this.app;
    }

    public RequestEvaluator getRequestEvaluator() {
        return this.reval;
    }

    public ResponseTrans getResponse() {
        return this.reval.getResponse();
    }

    public RequestTrans getRequest() {
        return this.reval.getRequest();
    }

    public RhinoCore getCore() {
        return this.core;
    }

    public Skin toSkin(Object skinobj, String protoName) throws IOException {
        if (skinobj == null) {
            return null;
        }
        if (skinobj instanceof Wrapper) {
            skinobj = ((Wrapper)skinobj).unwrap();
        }
        if (skinobj instanceof Skin) {
            return (Skin)skinobj;
        }
        return this.getSkin(protoName, skinobj.toString());
    }

    public Skin getSkin(String protoName, String skinName) throws IOException {
        ResponseTrans res = this.getResponse();
        if (skinName.startsWith("#")) {
            Skin skin = res.getActiveSkin();
            return skin == null ? null : skin.getSubskin(skinName.substring(1));
        }
        SkinKey key = new SkinKey(protoName, skinName);
        Skin skin = res.getCachedSkin(key);
        if (skin == null) {
            Object[] skinpath = res.getSkinpath();
            RhinoCore.unwrapSkinpath(skinpath);
            skin = this.app.getSkin(protoName, skinName, skinpath);
            res.cacheSkin(key, skin);
        }
        return skin;
    }
}

