/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino;

import helma.framework.core.Application;
import helma.framework.core.Prototype;
import helma.framework.core.Skin;
import helma.framework.repository.Resource;
import helma.objectmodel.INode;
import helma.objectmodel.db.DbMapping;
import helma.scripting.ScriptingException;
import helma.scripting.rhino.GlobalObject;
import helma.scripting.rhino.HacHspConverter;
import helma.scripting.rhino.HopObject;
import helma.scripting.rhino.HopObjectCtor;
import helma.scripting.rhino.JavaObject;
import helma.scripting.rhino.MapWrapper;
import helma.scripting.rhino.PathWrapper;
import helma.scripting.rhino.PropertyRecorder;
import helma.scripting.rhino.RhinoEngine;
import helma.scripting.rhino.debug.HelmaDebugger;
import helma.scripting.rhino.extensions.MailObject;
import helma.util.CacheMap;
import helma.util.SystemMap;
import helma.util.WeakCacheMap;
import helma.util.WrappedMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.tools.debugger.ScopeProvider;

public final class RhinoCore
implements ScopeProvider {
    public final Application app;
    ContextFactory contextFactory;
    GlobalObject global;
    CacheMap wrappercache;
    Hashtable prototypes;
    volatile long lastUpdate = 0L;
    WrapFactory wrapper;
    ScriptableObject hopObjectProto;
    PathWrapper pathProto;
    String globalError;
    HelmaDebugger debugger = null;
    int optLevel = 0;
    boolean hasDebugger = false;
    boolean hasTracer = false;
    private boolean isInitialized = false;
    long updateSnooze = 500L;

    public RhinoCore(Application app) {
        this.app = app;
        this.wrappercache = new WeakCacheMap(500);
        this.prototypes = new Hashtable();
        this.contextFactory = new HelmaContextFactory();
        this.contextFactory.initApplicationClassLoader(app.getClassLoader());
    }

    protected synchronized void initialize() {
        this.hasDebugger = "true".equalsIgnoreCase(this.app.getProperty("rhino.debug"));
        this.hasTracer = "true".equalsIgnoreCase(this.app.getProperty("rhino.trace"));
        if (this.hasDebugger || this.hasTracer) {
            this.optLevel = -1;
        } else {
            String opt = this.app.getProperty("rhino.optlevel");
            if (opt != null) {
                try {
                    this.optLevel = Integer.parseInt(opt);
                }
                catch (Exception ignore) {
                    this.app.logError("Invalid rhino optlevel: " + opt);
                }
            }
        }
        this.wrapper = new WrapMaker();
        this.wrapper.setJavaPrimitiveWrap(false);
        Context context = this.contextFactory.enter();
        try {
            this.global = new GlobalObject(this, this.app, false);
            this.global.initStandardObjects(context, false);
            this.global.init();
            this.pathProto = new PathWrapper(this);
            this.hopObjectProto = HopObject.init(this);
            new LazilyLoadedCtor((ScriptableObject)this.global, "File", "helma.scripting.rhino.extensions.FileObject", false);
            new LazilyLoadedCtor((ScriptableObject)this.global, "Ftp", "helma.scripting.rhino.extensions.FtpObject", false);
            new LazilyLoadedCtor((ScriptableObject)this.global, "Image", "helma.scripting.rhino.extensions.ImageObject", false);
            new LazilyLoadedCtor((ScriptableObject)this.global, "Remote", "helma.scripting.rhino.extensions.XmlRpcObject", false);
            MailObject.init((Scriptable)this.global, this.app.getProperties());
            Scriptable stringProto = ScriptableObject.getClassPrototype((Scriptable)this.global, (String)"String");
            stringProto.put("trim", stringProto, (Object)new StringTrim());
            Scriptable dateProto = ScriptableObject.getClassPrototype((Scriptable)this.global, (String)"Date");
            dateProto.put("format", dateProto, (Object)new DateFormat());
            Scriptable numberProto = ScriptableObject.getClassPrototype((Scriptable)this.global, (String)"Number");
            numberProto.put("format", numberProto, (Object)new NumberFormat());
            Collection protos = this.app.getPrototypes();
            Iterator i = protos.iterator();
            while (i.hasNext()) {
                Prototype proto = (Prototype)i.next();
                this.initPrototype(proto);
            }
            this.getPrototype("global");
        }
        catch (Exception e) {
            this.app.logError("Cannot initialize interpreter", e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.contextFactory.exit();
            this.isInitialized = true;
        }
    }

    boolean isInitialized() {
        return this.isInitialized;
    }

    void initDebugger(Context context) {
        try {
            if (this.debugger == null) {
                this.debugger = new HelmaDebugger(this.app.getName());
                this.debugger.setScopeProvider(this);
                this.debugger.attachTo(this.contextFactory);
            }
        }
        catch (Exception x) {
            this.app.logError("Error setting up debugger", x);
        }
    }

    private synchronized void initPrototype(Prototype prototype) {
        Object op;
        String name = prototype.getName();
        String lowerCaseName = prototype.getLowerCaseName();
        TypeInfo type = (TypeInfo)this.prototypes.get(lowerCaseName);
        ScriptableObject scriptableObject = op = type == null ? null : type.objProto;
        if (op == null) {
            op = "global".equals(lowerCaseName) ? this.global : ("hopobject".equals(lowerCaseName) ? this.hopObjectProto : new HopObject(name, this));
            this.registerPrototype(prototype, (ScriptableObject)op);
        }
        if (!"global".equals(lowerCaseName)) {
            try {
                new HopObjectCtor(name, this, (Scriptable)op);
                op.setParentScope((Scriptable)this.global);
            }
            catch (Exception x) {
                this.app.logError("Error adding ctor for " + name, x);
            }
        }
    }

    private synchronized void evaluatePrototype(final TypeInfo type) {
        type.prepareCompilation();
        final Prototype prototype = type.frameworkProto;
        this.setParentPrototype(prototype, type);
        type.error = null;
        if ("global".equals(prototype.getLowerCaseName())) {
            this.globalError = null;
        }
        this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                Iterator code = prototype.getCodeResources();
                while (code.hasNext()) {
                    RhinoCore.this.evaluate(cx, type, (Resource)code.next());
                }
                return null;
            }
        });
        type.commitCompilation();
    }

    private void setParentPrototype(Prototype prototype, TypeInfo type) {
        String name = prototype.getName();
        String lowerCaseName = prototype.getLowerCaseName();
        if (!"global".equals(lowerCaseName) && !"hopobject".equals(lowerCaseName)) {
            TypeInfo parentType = null;
            Prototype parent = prototype.getParentPrototype();
            if (parent != null) {
                parentType = this.getPrototypeInfo(parent.getName());
            }
            if (parentType == null && !this.app.isJavaPrototype(name)) {
                parentType = this.getPrototypeInfo("hopobject");
            }
            type.setParentType(parentType);
        }
    }

    public synchronized void updatePrototypes() throws IOException {
        if (System.currentTimeMillis() - this.lastUpdate < 1000L + this.updateSnooze) {
            return;
        }
        this.app.typemgr.checkPrototypes();
        Collection protos = this.app.getPrototypes();
        HashSet checked = new HashSet(protos.size() * 2);
        TypeInfo type = (TypeInfo)this.prototypes.get("global");
        if (type != null) {
            this.updatePrototype(type, checked);
        }
        Iterator i = protos.iterator();
        while (i.hasNext()) {
            Prototype proto = (Prototype)i.next();
            if (checked.contains(proto)) continue;
            type = (TypeInfo)this.prototypes.get(proto.getLowerCaseName());
            if (type == null) {
                this.initPrototype(proto);
                continue;
            }
            if (type.lastUpdate <= -1L) continue;
            this.updatePrototype(type, checked);
        }
        this.lastUpdate = System.currentTimeMillis();
        long newSnooze = (this.lastUpdate - this.app.typemgr.getLastCodeUpdate()) / 1000L;
        this.updateSnooze = Math.min(4000L, Math.max(0L, newSnooze));
    }

    private void updatePrototype(TypeInfo type, HashSet checked) {
        checked.add(type.frameworkProto);
        if (type.parentType != null && !checked.contains(type.parentType.frameworkProto)) {
            this.updatePrototype(type.getParentType(), checked);
        }
        type.frameworkProto.checkForUpdates();
        if (type.needsUpdate()) {
            this.evaluatePrototype(type);
        }
    }

    public Scriptable getValidPrototype(String protoName) {
        if (this.globalError != null) {
            throw new EvaluatorException(this.globalError);
        }
        TypeInfo type = this.getPrototypeInfo(protoName);
        if (type != null) {
            if (type.hasError()) {
                throw new EvaluatorException(type.getError());
            }
            return type.objProto;
        }
        return null;
    }

    public Scriptable getPrototype(String protoName) {
        TypeInfo type = this.getPrototypeInfo(protoName);
        return type == null ? null : type.objProto;
    }

    public Map getPrototypeProperties(String protoName) {
        TypeInfo type = this.getPrototypeInfo(protoName);
        SystemMap map = new SystemMap();
        Iterator it = type.compiledProperties.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!(key instanceof String)) continue;
            map.put(key, type.objProto.get((String)key, (Scriptable)type.objProto));
        }
        return map;
    }

    private TypeInfo getPrototypeInfo(String protoName) {
        if (protoName == null) {
            return null;
        }
        TypeInfo type = (TypeInfo)this.prototypes.get(protoName.toLowerCase());
        if (type != null && type.lastUpdate == -1L) {
            type.frameworkProto.checkForUpdates();
            if (type.needsUpdate()) {
                this.evaluatePrototype(type);
            }
        }
        return type;
    }

    private TypeInfo registerPrototype(Prototype proto, ScriptableObject op) {
        TypeInfo type = new TypeInfo(proto, op);
        this.prototypes.put(proto.getLowerCaseName(), type);
        return type;
    }

    public boolean hasFunction(String protoname, String fname) {
        Scriptable op = this.getValidPrototype(protoname);
        if (op == null) {
            return false;
        }
        return ScriptableObject.getProperty((Scriptable)op, (String)fname) instanceof Function;
    }

    public Object processXmlRpcArgument(Object what) {
        if (what == null) {
            return null;
        }
        if (what instanceof Vector) {
            Vector v = (Vector)what;
            Object[] a = v.toArray();
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.processXmlRpcArgument(a[i]);
            }
            return Context.getCurrentContext().newArray((Scriptable)this.global, a);
        }
        if (what instanceof Hashtable) {
            Hashtable t = (Hashtable)what;
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                t.put(key, this.processXmlRpcArgument(t.get(key)));
            }
            return Context.toObject((Object)new SystemMap((Map)t), (Scriptable)this.global);
        }
        if (what instanceof String) {
            return what;
        }
        if (what instanceof Number) {
            return what;
        }
        if (what instanceof Boolean) {
            return what;
        }
        if (what instanceof Date) {
            Date d = (Date)what;
            Object[] args = new Object[]{new Long(d.getTime())};
            return Context.getCurrentContext().newObject((Scriptable)this.global, "Date", args);
        }
        return Context.toObject((Object)what, (Scriptable)this.global);
    }

    public Object processXmlRpcResponse(Object what) {
        Scriptable s;
        if (what instanceof Wrapper) {
            what = ((Wrapper)what).unwrap();
        }
        if (what instanceof NativeObject) {
            NativeObject no = (NativeObject)what;
            Object[] ids = no.getIds();
            Hashtable<String, Object> ht = new Hashtable<String, Object>(ids.length * 2);
            for (int i = 0; i < ids.length; ++i) {
                String key;
                Object o;
                if (!(ids[i] instanceof String) || (o = no.get(key = (String)ids[i], (Scriptable)no)) == null) continue;
                ht.put(key, this.processXmlRpcResponse(o));
            }
            what = ht;
        } else if (what instanceof NativeArray) {
            NativeArray na = (NativeArray)what;
            Number n = (Number)na.get("length", (Scriptable)na);
            int l = n.intValue();
            Vector<Object> retval = new Vector<Object>(l);
            for (int i = 0; i < l; ++i) {
                retval.add(i, this.processXmlRpcResponse(na.get(i, (Scriptable)na)));
            }
            what = retval;
        } else if (what instanceof Map) {
            Map map = what;
            Hashtable<String, Object> ht = new Hashtable<String, Object>(map.size() * 2);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ht.put(entry.getKey().toString(), this.processXmlRpcResponse(entry.getValue()));
            }
            what = ht;
        } else if (what instanceof Number) {
            Number n = (Number)what;
            if (what instanceof Float || what instanceof Long) {
                what = new Double(n.doubleValue());
            } else if (!(what instanceof Double)) {
                what = new Integer(n.intValue());
            }
        } else if (what instanceof Scriptable && "Date".equals((s = (Scriptable)what).getClassName())) {
            what = new Date((long)ScriptRuntime.toNumber((Object)s));
        }
        return what;
    }

    public Application getApplication() {
        return this.app;
    }

    public Scriptable getElementWrapper(Object e) {
        Object wrapper;
        WeakReference ref = (WeakReference)this.wrappercache.get(e);
        Wrapper wrapper2 = wrapper = ref == null ? null : (Wrapper)ref.get();
        if (wrapper == null || wrapper.unwrap() != e) {
            String prototypeName = this.app.getPrototypeName(e);
            Scriptable op = this.getPrototype(prototypeName);
            wrapper = op == null ? new NativeJavaObject((Scriptable)this.global, e, e.getClass()) : new JavaObject((Scriptable)this.global, e, prototypeName, op, this);
            this.wrappercache.put(e, new WeakReference<Wrapper>((Wrapper)wrapper));
        }
        return (Scriptable)wrapper;
    }

    public Scriptable getNodeWrapper(INode n) {
        if (n == null) {
            return null;
        }
        HopObject hobj = (HopObject)this.wrappercache.get(n);
        if (hobj == null) {
            String protoname = n.getPrototype();
            Scriptable op = this.getValidPrototype(protoname);
            if (op == null) {
                DbMapping dbmap = n.getDbMapping();
                if (dbmap != null && (protoname = dbmap.getTypeName()) != null) {
                    op = this.getValidPrototype(protoname);
                }
                if (op == null) {
                    protoname = "HopObject";
                    op = this.getValidPrototype("HopObject");
                }
            }
            hobj = new HopObject(protoname, this, n, op);
            this.wrappercache.put(n, hobj);
        }
        return hobj;
    }

    protected String postProcessHref(Object obj, String protoName, String href) throws UnsupportedEncodingException, IOException {
        String hrefSkin;
        String hrefFunction = this.app.getProperty("hrefFunction", null);
        if (hrefFunction != null) {
            Object handler = obj;
            String proto = protoName;
            while (handler != null) {
                if (this.hasFunction(proto, hrefFunction)) {
                    Object result;
                    RhinoEngine eng = RhinoEngine.getRhinoEngine();
                    try {
                        result = eng.invoke(handler, hrefFunction, new Object[]{href}, 1, false);
                    }
                    catch (ScriptingException x) {
                        throw new EvaluatorException("Error in hrefFunction: " + x);
                    }
                    if (result == null) {
                        throw new EvaluatorException("hrefFunction " + hrefFunction + " returned null");
                    }
                    href = result.toString();
                    break;
                }
                handler = this.app.getParentElement(handler);
                proto = this.app.getPrototypeName(handler);
            }
        }
        if ((hrefSkin = this.app.getProperty("hrefSkin", null)) != null) {
            Skin skin = null;
            Object handler = obj;
            RhinoEngine eng = RhinoEngine.getRhinoEngine();
            while (handler != null) {
                Prototype proto = this.app.getPrototype(handler);
                if (proto != null) {
                    skin = eng.getSkin(proto.getName(), hrefSkin);
                }
                if (skin != null) {
                    Scriptable param = Context.getCurrentContext().newObject((Scriptable)this.global);
                    param.put("path", param, (Object)href);
                    href = skin.renderAsString(eng.getRequestEvaluator(), handler, param).trim();
                    break;
                }
                handler = this.app.getParentElement(handler);
            }
        }
        return href;
    }

    public static RhinoCore getCore() {
        RhinoEngine eng = RhinoEngine.getRhinoEngine();
        return eng != null ? eng.core : null;
    }

    protected static Object[] unwrapSkinpath(Object[] skinpath) {
        if (skinpath != null) {
            for (int i = 0; i < skinpath.length; ++i) {
                if (skinpath[i] instanceof HopObject) {
                    skinpath[i] = ((HopObject)skinpath[i]).getNode();
                    continue;
                }
                if (!(skinpath[i] instanceof Wrapper)) continue;
                skinpath[i] = ((Wrapper)skinpath[i]).unwrap();
            }
        }
        return skinpath;
    }

    public void injectCodeResource(String typename, final Resource code) {
        final TypeInfo type = (TypeInfo)this.prototypes.get(typename.toLowerCase());
        if (type == null || type.lastUpdate == -1L) {
            return;
        }
        this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                RhinoCore.this.evaluate(cx, type, code);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void evaluate(Context cx, TypeInfo type, Resource code) {
        String sourceName = code.getName();
        Reader reader = null;
        Resource previousCurrentResource = this.app.getCurrentCodeResource();
        this.app.setCurrentCodeResource(code);
        String encoding = this.app.getProperty("sourceCharset");
        try {
            ScriptableObject op = type.objProto;
            if (sourceName.endsWith(".js")) {
                reader = encoding == null ? new InputStreamReader(code.getInputStream()) : new InputStreamReader(code.getInputStream(), encoding);
                cx.evaluateReader((Scriptable)op, reader, sourceName, 1, null);
            } else if (sourceName.endsWith(".hac")) {
                reader = new StringReader(HacHspConverter.convertHac(code, encoding));
                cx.evaluateReader((Scriptable)op, reader, sourceName, 0, null);
            } else if (sourceName.endsWith(".hsp")) {
                reader = new StringReader(HacHspConverter.convertHsp(code, encoding));
                cx.evaluateReader((Scriptable)op, reader, sourceName, 0, null);
                reader = new StringReader(HacHspConverter.convertHspAsString(code, encoding));
                cx.evaluateReader((Scriptable)op, reader, sourceName, 0, null);
            }
        }
        catch (Exception e) {
            ScriptingException sx = new ScriptingException(e.getMessage(), e);
            this.app.logError("Error parsing file " + sourceName, sx);
            if (type.error == null) {
                type.error = e.getMessage();
                if (type.error == null) {
                    type.error = e.toString();
                }
                if ("global".equals(type.frameworkProto.getLowerCaseName())) {
                    this.globalError = type.error;
                }
                this.wrappercache.clear();
            }
        }
        finally {
            this.app.setCurrentCodeResource(previousCurrentResource);
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public Scriptable getScope() {
        return this.global;
    }

    class HelmaContextFactory
    extends ContextFactory {
        final boolean strictVars;

        HelmaContextFactory() {
            this.strictVars = "true".equalsIgnoreCase(RhinoCore.this.app.getProperty("strictVars"));
        }

        protected void onContextCreated(Context cx) {
            cx.setWrapFactory(RhinoCore.this.wrapper);
            cx.setOptimizationLevel(RhinoCore.this.optLevel);
            if (RhinoCore.this.hasDebugger) {
                RhinoCore.this.initDebugger(cx);
            }
            super.onContextCreated(cx);
        }

        protected boolean hasFeature(Context cx, int featureIndex) {
            switch (featureIndex) {
                case 7: {
                    return true;
                }
                case 8: {
                    return this.strictVars;
                }
            }
            return super.hasFeature(cx, featureIndex);
        }
    }

    class NumberFormat
    extends BaseFunction {
        NumberFormat() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            DecimalFormat df = args.length > 0 && args[0] != Undefined.instance ? new DecimalFormat(args[0].toString()) : new DecimalFormat("#,##0.00");
            return df.format(ScriptRuntime.toNumber((Object)thisObj));
        }
    }

    class DateFormat
    extends BaseFunction {
        DateFormat() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            SimpleDateFormat df;
            Date date = new Date((long)ScriptRuntime.toNumber((Object)thisObj));
            if (args.length > 0 && args[0] != Undefined.instance && args[0] != null) {
                if (args.length > 1 && args[1] instanceof NativeJavaObject) {
                    Object locale = ((NativeJavaObject)args[1]).unwrap();
                    if (!(locale instanceof Locale)) throw new IllegalArgumentException("Second argument to Date.format() not a java.util.Locale: " + locale.getClass());
                    df = new SimpleDateFormat(args[0].toString(), (Locale)locale);
                    return df.format(date);
                } else {
                    df = new SimpleDateFormat(args[0].toString());
                }
                return df.format(date);
            } else {
                df = new SimpleDateFormat();
            }
            return df.format(date);
        }
    }

    class StringTrim
    extends BaseFunction {
        StringTrim() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            String str = thisObj.toString();
            return str.trim();
        }
    }

    class WrapMaker
    extends WrapFactory {
        WrapMaker() {
        }

        public Object wrap(Context cx, Scriptable scope, Object obj, Class staticType) {
            if (obj == null || obj == Undefined.instance || obj instanceof Scriptable || obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
                return obj;
            }
            if (obj instanceof INode) {
                return RhinoCore.this.getNodeWrapper((INode)obj);
            }
            if (obj instanceof SystemMap || obj instanceof WrappedMap) {
                return new MapWrapper((Map)obj, RhinoCore.this);
            }
            if (obj instanceof Date) {
                Object[] args = new Object[]{new Long(((Date)obj).getTime())};
                try {
                    return cx.newObject((Scriptable)RhinoCore.this.global, "Date", args);
                }
                catch (JavaScriptException nafx) {
                    return obj;
                }
            }
            if (obj != null && RhinoCore.this.app.getPrototypeName(obj) != null) {
                return RhinoCore.this.getElementWrapper(obj);
            }
            return super.wrap(cx, scope, obj, staticType);
        }

        public Scriptable wrapNewObject(Context cx, Scriptable scope, Object obj) {
            if (obj instanceof Scriptable) {
                return (Scriptable)obj;
            }
            if (obj instanceof INode) {
                return RhinoCore.this.getNodeWrapper((INode)obj);
            }
            if (obj != null && RhinoCore.this.app.getPrototypeName(obj) != null) {
                return RhinoCore.this.getElementWrapper(obj);
            }
            return super.wrapNewObject(cx, scope, obj);
        }
    }

    class TypeInfo {
        Prototype frameworkProto;
        ScriptableObject objProto;
        long lastUpdate = -1L;
        TypeInfo parentType;
        Set compiledProperties;
        final Set predefinedProperties;
        String error;

        public TypeInfo(Prototype proto, ScriptableObject op) {
            this.frameworkProto = proto;
            this.objProto = op;
            this.compiledProperties = new HashSet();
            this.predefinedProperties = new HashSet();
            Object[] keys = op.getAllIds();
            for (int i = 0; i < keys.length; ++i) {
                this.predefinedProperties.add(keys[i].toString());
            }
        }

        public void prepareCompilation() {
            if (this.objProto instanceof PropertyRecorder) {
                ((PropertyRecorder)this.objProto).startRecording();
            }
            this.lastUpdate = this.frameworkProto.lastCodeUpdate();
        }

        public void commitCompilation() {
            if (this.objProto instanceof PropertyRecorder) {
                PropertyRecorder recorder = (PropertyRecorder)this.objProto;
                recorder.stopRecording();
                Set changedProperties = recorder.getChangeSet();
                recorder.clearChangeSet();
                changedProperties.removeAll(this.predefinedProperties);
                this.compiledProperties.removeAll(changedProperties);
                boolean isGlobal = "global".equals(this.frameworkProto.getLowerCaseName());
                Iterator it = this.compiledProperties.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (isGlobal && (RhinoCore.this.prototypes.containsKey(key.toLowerCase()) || "JavaPackage".equals(key))) {
                        this.predefinedProperties.add(key);
                        continue;
                    }
                    try {
                        this.objProto.setAttributes(key, 0);
                        this.objProto.delete(key);
                    }
                    catch (Exception px) {
                        RhinoCore.this.app.logEvent("Error unsetting property " + key + " on " + this.frameworkProto.getName());
                    }
                }
                this.compiledProperties = changedProperties;
            }
            Context cx = Context.getCurrentContext();
            try {
                Object fObj = ScriptableObject.getProperty((Scriptable)this.objProto, (String)"onCodeUpdate");
                if (fObj instanceof Function) {
                    Object[] args = new Object[]{this.frameworkProto.getName()};
                    ((Function)fObj).call(cx, (Scriptable)RhinoCore.this.global, (Scriptable)this.objProto, args);
                }
            }
            catch (Exception x) {
                RhinoCore.this.app.logError("Exception in " + this.frameworkProto.getName() + ".onCodeUpdate(): " + x, x);
            }
        }

        public boolean needsUpdate() {
            return this.frameworkProto.lastCodeUpdate() > this.lastUpdate;
        }

        public void setParentType(TypeInfo type) {
            this.parentType = type;
            if (type == null) {
                this.objProto.setPrototype(null);
            } else {
                this.objProto.setPrototype((Scriptable)type.objProto);
            }
        }

        public TypeInfo getParentType() {
            return this.parentType;
        }

        public boolean hasError() {
            TypeInfo p = this;
            while (p != null) {
                if (p.error != null) {
                    return true;
                }
                p = p.parentType;
            }
            return false;
        }

        public String getError() {
            TypeInfo p = this;
            while (p != null) {
                if (p.error != null) {
                    return p.error;
                }
                p = p.parentType;
            }
            return null;
        }

        public String toString() {
            return "TypeInfo[" + this.frameworkProto + "," + new Date(this.lastUpdate) + "]";
        }
    }
}

