/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino;

import helma.scripting.rhino.RhinoCore;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class MapWrapper
extends ScriptableObject
implements Wrapper {
    Map map;
    RhinoCore core;

    public MapWrapper() {
        this.map = null;
    }

    public MapWrapper(Map map, RhinoCore core) {
        this.map = map;
        this.core = core;
        this.setParentScope((Scriptable)core.global);
        this.setPrototype(ScriptableObject.getObjectPrototype((Scriptable)core.global));
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        if (value == null || value == Undefined.instance) {
            this.map.remove(name);
        } else if (value instanceof Wrapper) {
            this.map.put(name, ((Wrapper)value).unwrap());
        } else {
            this.map.put(name, value);
        }
    }

    public Object get(String name, Scriptable start) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(name);
        if (obj != null && !(obj instanceof Scriptable)) {
            if (obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
                return obj;
            }
            return Context.toObject(obj, (Scriptable)this.core.global);
        }
        return obj;
    }

    public boolean has(String name, Scriptable start) {
        return this.map != null && this.map.containsKey(name);
    }

    public void delete(String name) {
        if (this.map != null) {
            this.map.remove(name);
        }
    }

    public void put(int idx, Scriptable start, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        if (value == null || value == Undefined.instance) {
            this.map.remove(Integer.toString(idx));
        } else if (value instanceof Wrapper) {
            this.map.put(Integer.toString(idx), ((Wrapper)value).unwrap());
        } else {
            this.map.put(Integer.toString(idx), value);
        }
    }

    public Object get(int idx, Scriptable start) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(Integer.toString(idx));
        if (obj != null && !(obj instanceof Scriptable)) {
            if (obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
                return obj;
            }
            return Context.toObject(obj, (Scriptable)this.core.global);
        }
        return obj;
    }

    public boolean has(int idx, Scriptable start) {
        return this.map != null && this.map.containsKey(Integer.toString(idx));
    }

    public void delete(int idx) {
        if (this.map != null) {
            this.map.remove(Integer.toString(idx));
        }
    }

    public Object[] getIds() {
        if (this.map == null) {
            return new Object[0];
        }
        return this.map.keySet().toArray();
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || hint == String.class) {
            return this.map == null ? "{}" : this.map.toString();
        }
        return super.getDefaultValue(hint);
    }

    public Object unwrap() {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map;
    }

    public String getClassName() {
        return "[MapWrapper]";
    }

    public String toString() {
        if (this.map == null) {
            return "[MapWrapper{}]";
        }
        return "[MapWrapper" + this.map.toString() + "]";
    }
}

