/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino;

import helma.objectmodel.INode;
import helma.objectmodel.db.Key;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeHandle;
import helma.objectmodel.db.OrderedSubnodeList;
import helma.objectmodel.db.WrappedNodeManager;
import helma.scripting.rhino.HopObject;
import helma.scripting.rhino.RhinoCore;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class ListViewWrapper
extends ScriptableObject
implements Wrapper,
Scriptable {
    final List list;
    final RhinoCore core;
    final WrappedNodeManager wnm;
    final HopObject hObj;
    INode node;
    static ListViewWrapper listViewProto;

    private ListViewWrapper() {
        this.list = null;
        this.core = null;
        this.wnm = null;
        this.node = null;
        this.hObj = null;
    }

    ListViewWrapper(List list, RhinoCore core, WrappedNodeManager wnm, HopObject hObj) {
        if (list == null) {
            throw new IllegalArgumentException("ListWrapper unable to wrap null list.");
        }
        this.core = core;
        this.list = list;
        this.wnm = wnm;
        this.hObj = hObj;
        this.node = hObj.node;
        if (listViewProto == null) {
            listViewProto = new ListViewWrapper();
            listViewProto.init();
        }
        this.setPrototype(listViewProto);
    }

    void init() {
        int attributes = 7;
        Method[] methods = ((Object)((Object)this)).getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!methodName.startsWith("jsFunction_")) continue;
            methodName = methodName.substring(11);
            FunctionObject func = new FunctionObject(methodName, (Member)methods[i], (Scriptable)this);
            this.defineProperty(methodName, func, attributes);
        }
    }

    public Object unwrap() {
        return this.list;
    }

    public Object jsFunction_get(Object idxObj) {
        if (idxObj instanceof Number) {
            return this.jsFunction_get(((Number)idxObj).intValue());
        }
        return this.hObj.jsFunction_get(idxObj);
    }

    public Object jsFunction_get(int idx) {
        if (this.list.size() <= idx) {
            return null;
        }
        Object obj = this.list.get(idx);
        if (obj == null) {
            return null;
        }
        if (obj instanceof NodeHandle) {
            return Context.toObject((Object)((NodeHandle)obj).getNode(this.wnm), (Scriptable)this.core.global);
        }
        if (!(obj instanceof Scriptable)) {
            if (obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
                return obj;
            }
            return Context.toObject(obj, (Scriptable)this.core.global);
        }
        return obj;
    }

    public Object jsFunction_getById(Object id) {
        return this.hObj.jsFunction_getById(id);
    }

    public void jsFunction_prefetchChildren(Object startArg, Object lengthArg) throws Exception {
        if (startArg == Undefined.instance && lengthArg == Undefined.instance) {
            this.prefetchChildren(0, 1000);
        } else {
            int start = (int)ScriptRuntime.toNumber((Object)startArg);
            int length = (int)ScriptRuntime.toNumber((Object)lengthArg);
            this.prefetchChildren(start, length);
        }
    }

    private void prefetchChildren(int start, int length) {
        if (!(this.node instanceof Node)) {
            return;
        }
        this.checkNode();
        start = Math.max(start, 0);
        length = Math.min(this.list.size() - start, length);
        if (length < 1) {
            return;
        }
        Key[] keys = new Key[length];
        for (int i = start; i < start + length; ++i) {
            keys[i - start] = ((NodeHandle)this.list.get(i)).getKey();
        }
        try {
            ((Node)this.node).prefetchChildren(keys);
        }
        catch (Exception x) {
            System.err.println("Error in HopObject.prefetchChildren(): " + x);
        }
    }

    public int jsFunction_size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public int jsFunction_count() {
        return this.jsFunction_size();
    }

    public void jsFunction_add(Object child) {
        if (this.hObj == null) {
            throw new RuntimeException("ListWrapper has no knowledge about any HopObject or collection");
        }
        this.hObj.jsFunction_add(child);
    }

    private Scriptable list() {
        this.checkNode();
        ArrayList<Scriptable> a = new ArrayList<Scriptable>();
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            NodeHandle nh = (NodeHandle)i.next();
            if (nh == null) continue;
            a.add(Context.toObject((Object)nh.getNode(this.wnm), (Scriptable)this.core.global));
        }
        return Context.getCurrentContext().newArray((Scriptable)this.core.global, a.toArray());
    }

    public Scriptable jsFunction_list(Object startArg, Object lengthArg) {
        if (startArg == Undefined.instance && lengthArg == Undefined.instance) {
            return this.list();
        }
        int start = (int)ScriptRuntime.toNumber((Object)startArg);
        int length = (int)ScriptRuntime.toNumber((Object)lengthArg);
        if (start < 0 || length < 0) {
            throw new EvaluatorException("Arguments must not be negative in HopObject.list(start, length)");
        }
        this.checkNode();
        start = Math.max(start, 0);
        length = Math.min(this.list.size() - start, length);
        this.prefetchChildren(start, length);
        ArrayList<Scriptable> a = new ArrayList<Scriptable>();
        for (int i = start; i < start + length; ++i) {
            NodeHandle nh = (NodeHandle)this.list.get(i);
            if (nh == null) continue;
            a.add(Context.toObject((Object)nh.getNode(this.wnm), (Scriptable)this.core.global));
        }
        return Context.getCurrentContext().newArray((Scriptable)this.core.global, a.toArray());
    }

    public boolean jsFunction_remove(Object arg) {
        if (this.hObj == null) {
            throw new RuntimeException("ListWrapper has no knowledge about any HopObject or collection");
        }
        return this.hObj.jsFunction_remove(arg);
    }

    public boolean jsFunction_removeChild(Object child) {
        if (this.hObj == null) {
            throw new RuntimeException("ListWrapper has no knowledge about any HopObject or collection");
        }
        return this.hObj.jsFunction_removeChild(child);
    }

    public boolean jsFunction_invalidate(Object childId) {
        if (this.hObj == null) {
            throw new RuntimeException("ListWrapper has no knowledge about any HopObject or collection");
        }
        return this.hObj.jsFunction_invalidate(childId);
    }

    public int jsFunction_contains(Object obj) {
        INode n;
        if (obj instanceof HopObject && (n = ((HopObject)obj).node) instanceof Node) {
            return this.list.indexOf(((Node)n).getHandle());
        }
        return -1;
    }

    public int jsFunction_update() {
        if (!(this.node instanceof Node)) {
            throw new RuntimeException("updateSubnodes only callabel on persistent HopObjects");
        }
        this.checkNode();
        Node n = (Node)this.node;
        return n.updateSubnodes();
    }

    public Object jsFunction_getOrderedView(String expr) {
        if (!(this.list instanceof OrderedSubnodeList)) {
            throw new RuntimeException("getOrderedView only callable on persistent HopObjects");
        }
        this.checkNode();
        OrderedSubnodeList osl = (OrderedSubnodeList)this.list;
        return new ListViewWrapper(osl.getOrderedView(expr), this.core, this.wnm, this.hObj);
    }

    public String toString() {
        if (this.list == null) {
            return "[ListWrapper{}]";
        }
        return "[ListWrapper" + this.list.toString() + "]";
    }

    private final void checkNode() {
        if (this.node != null && this.node.getState() == -1 && this.node instanceof Node) {
            NodeHandle handle = ((Node)this.node).getHandle();
            this.node = handle.getNode(this.core.app.getWrappedNodeManager());
        }
    }

    public String getClassName() {
        return "[ListWrapper]";
    }
}

