/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino;

import helma.framework.core.Prototype;
import helma.framework.core.Skin;
import helma.framework.repository.Resource;
import helma.scripting.rhino.RhinoCore;
import helma.scripting.rhino.RhinoEngine;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class JavaObject
extends NativeJavaObject {
    RhinoCore core;
    String protoName;
    NativeJavaObject unscriptedJavaObj;
    static HashMap overload = new HashMap();

    public JavaObject(Scriptable scope, Object obj, String protoName, Scriptable prototype, RhinoCore core) {
        this.parent = scope;
        this.javaObject = obj;
        this.protoName = protoName;
        this.core = core;
        this.staticType = obj.getClass();
        this.unscriptedJavaObj = new NativeJavaObject(scope, obj, this.staticType);
        this.setPrototype(prototype);
        this.initMembers();
    }

    public boolean renderSkin(Object skinobj, Object paramobj) throws UnsupportedEncodingException, IOException {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        Skin skin = engine.toSkin(skinobj, this.protoName);
        if (skin != null) {
            skin.render(engine.reval, this.javaObject, paramobj == Undefined.instance ? null : paramobj);
        }
        return true;
    }

    public String renderSkinAsString(Object skinobj, Object paramobj) throws UnsupportedEncodingException, IOException {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        Skin skin = engine.toSkin(skinobj, this.protoName);
        if (skin != null) {
            return skin.renderAsString(engine.reval, this.javaObject, paramobj == Undefined.instance ? null : paramobj);
        }
        return "";
    }

    public Object href(Object action) throws UnsupportedEncodingException, IOException {
        if (this.javaObject == null) {
            return null;
        }
        String act = null;
        if (action != null) {
            if (action instanceof Wrapper) {
                act = ((Wrapper)action).unwrap().toString();
            } else if (!(action instanceof Undefined)) {
                act = action.toString();
            }
        }
        String basicHref = this.core.app.getNodeHref(this.javaObject, act);
        return this.core.postProcessHref(this.javaObject, this.protoName, basicHref);
    }

    public boolean has(String name, Scriptable start) {
        return overload.containsKey(name) || super.has(name, start);
    }

    public Object get(String name, Scriptable start) {
        Object value;
        for (Scriptable proto = this.getPrototype(); proto != null; proto = proto.getPrototype()) {
            value = proto.get(name, start);
            if (value == NOT_FOUND || value instanceof FunctionObject) continue;
            return value;
        }
        value = overload.get(name);
        if (value != null) {
            return new FunctionObject(name, (Member)((Method)value), (Scriptable)this);
        }
        if ("_prototype".equals(name) || "__prototype__".equals(name)) {
            return this.protoName;
        }
        if ("__proto__".equals(name)) {
            return this.getPrototype();
        }
        if ("__javaObject__".equals(name)) {
            return this.unscriptedJavaObj;
        }
        return super.get(name, start);
    }

    public Object getResource(String resourceName) {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        for (Prototype prototype = engine.core.app.getPrototypeByName(this.protoName); prototype != null; prototype = prototype.getParentPrototype()) {
            Resource[] resources = prototype.getResources();
            for (int i = resources.length - 1; i >= 0; --i) {
                Resource resource = resources[i];
                if (!resource.exists() || !resource.getShortName().equals(resourceName)) continue;
                return Context.toObject((Object)resource, (Scriptable)this.core.global);
            }
        }
        return null;
    }

    public Object getResources(String resourceName) {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        ArrayList<Scriptable> a = new ArrayList<Scriptable>();
        for (Prototype prototype = engine.core.app.getPrototypeByName(this.protoName); prototype != null; prototype = prototype.getParentPrototype()) {
            Resource[] resources = prototype.getResources();
            for (int i = resources.length - 1; i >= 0; --i) {
                Resource resource = resources[i];
                if (!resource.exists() || !resource.getShortName().equals(resourceName)) continue;
                a.add(Context.toObject((Object)resource, (Scriptable)this.core.global));
            }
        }
        return Context.getCurrentContext().newArray((Scriptable)this.core.global, a.toArray());
    }

    static {
        Method[] m = JavaObject.class.getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!"href".equals(m[i].getName()) && !"renderSkin".equals(m[i].getName()) && !"renderSkinAsString".equals(m[i].getName()) && !"getResource".equals(m[i].getName()) && !"getResources".equals(m[i].getName())) continue;
            overload.put(m[i].getName(), m[i]);
        }
    }
}

