/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino;

import [Ljava.lang.Object;;
import helma.objectmodel.db.DbKey;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Node;
import helma.scripting.rhino.HopObject;
import helma.scripting.rhino.RhinoCore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class HopObjectCtor
extends FunctionObject {
    boolean initialized;
    RhinoCore core;
    static Method hopObjCtor;
    static final int attr = 7;

    public HopObjectCtor(String protoName, RhinoCore core, Scriptable prototype) {
        super(protoName, (Member)hopObjCtor, (Scriptable)core.global);
        this.core = core;
        this.addAsConstructor((Scriptable)core.global, prototype);
        this.defineProperty("getById", (Object)new GetById(), 7);
    }

    public static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws JavaScriptException {
        HopObjectCtor ctor = (HopObjectCtor)ctorObj;
        RhinoCore core = ctor.core;
        String protoname = ctor.getFunctionName();
        if (core.app.isJavaPrototype(protoname)) {
            String classname = core.app.getJavaClassForPrototype(protoname);
            try {
                Class<?> clazz = Class.forName(classname);
                Class[] argsTypes = new Class[args.length];
                for (int i = 0; i < argsTypes.length; ++i) {
                    argsTypes[i] = args[i] == null ? null : args[i].getClass();
                }
                Constructor<?> cnst = clazz.getConstructor(argsTypes);
                Object obj = cnst.newInstance(args);
                return Context.toObject(obj, (Scriptable)core.global);
            }
            catch (Exception x) {
                System.err.println("Error in Java constructor: " + x);
                throw new EvaluatorException(x.toString());
            }
        }
        Node node = new Node(protoname, protoname, core.app.getWrappedNodeManager());
        Scriptable proto = core.getPrototype(protoname);
        HopObject hobj = new HopObject(protoname, core, node, proto);
        if (proto != null) {
            Object f = ScriptableObject.getProperty((Scriptable)proto, (String)protoname);
            if (!(f instanceof Function)) {
                f = ScriptableObject.getProperty((Scriptable)proto, (String)"__constructor__");
            }
            if (f instanceof Function) {
                ((Function)f).call(cx, (Scriptable)core.global, (Scriptable)hobj, args);
            }
        }
        return hobj;
    }

    public Object get(String name, Scriptable start) {
        if (!this.initialized && this.core.isInitialized()) {
            this.initialized = true;
            this.core.getPrototype(this.getFunctionName());
        }
        return super.get(name, start);
    }

    public void put(String name, Scriptable start, Object value) {
        if (value instanceof Function) {
            ((Function)value).setParentScope((Scriptable)this.core.global);
        }
        super.put(name, start, value);
    }

    static {
        try {
            hopObjCtor = HopObjectCtor.class.getMethod("jsConstructor", Context.class, Object;.class, Function.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error getting HopObjectCtor.jsConstructor()");
        }
    }

    class GetById
    extends BaseFunction {
        GetById() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args.length < 1 || args.length > 2) {
                throw new IllegalArgumentException("Wrong number of arguments in getById()");
            }
            String type = args.length == 1 ? HopObjectCtor.this.getFunctionName() : Context.toString((Object)args[1]);
            DbMapping dbmap = HopObjectCtor.this.core.app.getDbMapping(type);
            if (dbmap == null) {
                return null;
            }
            Node node = null;
            try {
                DbKey key = new DbKey(dbmap, Context.toString((Object)args[0]));
                node = HopObjectCtor.this.core.app.getNodeManager().getNode(key);
            }
            catch (Exception x) {
                return null;
            }
            return node == null ? null : Context.toObject((Object)node, (Scriptable)this);
        }
    }
}

