/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino;

import helma.framework.IPathElement;
import helma.framework.core.Prototype;
import helma.framework.core.Skin;
import helma.framework.repository.Resource;
import helma.objectmodel.INode;
import helma.objectmodel.IProperty;
import helma.objectmodel.TransientNode;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeHandle;
import helma.objectmodel.db.SubnodeList;
import helma.scripting.rhino.ListViewWrapper;
import helma.scripting.rhino.PropertyRecorder;
import helma.scripting.rhino.RhinoCore;
import helma.scripting.rhino.RhinoEngine;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class HopObject
extends ScriptableObject
implements Wrapper,
PropertyRecorder {
    String className;
    INode node;
    RhinoCore core;
    private boolean isRecording = false;
    private HashSet changedProperties;

    protected HopObject(String className, RhinoCore core) {
        this.className = className;
        this.core = core;
        this.setParentScope((Scriptable)core.global);
    }

    protected HopObject(String className, RhinoCore core, INode node, Scriptable proto) {
        this(className, core);
        this.node = node;
        this.setPrototype(proto);
        this.setParentScope((Scriptable)core.global);
    }

    public static HopObject init(RhinoCore core) {
        int attributes = 6;
        HopObject proto = new HopObject("HopObject", core);
        proto.setPrototype(HopObject.getObjectPrototype((Scriptable)core.global));
        Method[] methods = HopObject.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (methodName.startsWith("jsFunction_")) {
                methodName = methodName.substring(11);
                FunctionObject func = new FunctionObject(methodName, (Member)methods[i], (Scriptable)proto);
                proto.defineProperty(methodName, func, attributes);
                continue;
            }
            if (!methodName.startsWith("jsGet_")) continue;
            methodName = methodName.substring(6);
            proto.defineProperty(methodName, null, methods[i], null, attributes);
        }
        return proto;
    }

    public String getClassName() {
        return this.className;
    }

    public Object getDefaultValue(Class hint) {
        return this.node == null ? this.toString() : this.node.toString();
    }

    public INode getNode() {
        if (this.node != null) {
            this.checkNode();
        }
        return this.node;
    }

    public Object unwrap() {
        if (this.node != null) {
            this.checkNode();
            return this.node;
        }
        return this;
    }

    private void checkNode() {
        if (this.node != null && this.node.getState() == -1 && this.node instanceof Node) {
            NodeHandle handle = ((Node)this.node).getHandle();
            this.node = handle.getNode(this.core.app.getWrappedNodeManager());
            if (this.node == null) {
                this.node = new TransientNode();
            }
        }
    }

    public Object jsGet_cache() {
        if (this.node == null) {
            return null;
        }
        this.checkNode();
        INode cache = this.node.getCacheNode();
        if (cache != null) {
            return Context.toObject((Object)this.node.getCacheNode(), (Scriptable)this.core.global);
        }
        return null;
    }

    public boolean jsFunction_renderSkin(Object skinobj, Object paramobj) throws UnsupportedEncodingException, IOException {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        Skin skin = engine.toSkin(skinobj, this.className);
        this.checkNode();
        if (skin != null) {
            skin.render(engine.reval, this.node, paramobj == Undefined.instance ? null : paramobj);
        }
        return true;
    }

    public Object jsFunction_getResource(String resourceName) {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        for (Prototype prototype = engine.app.getPrototypeByName(this.className); prototype != null; prototype = prototype.getParentPrototype()) {
            Resource[] resources = prototype.getResources();
            for (int i = resources.length - 1; i >= 0; --i) {
                Resource resource = resources[i];
                if (!resource.exists() || !resource.getShortName().equals(resourceName)) continue;
                return Context.toObject((Object)resource, (Scriptable)this.core.global);
            }
        }
        return null;
    }

    public Object jsFunction_getResources(String resourceName) {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        ArrayList<Scriptable> a = new ArrayList<Scriptable>();
        for (Prototype prototype = engine.core.app.getPrototypeByName(this.className); prototype != null; prototype = prototype.getParentPrototype()) {
            Resource[] resources = prototype.getResources();
            for (int i = resources.length - 1; i >= 0; --i) {
                Resource resource = resources[i];
                if (!resource.exists() || !resource.getShortName().equals(resourceName)) continue;
                a.add(Context.toObject((Object)resource, (Scriptable)this.core.global));
            }
        }
        return Context.getCurrentContext().newArray((Scriptable)this.core.global, a.toArray());
    }

    public String jsFunction_renderSkinAsString(Object skinobj, Object paramobj) throws UnsupportedEncodingException, IOException {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        Skin skin = engine.toSkin(skinobj, this.className);
        this.checkNode();
        if (skin != null) {
            return skin.renderAsString(engine.reval, this.node, paramobj == Undefined.instance ? null : paramobj);
        }
        return "";
    }

    public Object jsFunction_href(Object action) throws UnsupportedEncodingException, IOException {
        if (this.node == null) {
            return null;
        }
        String act = null;
        this.checkNode();
        if (action != null) {
            if (action instanceof Wrapper) {
                act = ((Wrapper)action).unwrap().toString();
            } else if (!(action instanceof Undefined)) {
                act = action.toString();
            }
        }
        String basicHref = this.core.app.getNodeHref(this.node, act);
        return this.core.postProcessHref(this.node, this.className, basicHref);
    }

    public Object jsFunction_get(Object id) {
        if (this.node == null || id == null) {
            return null;
        }
        IPathElement n = null;
        this.checkNode();
        n = id instanceof Number ? this.node.getSubnodeAt(((Number)id).intValue()) : this.node.getChildElement(id.toString());
        if (n != null) {
            return Context.toObject((Object)n, (Scriptable)this.core.global);
        }
        return null;
    }

    public Object jsFunction_getById(Object id) {
        if (this.node == null || id == null || id == Undefined.instance) {
            return null;
        }
        this.checkNode();
        String idString = id instanceof Double ? Long.toString(((Double)id).longValue()) : id.toString();
        INode n = this.node.getSubnode(idString);
        if (n == null) {
            return null;
        }
        return Context.toObject((Object)n, (Scriptable)this.core.global);
    }

    public boolean jsFunction_set(Object id, Object value) {
        if (id == Undefined.instance || value == Undefined.instance) {
            throw new EvaluatorException("HopObject.set() called with wrong number of arguments");
        }
        if (this.node == null) {
            return false;
        }
        if (id instanceof Number) {
            if (!(value instanceof HopObject)) {
                throw new EvaluatorException("Can only set HopObjects as child objects in HopObject.set()");
            }
            this.checkNode();
            int idx = ((Number)id).intValue();
            INode n = ((HopObject)value).getNode();
            this.node.addNode(n, idx);
        } else if (id != null) {
            this.put(id.toString(), (Scriptable)this, value);
        }
        return true;
    }

    public int jsFunction_count() {
        if (this.node == null) {
            return 0;
        }
        this.checkNode();
        return this.node.numberOfNodes();
    }

    public int jsFunction_size() {
        return this.jsFunction_count();
    }

    public void jsFunction_prefetchChildren(Object startArg, Object lengthArg) {
        if (startArg == Undefined.instance && lengthArg == Undefined.instance) {
            this.prefetchChildren(0, 1000);
        } else {
            int start = (int)ScriptRuntime.toNumber((Object)startArg);
            int length = (int)ScriptRuntime.toNumber((Object)lengthArg);
            this.prefetchChildren(start, length);
        }
    }

    private void prefetchChildren(int start, int length) {
        if (!(this.node instanceof Node)) {
            return;
        }
        this.checkNode();
        try {
            ((Node)this.node).prefetchChildren(start, length);
        }
        catch (Exception x) {
            this.core.app.logError("Error in HopObject.prefetchChildren: " + x, x);
        }
    }

    public void jsFunction_clearCache() {
        this.checkNode();
        this.node.clearCacheNode();
    }

    private Scriptable list() {
        this.checkNode();
        Enumeration e = this.node.getSubnodes();
        ArrayList<Scriptable> a = new ArrayList<Scriptable>();
        while (e != null && e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj == null) continue;
            a.add(Context.toObject(obj, (Scriptable)this.core.global));
        }
        return Context.getCurrentContext().newArray((Scriptable)this.core.global, a.toArray());
    }

    public Scriptable jsFunction_list(Object startArg, Object lengthArg) {
        if (startArg == Undefined.instance && lengthArg == Undefined.instance) {
            return this.list();
        }
        int start = (int)ScriptRuntime.toNumber((Object)startArg);
        int length = (int)ScriptRuntime.toNumber((Object)lengthArg);
        if (start < 0 || length < 0) {
            throw new EvaluatorException("Arguments must not be negative in HopObject.list(start, length)");
        }
        this.checkNode();
        this.prefetchChildren(start, length);
        ArrayList<Scriptable> a = new ArrayList<Scriptable>();
        for (int i = start; i < start + length; ++i) {
            INode n = this.node.getSubnodeAt(i);
            if (n == null) continue;
            a.add(Context.toObject((Object)n, (Scriptable)this.core.global));
        }
        return Context.getCurrentContext().newArray((Scriptable)this.core.global, a.toArray());
    }

    public boolean jsFunction_add(Object child) {
        if (this.node == null || child == null) {
            return false;
        }
        this.checkNode();
        if (child instanceof HopObject) {
            this.node.addNode(((HopObject)child).node);
            return true;
        }
        if (child instanceof INode) {
            this.node.addNode((INode)child);
            return true;
        }
        return false;
    }

    public boolean jsFunction_addAt(int index, Object child) {
        if (child == null) {
            return false;
        }
        this.checkNode();
        if (child instanceof HopObject) {
            this.node.addNode(((HopObject)child).node, index);
            return true;
        }
        if (child instanceof INode) {
            this.node.addNode((INode)child, index);
            return true;
        }
        return false;
    }

    public boolean jsFunction_remove(Object arg) {
        if (arg != Undefined.instance) {
            System.err.println(" *************  WARNING  *************************");
            System.err.println(" The version of HopObject.remove(child) you were ");
            System.err.println(" trying to use has been deprecated. Please use ");
            System.err.println("      hopobj.removeChild(child)");
            System.err.println(" to remove a child object from a collection without");
            System.err.println(" deleting it, or ");
            System.err.println("      hopobj.remove()");
            System.err.println(" without argument to delete the object itself.");
            System.err.println(" *************************************************");
            throw new RuntimeException("Caught deprecated usage of HopObject.remove(child)");
        }
        this.checkNode();
        return this.node.remove();
    }

    public boolean jsFunction_removeChild(Object child) {
        this.checkNode();
        if (child instanceof HopObject) {
            HopObject hobj = (HopObject)child;
            if (hobj.node != null) {
                this.node.removeNode(hobj.node);
                return true;
            }
        }
        return false;
    }

    public Object jsFunction_persist() {
        this.checkNode();
        if (this.node instanceof Node) {
            ((Node)this.node).persist();
            return this.node.getID();
        }
        return null;
    }

    public boolean jsFunction_invalidate(Object childId) {
        if (childId != null && this.node instanceof Node) {
            if (childId == Undefined.instance) {
                if (this.node.getState() == -1) {
                    return true;
                }
                ((Node)this.node).invalidate();
            } else {
                this.checkNode();
                ((Node)this.node).invalidateNode(childId.toString());
            }
        }
        return true;
    }

    public int jsFunction_indexOf(Object obj) {
        this.checkNode();
        if (this.node != null && obj instanceof HopObject) {
            this.checkNode();
            return this.node.contains(((HopObject)obj).node);
        }
        return -1;
    }

    public int jsFunction_contains(Object obj) {
        return this.jsFunction_indexOf(obj);
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.node == null) {
            if ("constructor".equals(name) && value instanceof NativeFunction) {
                name = "__constructor__";
            }
            if (this.isRecording) {
                Function f;
                this.changedProperties.add(name);
                if (value instanceof Function && (f = (Function)value).getParentScope() == this) {
                    f.setParentScope((Scriptable)this.core.global);
                }
            }
            super.put(name, start, value);
        } else {
            this.checkNode();
            if ("subnodeRelation".equals(name)) {
                this.node.setSubnodeRelation(value == null ? null : value.toString());
            }
            if (value instanceof Wrapper) {
                value = ((Wrapper)value).unwrap();
            }
            if (value == null || value == Undefined.instance) {
                this.node.unset(name);
            } else if (value instanceof Scriptable) {
                Scriptable s = (Scriptable)value;
                String className = s.getClassName();
                if ("Date".equals(className)) {
                    this.node.setDate(name, new Date((long)ScriptRuntime.toNumber((Object)s)));
                } else if ("String".equals(className)) {
                    this.node.setString(name, ScriptRuntime.toString((Object)s));
                } else if ("Number".equals(className)) {
                    this.node.setFloat(name, ScriptRuntime.toNumber((Object)s));
                } else if ("Boolean".equals(className)) {
                    this.node.setBoolean(name, ScriptRuntime.toBoolean((Object)s));
                } else {
                    this.node.setJavaObject(name, s);
                }
            } else if (value instanceof String) {
                this.node.setString(name, value.toString());
            } else if (value instanceof Boolean) {
                this.node.setBoolean(name, (Boolean)value);
            } else if (value instanceof Number) {
                this.node.setFloat(name, ((Number)value).doubleValue());
            } else if (value instanceof Date) {
                this.node.setDate(name, (Date)value);
            } else if (value instanceof INode) {
                this.node.setNode(name, (INode)value);
            } else {
                this.node.setJavaObject(name, value);
            }
        }
    }

    public boolean has(String name, Scriptable start) {
        if (this.node != null) {
            this.checkNode();
            return this.node.get(name) != null;
        }
        return super.has(name, start);
    }

    public void delete(String name) {
        if (this.node != null) {
            this.checkNode();
            this.node.unset(name);
        } else {
            super.delete(name);
        }
    }

    public Object get(String name, Scriptable start) {
        if (this.node == null) {
            return super.get(name, start);
        }
        return this.getFromNode(name);
    }

    private Object getFromNode(String name) {
        if (this.node != null && name != null && name.length() > 0) {
            DbMapping dbmap;
            Object value;
            this.checkNode();
            if (name.charAt(0) == '_' && (value = this.getInternalProperty(name)) != NOT_FOUND) {
                return value;
            }
            if ("subnodeRelation".equals(name)) {
                return this.node.getSubnodeRelation();
            }
            IProperty p = this.node.get(name);
            if (p != null) {
                switch (p.getType()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        return p.getValue();
                    }
                }
                Context cx = Context.getCurrentContext();
                if (p.getType() == 3) {
                    Date d = p.getDateValue();
                    if (d == null) {
                        return null;
                    }
                    Object[] args = new Object[]{new Long(d.getTime())};
                    try {
                        return cx.newObject((Scriptable)this.core.global, "Date", args);
                    }
                    catch (JavaScriptException nafx) {
                        return null;
                    }
                }
                if (p.getType() == 6) {
                    INode n = p.getNodeValue();
                    if (n == null) {
                        return null;
                    }
                    return Context.toObject((Object)n, (Scriptable)this.core.global);
                }
                if (p.getType() == 7) {
                    Object obj = p.getJavaObjectValue();
                    if (obj == null) {
                        return null;
                    }
                    return Context.toObject((Object)obj, (Scriptable)this.core.global);
                }
            }
            if ((dbmap = this.node.getDbMapping()) != null && dbmap.propertyToRelation(name) != null) {
                return null;
            }
        }
        return NOT_FOUND;
    }

    private Object getInternalProperty(String name) {
        if ("__id__".equals(name) || "_id".equals(name)) {
            return this.node.getID();
        }
        if ("__proto__".equals(name)) {
            return this.getPrototype();
        }
        if ("__prototype__".equals(name) || "_prototype".equals(name)) {
            return this.node.getPrototype();
        }
        if ("__parent__".equals(name) || "_parent".equals(name)) {
            return this.core.getNodeWrapper(this.node.getParent());
        }
        if ("__name__".equals(name)) {
            return this.node.getName();
        }
        if ("__fullname__".equals(name)) {
            return this.node.getFullName();
        }
        if ("__hash__".equals(name)) {
            return Integer.toString(this.node.hashCode());
        }
        if ("__node__".equals(name)) {
            return new NativeJavaObject((Scriptable)this.core.global, (Object)this.node, null);
        }
        if ("__created__".equalsIgnoreCase(name)) {
            return new Date(this.node.created());
        }
        if ("__lastmodified__".equalsIgnoreCase(name)) {
            return new Date(this.node.lastModified());
        }
        return NOT_FOUND;
    }

    public Object[] getIds() {
        if (this.node == null) {
            return new Object[0];
        }
        this.checkNode();
        Enumeration en = this.node.properties();
        ArrayList list = new ArrayList();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list.toArray();
    }

    public boolean has(int idx, Scriptable start) {
        if (this.node != null) {
            this.checkNode();
            return 0 <= idx && idx < this.node.numberOfNodes();
        }
        return false;
    }

    public Object get(int idx, Scriptable start) {
        if (this.node != null) {
            this.checkNode();
            INode n = this.node.getSubnodeAt(idx);
            if (n != null) {
                return Context.toObject((Object)n, (Scriptable)this.core.global);
            }
        }
        return NOT_FOUND;
    }

    public String toString() {
        if (this.node == null) {
            return "[HopObject prototype " + this.className + "]";
        }
        return "[HopObject " + this.node.getName() + "]";
    }

    public void startRecording() {
        this.changedProperties = new HashSet();
        this.isRecording = true;
    }

    public void stopRecording() {
        this.isRecording = false;
    }

    public Set getChangeSet() {
        return this.changedProperties;
    }

    public void clearChangeSet() {
        this.changedProperties = null;
    }

    public int jsFunction_update() {
        if (!(this.node instanceof Node)) {
            throw new RuntimeException("update only callabel on persistent HopObjects");
        }
        this.checkNode();
        Node n = (Node)this.node;
        return n.updateSubnodes();
    }

    public Object jsFunction_getOrderedView(String expr) {
        if (!(this.node instanceof Node)) {
            throw new RuntimeException("getOrderedView only callable on persistent HopObjects");
        }
        Node n = (Node)this.node;
        n.loadNodes();
        SubnodeList subnodes = n.getSubnodeList();
        if (subnodes == null) {
            throw new RuntimeException("getOrderedView only callable on already existing subnode-collections");
        }
        return new ListViewWrapper(subnodes.getOrderedView(expr), this.core, this.core.app.getWrappedNodeManager(), this);
    }
}

