/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino;

import helma.framework.repository.Resource;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class HacHspConverter {
    public static String convertHac(Resource action, String encoding) throws IOException {
        String functionName = action.getBaseName().replace('.', '_') + "_action";
        return HacHspConverter.composeFunction(functionName, null, action.getContent(encoding));
    }

    public static String convertHsp(Resource template, String encoding) throws IOException {
        String functionName = template.getBaseName().replace('.', '_');
        String body = HacHspConverter.processHspBody(template.getContent(encoding));
        return HacHspConverter.composeFunction(functionName, "arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10", body);
    }

    public static String convertHspAsString(Resource template, String encoding) throws IOException {
        String functionName = template.getBaseName().replace('.', '_') + "_as_string";
        String body = HacHspConverter.processHspBody(template.getContent(encoding));
        return HacHspConverter.composeFunction(functionName, "arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10", "res.pushStringBuffer(); " + body + "\r\nreturn res.popStringBuffer();\r\n");
    }

    static String composeFunction(String funcname, String args, String body) {
        body = body == null || "".equals(body.trim()) ? ";\r\n" : body + "\r\n";
        StringBuffer f = new StringBuffer("function ");
        f.append(funcname);
        f.append(" (");
        if (args != null) {
            f.append(args);
        }
        f.append(") {\n");
        f.append(body);
        f.append("\n}");
        return f.toString();
    }

    static String processHspBody(String content) {
        ArrayList<HspBodyPart> partBuffer = new ArrayList<HspBodyPart>();
        char[] cnt = content.toCharArray();
        int l = cnt.length;
        if (l == 0) {
            return "";
        }
        if (Character.isWhitespace(cnt[l - 1])) {
            --l;
        }
        int lastIdx = 0;
        for (int i = 0; i < l - 1; ++i) {
            int j;
            if (cnt[i] != '<' || cnt[i + 1] != '%') continue;
            for (j = i + 2; j < l - 1 && (cnt[j] != '%' || cnt[j + 1] != '>'); ++j) {
            }
            if (j > i + 2) {
                if (i - lastIdx > 0) {
                    partBuffer.add(new HspBodyPart(new String(cnt, lastIdx, i - lastIdx), true));
                }
                String script = new String(cnt, i + 2, j - i - 2);
                partBuffer.add(new HspBodyPart(script, false));
                lastIdx = j + 2;
            }
            i = j + 1;
        }
        if (lastIdx < l) {
            partBuffer.add(new HspBodyPart(new String(cnt, lastIdx, l - lastIdx), true));
        }
        StringBuffer templateBody = new StringBuffer();
        int nparts = partBuffer.size();
        for (int k = 0; k < nparts; ++k) {
            HspBodyPart nextPart = (HspBodyPart)partBuffer.get(k);
            if (nextPart.isStatic || nextPart.content.trim().startsWith("=")) {
                StringTokenizer st;
                if (!nextPart.isStatic) {
                    nextPart.content = nextPart.content.trim().substring(1).trim();
                    while (nextPart.content.endsWith(";")) {
                        nextPart.content = nextPart.content.substring(0, nextPart.content.length() - 1);
                    }
                }
                String nextLine = (st = new StringTokenizer(nextPart.content, "\r\n", true)).hasMoreTokens() ? st.nextToken() : null;
                int newLineCount = 0;
                templateBody.append("res.write (");
                if (nextPart.isStatic) {
                    templateBody.append("\"");
                }
                while (nextLine != null) {
                    if ("\n".equals(nextLine)) {
                        ++newLineCount;
                        templateBody.append("\\r\\n");
                    } else if (!"\r".equals(nextLine)) {
                        try {
                            StringReader lineReader = new StringReader(nextLine);
                            int c = lineReader.read();
                            while (c > -1) {
                                if (nextPart.isStatic && ((char)c == '\"' || (char)c == '\\')) {
                                    templateBody.append('\\');
                                }
                                templateBody.append((char)c);
                                c = lineReader.read();
                            }
                        }
                        catch (IOException srx) {
                            // empty catch block
                        }
                    }
                    nextLine = st.hasMoreTokens() ? st.nextToken() : null;
                }
                if (nextPart.isStatic) {
                    templateBody.append("\"");
                }
                templateBody.append("); ");
                for (int i = 0; i < newLineCount; ++i) {
                    templateBody.append("\r\n");
                }
                continue;
            }
            templateBody.append(nextPart.content);
            if (nextPart.content.trim().endsWith(";")) continue;
            templateBody.append(";");
        }
        return templateBody.toString();
    }

    static class HspBodyPart {
        String content;
        boolean isPart = false;
        boolean isStatic;

        public HspBodyPart(String content, boolean isStatic) {
            this.content = content;
            this.isStatic = isStatic;
        }

        public String getName() {
            return this.isStatic ? null : this.content;
        }

        public String toString() {
            return "Template.Part [" + this.content + "," + this.isStatic + "]";
        }
    }
}

