/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting.rhino;

import helma.framework.core.Application;
import helma.framework.core.ApplicationBean;
import helma.framework.core.Skin;
import helma.objectmodel.db.DbSource;
import helma.scripting.rhino.MapWrapper;
import helma.scripting.rhino.PropertyRecorder;
import helma.scripting.rhino.RhinoCore;
import helma.scripting.rhino.RhinoEngine;
import helma.scripting.rhino.extensions.DatabaseObject;
import helma.scripting.rhino.extensions.XmlObject;
import helma.util.HtmlEncoder;
import helma.util.MimePart;
import helma.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.serialize.ScriptableInputStream;
import org.mozilla.javascript.serialize.ScriptableOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.SAXException;

public class GlobalObject
extends ImporterTopLevel
implements PropertyRecorder {
    Application app;
    RhinoCore core;
    boolean isThreadScope = false;
    private volatile boolean isRecording = false;
    private volatile HashSet changedProperties;

    public GlobalObject(RhinoCore core, Application app, boolean isThreadScope) {
        this.core = core;
        this.app = app;
        this.isThreadScope = isThreadScope;
        if (isThreadScope) {
            this.setPrototype((Scriptable)core.global);
            this.setParentScope(null);
        }
    }

    public void init() {
        String[] globalFuncs = new String[]{"renderSkin", "renderSkinAsString", "getProperty", "authenticate", "createSkin", "format", "encode", "encodeXml", "encodeForm", "stripTags", "formatParagraphs", "getXmlDocument", "getHtmlDocument", "seal", "getDBConnection", "getURL", "write", "writeln", "serialize", "deserialize", "defineLibraryScope", "wrapJavaMap", "unwrapJavaMap", "toJava"};
        this.defineFunctionProperties(globalFuncs, GlobalObject.class, 7);
        this.put("app", (Scriptable)this, Context.toObject((Object)new ApplicationBean(this.app), (Scriptable)this));
        this.put("Xml", (Scriptable)this, Context.toObject((Object)new XmlObject(this.core), (Scriptable)this));
        this.put("global", (Scriptable)this, this);
        String[] objFuncs = new String[]{"dontEnum"};
        ScriptableObject objproto = (ScriptableObject)GlobalObject.getObjectPrototype((Scriptable)this);
        objproto.defineFunctionProperties(objFuncs, GlobalObject.class, 7);
    }

    public String getClassName() {
        return "GlobalObject";
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.isRecording) {
            if (this.isThreadScope) {
                this.core.global.put(name, (Scriptable)this.core.global, value);
                return;
            }
            this.changedProperties.add(name);
        }
        super.put(name, start, value);
    }

    public Object get(String name, Scriptable start) {
        if (this.isRecording) {
            this.changedProperties.add(name);
        }
        if (this.isThreadScope && "global".equals(name)) {
            return this;
        }
        return super.get(name, start);
    }

    public boolean renderSkin(Object skinobj, Object paramobj) throws UnsupportedEncodingException, IOException {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        Skin skin = engine.toSkin(skinobj, "global");
        if (skin != null) {
            skin.render(engine.reval, null, paramobj == Undefined.instance ? null : paramobj);
        }
        return true;
    }

    public String renderSkinAsString(Object skinobj, Object paramobj) throws UnsupportedEncodingException, IOException {
        RhinoEngine engine = RhinoEngine.getRhinoEngine();
        Skin skin = engine.toSkin(skinobj, "global");
        if (skin != null) {
            return skin.renderAsString(engine.reval, null, paramobj == Undefined.instance ? null : paramobj);
        }
        return "";
    }

    public String getProperty(String propname, Object defvalue) {
        if (defvalue == Undefined.instance) {
            return this.app.getProperty(propname);
        }
        return this.app.getProperty(propname, GlobalObject.toString(defvalue));
    }

    public boolean authenticate(String user, String pwd) {
        return this.app.authenticate(user, pwd);
    }

    public Object createSkin(String str) {
        return Context.toObject((Object)new Skin(str, this.app), (Scriptable)this);
    }

    public Object getDBConnection(String dbsource) throws Exception {
        if (dbsource == null) {
            throw new EvaluatorException("Wrong number of arguments in getDBConnection(dbsource)");
        }
        DbSource dbsrc = this.app.getDbSource(dbsource);
        if (dbsrc == null) {
            throw new EvaluatorException("DbSource " + dbsource + " does not exist");
        }
        DatabaseObject db = new DatabaseObject(dbsrc);
        return Context.toObject((Object)db, (Scriptable)this);
    }

    public Object getURL(String location, Object opt) {
        if (location == null) {
            return null;
        }
        try {
            String httpUserAgent;
            URL url = new URL(location);
            URLConnection con = url.openConnection();
            if (opt != null && opt != Undefined.instance) {
                if (opt instanceof Scriptable) {
                    Scriptable scr = (Scriptable)opt;
                    if ("Date".equals(scr.getClassName())) {
                        Date date = new Date((long)ScriptRuntime.toNumber((Object)scr));
                        con.setIfModifiedSince(date.getTime());
                        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.UK);
                        format.setTimeZone(TimeZone.getTimeZone("GMT"));
                        con.setRequestProperty("If-Modified-Since", format.format(date));
                    } else {
                        con.setRequestProperty("If-None-Match", scr.toString());
                    }
                } else {
                    con.setRequestProperty("If-None-Match", opt.toString());
                }
            }
            if ((httpUserAgent = this.app.getProperty("httpUserAgent")) != null) {
                con.setRequestProperty("User-Agent", httpUserAgent);
            }
            con.setAllowUserInteraction(false);
            String filename = url.getFile();
            String contentType = con.getContentType();
            long lastmod = con.getLastModified();
            String etag = con.getHeaderField("ETag");
            int length = con.getContentLength();
            int resCode = 0;
            if (con instanceof HttpURLConnection) {
                resCode = ((HttpURLConnection)con).getResponseCode();
            }
            ByteArrayOutputStream body = new ByteArrayOutputStream();
            if (length != 0 && resCode != 304) {
                int read;
                BufferedInputStream in = new BufferedInputStream(con.getInputStream());
                byte[] b = new byte[1024];
                while ((read = ((InputStream)in).read(b)) > -1) {
                    body.write(b, 0, read);
                }
                ((InputStream)in).close();
            }
            MimePart mime = new MimePart(filename, body.toByteArray(), contentType);
            if (lastmod > 0L) {
                mime.setLastModified(new Date(lastmod));
            }
            mime.setETag(etag);
            return Context.toObject((Object)mime, (Scriptable)this);
        }
        catch (Exception x) {
            this.app.logError("Error getting URL " + location, x);
            return null;
        }
    }

    public Object getXmlDocument(Object src) {
        try {
            Object p = src;
            if (p instanceof Wrapper) {
                p = ((Wrapper)p).unwrap();
            }
            Document doc = XmlUtils.parseXml(p);
            return Context.toObject((Object)doc, (Scriptable)this);
        }
        catch (Exception x) {
            this.app.logError("Error creating XML document", x);
            return null;
        }
    }

    public Object getHtmlDocument(Object src) {
        try {
            Object p = src;
            if (p instanceof Wrapper) {
                p = ((Wrapper)p).unwrap();
            }
            HTMLDocument doc = XmlUtils.parseHtml(p);
            return Context.toObject((Object)doc, (Scriptable)this);
        }
        catch (IOException iox) {
            this.app.logError("Error creating HTML document", iox);
        }
        catch (SAXException sx) {
            this.app.logError("Error creating HTML document", sx);
        }
        return null;
    }

    public void defineLibraryScope(final String name) {
        Object obj = this.get(name, (Scriptable)this);
        if (obj != NOT_FOUND) {
            this.put(name, (Scriptable)this, obj);
            return;
        }
        NativeObject scope = new NativeObject(){

            public String getClassName() {
                return name;
            }
        };
        scope.setPrototype(ScriptableObject.getObjectPrototype((Scriptable)this));
        this.put(name, (Scriptable)this, scope);
    }

    public Object wrapJavaMap(Object obj) {
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        if (!(obj instanceof Map)) {
            throw ScriptRuntime.constructError((String)"TypeError", (String)("Invalid argument to wrapMap(): " + obj));
        }
        return new MapWrapper((Map)obj, this.core);
    }

    public Object unwrapJavaMap(Object obj) {
        if (!(obj instanceof MapWrapper)) {
            throw ScriptRuntime.constructError((String)"TypeError", (String)("Invalid argument to unwrapMap(): " + obj));
        }
        obj = ((MapWrapper)((Object)obj)).unwrap();
        return new NativeJavaObject((Scriptable)this.core.global, obj, Map.class);
    }

    public Object toJava(Object obj) {
        String className;
        if (obj == null || obj instanceof NativeJavaObject || obj == Undefined.instance) {
            return obj;
        }
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        } else if (obj instanceof Scriptable && "Date".equals(className = ((Scriptable)obj).getClassName())) {
            return new NativeJavaObject((Scriptable)this, (Object)new Date((long)ScriptRuntime.toNumber((Object)obj)), null);
        }
        return new NativeJavaObject((Scriptable)this, obj, null);
    }

    public String encode(Object obj) {
        return HtmlEncoder.encodeAll(GlobalObject.toString(obj));
    }

    public String encodeXml(Object obj) {
        return HtmlEncoder.encodeXml(GlobalObject.toString(obj));
    }

    public String encodeForm(Object obj) {
        return HtmlEncoder.encodeFormValue(GlobalObject.toString(obj));
    }

    public String format(Object obj) {
        return HtmlEncoder.encode(GlobalObject.toString(obj));
    }

    public String formatParagraphs(Object obj) {
        String str = GlobalObject.toString(obj);
        if (str == null) {
            return null;
        }
        int l = str.length();
        if (l == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(Math.round((float)l * 1.4f));
        HtmlEncoder.encode(str, buffer, true, null);
        return buffer.toString();
    }

    public void write(String str) {
        System.out.print(str);
    }

    public void writeln(String str) {
        System.out.println(str);
    }

    public static void seal(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object arg;
        int i;
        for (i = 0; i != args.length; ++i) {
            arg = args[i];
            if (arg instanceof ScriptableObject && arg != Undefined.instance) continue;
            if (!(arg instanceof Scriptable) || arg == Undefined.instance) {
                throw new EvaluatorException("seal() can only be applied to Objects");
            }
            throw new EvaluatorException("seal() can only be applied to Objects");
        }
        for (i = 0; i != args.length; ++i) {
            arg = args[i];
            ((ScriptableObject)arg).sealObject();
        }
    }

    public String stripTags(String str) {
        int i;
        if (str == null) {
            return null;
        }
        char[] c = str.toCharArray();
        boolean inTag = false;
        int j = 0;
        for (i = 0; i < c.length; ++i) {
            if (c[i] == '<') {
                inTag = true;
            }
            if (!inTag) {
                if (i > j) {
                    c[j] = c[i];
                }
                ++j;
            }
            if (c[i] != '>') continue;
            inTag = false;
        }
        if (i > j) {
            return new String(c, 0, j);
        }
        return str;
    }

    public static void serialize(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        if (args.length < 2) {
            throw Context.reportRuntimeError((String)"Expected an object to serialize and a filename to write the serialization to");
        }
        Object obj = args[0];
        File file = new File(Context.toString((Object)args[1])).getAbsoluteFile();
        FileOutputStream fos = new FileOutputStream(file);
        GlobalObject scope = RhinoCore.getCore().global;
        ScriptableOutputStream out = new ScriptableOutputStream(fos, (Scriptable)scope){

            protected Object replaceObject(Object obj) throws IOException {
                if (obj instanceof Wrapper) {
                    obj = ((Wrapper)obj).unwrap();
                }
                return super.replaceObject(obj);
            }
        };
        out.writeObject(obj);
        out.close();
    }

    public static Object deserialize(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, ClassNotFoundException {
        if (args.length < 1) {
            throw Context.reportRuntimeError((String)"Expected a filename to read the serialization from");
        }
        File file = new File(Context.toString((Object)args[0])).getAbsoluteFile();
        FileInputStream fis = new FileInputStream(file);
        GlobalObject scope = RhinoCore.getCore().global;
        ScriptableInputStream in = new ScriptableInputStream((InputStream)fis, (Scriptable)scope);
        Object deserialized = in.readObject();
        in.close();
        return Context.toObject((Object)deserialized, (Scriptable)scope);
    }

    public static Object dontEnum(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (!(thisObj instanceof ScriptableObject)) {
            throw new EvaluatorException("dontEnum() called on non-ScriptableObject");
        }
        ScriptableObject obj = (ScriptableObject)thisObj;
        for (int i = 0; i < args.length; ++i) {
            int attr;
            if (!(args[i] instanceof String)) {
                throw new EvaluatorException("dontEnum() called with non-String argument");
            }
            String str = (String)args[i];
            if (!obj.has(str, (Scriptable)obj) || ((attr = obj.getAttributes(str)) & 4) != 0) continue;
            obj.setAttributes(str, attr | 2);
        }
        return null;
    }

    private static String toString(Object obj) {
        if (obj == null || obj == Undefined.instance) {
            return null;
        }
        return Context.toString((Object)obj);
    }

    public void startRecording() {
        this.changedProperties = new HashSet();
        this.isRecording = true;
    }

    public void stopRecording() {
        this.isRecording = false;
    }

    public Set getChangeSet() {
        return this.changedProperties;
    }

    public void clearChangeSet() {
        this.changedProperties = null;
    }

    public String toString() {
        return this.isThreadScope ? "[Thread Scope]" : "[Shared Scope]";
    }
}

