/*
 * Decompiled with CFR 0.152.
 */
package helma.scripting;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.mozilla.javascript.RhinoException;

public class ScriptingException
extends Exception {
    String scriptStack = null;

    public ScriptingException(String message, Throwable cause) {
        super(message, cause);
        this.setScriptStack(cause);
    }

    private void setScriptStack(Throwable cause) {
        if (cause instanceof RhinoException) {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".js") || name.endsWith(".hac") || name.endsWith(".hsp");
                }
            };
            this.scriptStack = ((RhinoException)cause).getScriptStackTrace(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            if (this.scriptStack != null) {
                s.println(this);
                s.print(this.scriptStack);
                s.print("Full trace: ");
            }
            this.getCause().printStackTrace(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            if (this.scriptStack != null) {
                s.println(this);
                s.print(this.scriptStack);
                s.print("Full trace: ");
            }
            this.getCause().printStackTrace(s);
        }
    }
}

