/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.dom;

import helma.objectmodel.INode;
import helma.objectmodel.IProperty;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Node;
import helma.objectmodel.dom.XmlConstants;
import helma.util.HtmlEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XmlWriter
extends OutputStreamWriter
implements XmlConstants {
    private static final String LINESEPARATOR = System.getProperty("line.separator");
    private static int fileid;
    private Vector convertedNodes;
    private int maxLevels = 3;
    private String indent = "  ";
    private StringBuffer prefix = new StringBuffer();
    private SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
    private boolean dbmode = true;
    public int rootState;
    private String explicitEncoding;

    public XmlWriter() {
        super(System.out);
    }

    public XmlWriter(OutputStream out) {
        super(out);
    }

    public XmlWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        super(out, enc);
        this.explicitEncoding = enc;
    }

    public XmlWriter(String desc) throws FileNotFoundException {
        super(new FileOutputStream(desc));
    }

    public XmlWriter(String desc, String enc) throws FileNotFoundException, UnsupportedEncodingException {
        super((OutputStream)new FileOutputStream(desc), enc);
        this.explicitEncoding = enc;
    }

    public XmlWriter(File file) throws FileNotFoundException {
        super(new FileOutputStream(file));
    }

    public XmlWriter(File file, String enc) throws FileNotFoundException, UnsupportedEncodingException {
        super((OutputStream)new FileOutputStream(file), enc);
        this.explicitEncoding = enc;
    }

    public static int generateID() {
        return fileid++;
    }

    public void setMaxLevels(int levels) {
        this.maxLevels = levels;
    }

    public void setDatabaseMode(boolean dbmode) {
        this.dbmode = dbmode;
    }

    public void setIndent(int ct) {
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < ct; ++i) {
            tmp.append(" ");
        }
        this.indent = tmp.toString();
    }

    public boolean write(INode node) throws IOException {
        this.rootState = node.getState();
        this.convertedNodes = new Vector();
        if (this.explicitEncoding == null) {
            this.writeln("<?xml version=\"1.0\"?>");
        } else {
            this.writeln("<?xml version=\"1.0\" encoding=\"" + this.explicitEncoding + "\"?>");
        }
        this.writeln("<?xml-stylesheet type=\"text/xsl\" href=\"helma.xsl\"?>");
        this.write("<xmlroot xmlns:hop=\"");
        this.write("http://www.helma.org/docs/guide/features/database");
        this.writeln("\">");
        this.write(node, null, null, 0);
        this.writeln("</xmlroot>");
        this.convertedNodes = null;
        return true;
    }

    public void write(INode node, String elementName, String propName, int level) throws IOException {
        if (node == null) {
            return;
        }
        int previousLength = this.prefix.length();
        this.prefix.append(this.indent);
        if (++level > this.maxLevels) {
            this.writeReferenceTag(node, elementName, propName);
            this.prefix.setLength(previousLength);
            return;
        }
        if (this.convertedNodes.contains(node)) {
            this.writeReferenceTag(node, elementName, propName);
        } else if (this.rootState == -3 && node.getState() > -3) {
            this.writeReferenceTag(node, elementName, propName);
        } else {
            this.convertedNodes.addElement(node);
            this.writeTagOpen(node, elementName, propName);
            INode parent = node.getParent();
            if (parent != null) {
                this.writeReferenceTag(parent, "hop:parent", null);
            }
            this.writeProperties(node, level);
            this.writeChildren(node, level);
            this.writeTagClose(elementName);
        }
        this.prefix.setLength(previousLength);
    }

    private void writeProperties(INode node, int level) throws IOException {
        Enumeration e = null;
        if (this.dbmode && node instanceof Node) {
            Hashtable props = ((Node)node).getPropMap();
            if (props == null) {
                return;
            }
            e = props.keys();
        } else {
            e = node.properties();
        }
        while (e.hasMoreElements()) {
            String propName;
            String elementName;
            IProperty prop;
            String key = (String)e.nextElement();
            if (this.dbmode && key.charAt(0) == '_' || (prop = node.get(key)) == null) continue;
            boolean validName = this.isValidElementName(key);
            if (validName) {
                elementName = key;
                propName = null;
            } else {
                elementName = "property";
                propName = key;
            }
            int type = prop.getType();
            if (type == 6) {
                this.write(prop.getNodeValue(), elementName, propName, level);
                continue;
            }
            this.writeProperty(prop, elementName, propName);
        }
    }

    public void writeProperty(IProperty property, String elementName, String propName) throws IOException {
        int propType = property.getType();
        if (propType == 7) {
            return;
        }
        this.write(this.prefix.toString());
        this.write(this.indent);
        this.write("<");
        this.write(elementName);
        if (propName != null) {
            this.write(" propertyname=\"");
            this.write(HtmlEncoder.encodeXml(propName));
            this.write("\"");
        }
        switch (propType) {
            case 2: {
                this.write(" type=\"boolean\">");
                this.write(property.getStringValue());
                break;
            }
            case 5: {
                this.write(" type=\"float\">");
                this.write(property.getStringValue());
                break;
            }
            case 4: {
                this.write(" type=\"integer\">");
                this.write(property.getStringValue());
                break;
            }
            case 3: {
                this.write(" type=\"date\">");
                this.write(this.format.format(property.getDateValue()));
                break;
            }
            case 1: {
                this.write(">");
                String str = HtmlEncoder.encodeXml(property.getStringValue());
                if (str == null) break;
                this.write(str);
            }
        }
        this.write("</");
        this.write(elementName);
        this.write(">");
        this.write(LINESEPARATOR);
    }

    private void writeChildren(INode node, int level) throws IOException {
        if (this.dbmode && node instanceof Node) {
            DbMapping smap;
            Node dbNode = (Node)node;
            DbMapping dbMapping = smap = dbNode.getDbMapping() == null ? null : dbNode.getDbMapping().getSubnodeMapping();
            if (smap != null && smap.isRelational()) {
                return;
            }
        }
        Enumeration e = node.getSubnodes();
        while (e.hasMoreElements()) {
            INode nextNode = (INode)e.nextElement();
            this.write(nextNode, "hop:child", null, level);
        }
    }

    public void writeTagOpen(INode node, String name, String propName) throws IOException {
        this.write(this.prefix.toString());
        this.write("<");
        this.write(name == null ? "hopobject" : name);
        this.write(" id=\"");
        this.write(node.getID());
        if (propName != null) {
            this.write("\" propertyname=\"");
            this.write(HtmlEncoder.encodeXml(propName));
        }
        this.write("\" name=\"");
        this.write(HtmlEncoder.encodeXml(node.getName()));
        this.write("\" prototype=\"");
        this.write(this.getNodePrototype(node));
        this.write("\" created=\"");
        this.write(Long.toString(node.created()));
        this.write("\" lastModified=\"");
        this.write(Long.toString(node.lastModified()));
        this.write("\">");
        this.write(LINESEPARATOR);
    }

    public void writeTagClose(String name) throws IOException {
        this.write(this.prefix.toString());
        this.write("</");
        this.write(name == null ? "hopobject" : name);
        this.write(">");
        this.write(LINESEPARATOR);
    }

    public void writeReferenceTag(INode node, String name, String propName) throws IOException {
        this.write(this.prefix.toString());
        this.write("<");
        this.write(name == null ? "hopobject" : name);
        this.write(" idref=\"");
        this.write(node.getID());
        if (propName != null) {
            this.write("\" propertyname=\"");
            this.write(HtmlEncoder.encodeXml(propName));
        }
        this.write("\" prototyperef=\"");
        this.write(this.getNodePrototype(node));
        this.write("\"/>");
        this.write(LINESEPARATOR);
    }

    private String getNodePrototype(INode node) {
        if (node.getPrototype() == null || "".equals(node.getPrototype())) {
            return "hopobject";
        }
        return node.getPrototype();
    }

    public void writeln(String str) throws IOException {
        this.write(str);
        this.write(LINESEPARATOR);
    }

    private boolean isValidElementName(String str) {
        char c = str.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        int l = str.length();
        for (int i = 1; i < l; ++i) {
            c = str.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
            return false;
        }
        return true;
    }
}

