/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static final DocumentBuilderFactory domBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final WeakHashMap domBuilders = new WeakHashMap();

    private static synchronized DocumentBuilder getDocumentBuilder() {
        DocumentBuilder domBuilder = (DocumentBuilder)domBuilders.get(Thread.currentThread());
        if (domBuilder != null) {
            return domBuilder;
        }
        try {
            domBuilder = domBuilderFactory.newDocumentBuilder();
            domBuilders.put(Thread.currentThread(), domBuilder);
            return domBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Cannot build parser: " + e.toString());
        }
    }

    public static Document newDocument() {
        DocumentBuilder d = XmlUtil.getDocumentBuilder();
        return d.newDocument();
    }

    public static Document parse(InputStream in) throws RuntimeException {
        DocumentBuilder d = XmlUtil.getDocumentBuilder();
        try {
            Document doc = d.parse(in);
            doc.normalize();
            return doc;
        }
        catch (SAXException e) {
            throw new RuntimeException("Bad xml-code: " + e.toString());
        }
        catch (IOException f) {
            throw new RuntimeException("Could not read Xml: " + f.toString());
        }
    }

    public static Document parse(InputSource in) throws RuntimeException {
        DocumentBuilder d = XmlUtil.getDocumentBuilder();
        try {
            Document doc = d.parse(in);
            doc.normalize();
            return doc;
        }
        catch (SAXException e) {
            throw new RuntimeException("Bad xml-code: " + e.toString());
        }
        catch (IOException f) {
            throw new RuntimeException("Could not read Xml: " + f.toString());
        }
    }

    public static Element getFirstElement(Document document) {
        Element workelement = null;
        if (document.getDocumentElement() != null) {
            Node tmp = document.getDocumentElement().getFirstChild();
            while (tmp != null) {
                if ((tmp = tmp.getNextSibling()).getNodeType() != 1) continue;
                workelement = (Element)tmp;
                break;
            }
        }
        return workelement;
    }

    public static String getTextContent(Node element) {
        StringBuffer childtext = new StringBuffer();
        NodeList childlist = element.getChildNodes();
        int ct = childlist.getLength();
        for (int j = 0; j < ct; ++j) {
            Node childNode = childlist.item(j);
            if (childNode.getNodeType() != 3 && childNode.getNodeType() != 4) continue;
            childtext.append(childNode.getNodeValue().trim());
        }
        return childtext.toString();
    }
}

