/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.dom;

import helma.objectmodel.INode;
import helma.objectmodel.db.WrappedNodeManager;
import helma.objectmodel.dom.XmlConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlReader
extends DefaultHandler
implements XmlConstants {
    static SAXParserFactory factory = SAXParserFactory.newInstance();
    private INode rootNode;
    private INode currentNode;
    private Stack nodeStack;
    private HashMap convertedNodes;
    private String elementType = null;
    private String elementName = null;
    private StringBuffer charBuffer = null;
    boolean parsingHopObject;
    WrappedNodeManager nmgr;

    public XmlReader(WrappedNodeManager nmgr) {
        this.nmgr = nmgr;
    }

    public INode read(File file, INode helmaNode) throws ParserConfigurationException, SAXException, IOException {
        try {
            return this.read(new FileInputStream(file), helmaNode);
        }
        catch (FileNotFoundException notfound) {
            System.err.println("couldn't find xml-file: " + file.getAbsolutePath());
            return helmaNode;
        }
    }

    public INode read(InputStream in, INode helmaNode) throws ParserConfigurationException, SAXException, IOException {
        return this.read(new InputSource(in), helmaNode);
    }

    public INode read(Reader in, INode helmaNode) throws ParserConfigurationException, SAXException, IOException {
        return this.read(new InputSource(in), helmaNode);
    }

    public INode read(InputSource in, INode helmaNode) throws ParserConfigurationException, SAXException, IOException {
        if (helmaNode == null) {
            throw new RuntimeException("Can't create a new Node without a root Node");
        }
        SAXParser parser = factory.newSAXParser();
        this.rootNode = helmaNode;
        this.currentNode = null;
        this.convertedNodes = new HashMap();
        this.nodeStack = new Stack();
        this.parsingHopObject = true;
        parser.parse(in, (DefaultHandler)this);
        return this.rootNode;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("xmlroot".equals(qName) && this.currentNode == null) {
            return;
        }
        String id = atts.getValue("id");
        if (id != null) {
            if (this.currentNode == null) {
                this.currentNode = this.rootNode;
            } else if ("hop:child".equals(qName)) {
                this.nodeStack.push(this.currentNode);
                this.currentNode = this.currentNode.createNode(null);
            } else {
                this.nodeStack.push(this.currentNode);
                String propName = atts.getValue("propertyname");
                if (propName == null) {
                    propName = qName;
                }
                this.currentNode = this.currentNode.createNode(propName);
            }
            String prototype = atts.getValue("prototype");
            if (!"".equals(prototype) && !"hopobject".equals(prototype)) {
                this.currentNode.setPrototype(prototype);
                this.currentNode.setDbMapping(this.nmgr.getDbMapping(prototype));
            }
            String key = id + "-" + prototype;
            this.convertedNodes.put(key, this.currentNode);
            return;
        }
        if (this.currentNode == null) {
            throw new SAXException("Invalid XML: No valid root HopObject found");
        }
        if (!this.parsingHopObject) {
            throw new SAXException("Invalid XML: Found nested non-HobObject elements");
        }
        this.parsingHopObject = false;
        String idref = atts.getValue("idref");
        if (idref != null) {
            String prototyperef = atts.getValue("prototyperef");
            String key = idref + "-" + prototyperef;
            INode n = (INode)this.convertedNodes.get(key);
            if (n == null) {
                n = this.nmgr.getNode(idref, this.nmgr.getDbMapping(prototyperef));
            }
            if (n != null) {
                if ("hop:child".equals(qName)) {
                    this.currentNode.addNode(n);
                } else {
                    String propName = atts.getValue("propertyname");
                    if (propName == null) {
                        propName = qName;
                    }
                    if (!"hop:parent".equals(qName)) {
                        this.currentNode.setNode(propName, n);
                    }
                }
            }
        } else {
            this.elementType = atts.getValue("type");
            if (this.elementType == null) {
                this.elementType = "string";
            }
            this.elementName = atts.getValue("propertyname");
            if (this.elementName == null) {
                this.elementName = qName;
            }
            if (this.charBuffer == null) {
                this.charBuffer = new StringBuffer();
            } else {
                this.charBuffer.setLength(0);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elementType != null) {
            this.charBuffer.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.elementType != null) {
            String charValue = this.charBuffer.toString();
            this.charBuffer.setLength(0);
            if ("boolean".equals(this.elementType)) {
                if ("true".equals(charValue)) {
                    this.currentNode.setBoolean(this.elementName, true);
                } else {
                    this.currentNode.setBoolean(this.elementName, false);
                }
            } else if ("date".equals(this.elementType)) {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
                try {
                    Date date = format.parse(charValue);
                    this.currentNode.setDate(this.elementName, date);
                }
                catch (ParseException e) {
                    this.currentNode.setString(this.elementName, charValue);
                }
            } else if ("float".equals(this.elementType)) {
                this.currentNode.setFloat(this.elementName, new Double(charValue));
            } else if ("integer".equals(this.elementType)) {
                this.currentNode.setInteger(this.elementName, new Long(charValue));
            } else {
                this.currentNode.setString(this.elementName, charValue);
            }
            this.elementName = null;
            this.elementType = null;
            charValue = null;
        }
        if (this.parsingHopObject && !this.nodeStack.isEmpty()) {
            this.currentNode = (INode)this.nodeStack.pop();
        } else {
            this.parsingHopObject = true;
        }
    }
}

