/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.dom;

import helma.objectmodel.ObjectNotFoundException;
import helma.objectmodel.dom.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlIDGenerator {
    private long counter;
    volatile transient boolean dirty;

    public XmlIDGenerator() {
        this.counter = 0L;
        this.dirty = false;
    }

    public XmlIDGenerator(long value) {
        this.counter = value;
        this.dirty = false;
    }

    public synchronized String newID() {
        ++this.counter;
        this.dirty = true;
        return Long.toString(this.counter);
    }

    protected synchronized void setValue(long value) {
        this.counter = value;
        this.dirty = true;
    }

    public long getValue() {
        return this.counter;
    }

    public String toString() {
        return "IDGenerator[counter=" + this.counter + ",dirty=" + this.dirty + "]";
    }

    public static XmlIDGenerator getIDGenerator(File file) throws ObjectNotFoundException {
        if (!file.exists()) {
            throw new ObjectNotFoundException("IDGenerator not found in idgen.xml");
        }
        try {
            Document document = XmlUtil.parse(new FileInputStream(file));
            Element tmp = (Element)document.getDocumentElement().getElementsByTagName("counter").item(0);
            return new XmlIDGenerator(Long.parseLong(XmlUtil.getTextContent(tmp)));
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(e.toString());
        }
    }

    public static void saveIDGenerator(XmlIDGenerator idgen, File file) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(file));
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<!-- printed by helma object publisher     -->\n");
        out.write("<!-- created " + new Date().toString() + " -->\n");
        out.write("<xmlroot>\n");
        out.write("  <counter>" + idgen.getValue() + "</counter>\n");
        out.write("</xmlroot>\n");
        out.close();
    }
}

