/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.dom;

import helma.objectmodel.db.DbKey;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeHandle;
import helma.objectmodel.db.NodeManager;
import helma.objectmodel.db.Property;
import helma.objectmodel.db.SubnodeList;
import helma.objectmodel.dom.XmlConstants;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlDatabaseReader
extends DefaultHandler
implements XmlConstants {
    static SAXParserFactory factory = SAXParserFactory.newInstance();
    private NodeManager nmgr = null;
    private Node currentNode;
    private String elementType = null;
    private String elementName = null;
    private StringBuffer charBuffer = null;
    Hashtable propMap = null;
    SubnodeList subnodes = null;

    public XmlDatabaseReader(NodeManager nmgr) {
        this.nmgr = nmgr;
    }

    public Node read(File file) throws ParserConfigurationException, SAXException, IOException {
        if (this.nmgr == null) {
            throw new RuntimeException("can't create a new Node without a NodeManager");
        }
        SAXParser parser = factory.newSAXParser();
        this.currentNode = null;
        parser.parse(file, (DefaultHandler)this);
        return this.currentNode;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if ("xmlroot".equals(qName) && this.currentNode == null) {
            return;
        }
        if ("hopobject".equals(qName) && this.currentNode == null) {
            String id = atts.getValue("id");
            String name = atts.getValue("name");
            String prototype = atts.getValue("prototype");
            if ("".equals(prototype)) {
                prototype = "hopobject";
            }
            try {
                long created = Long.parseLong(atts.getValue("created"));
                long lastmodified = Long.parseLong(atts.getValue("lastModified"));
                this.currentNode = new Node(name, id, prototype, this.nmgr.safe, created, lastmodified);
            }
            catch (NumberFormatException e) {
                this.currentNode = new Node(name, id, prototype, this.nmgr.safe);
            }
            return;
        }
        String idref = atts.getValue("idref");
        if (idref != null) {
            NodeHandle handle = this.makeNodeHandle(atts);
            if ("hop:child".equals(qName)) {
                if (this.subnodes == null) {
                    this.subnodes = this.currentNode.createSubnodeList();
                }
                this.subnodes.addSorted(handle);
            } else if ("hop:parent".equals(qName)) {
                this.currentNode.setParentHandle(handle);
            } else {
                String propName = atts.getValue("propertyname");
                if (propName == null) {
                    propName = qName;
                }
                Property prop = new Property(propName, this.currentNode);
                prop.setNodeHandle(handle);
                if (this.propMap == null) {
                    this.propMap = new Hashtable();
                    this.currentNode.setPropMap(this.propMap);
                }
                this.propMap.put(propName.toLowerCase(), prop);
            }
        } else {
            this.elementType = atts.getValue("type");
            if (this.elementType == null) {
                this.elementType = "string";
            }
            this.elementName = atts.getValue("propertyname");
            if (this.elementName == null) {
                this.elementName = qName;
            }
            if (this.charBuffer == null) {
                this.charBuffer = new StringBuffer();
            } else {
                this.charBuffer.setLength(0);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elementType != null) {
            this.charBuffer.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.elementType != null) {
            Property prop = new Property(this.elementName, this.currentNode);
            String charValue = this.charBuffer.toString();
            this.charBuffer.setLength(0);
            if ("boolean".equals(this.elementType)) {
                if ("true".equals(charValue)) {
                    prop.setBooleanValue(true);
                } else {
                    prop.setBooleanValue(false);
                }
            } else if ("date".equals(this.elementType)) {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
                try {
                    Date date = format.parse(charValue);
                    prop.setDateValue(date);
                }
                catch (ParseException e) {
                    prop.setStringValue(charValue);
                }
            } else if ("float".equals(this.elementType)) {
                prop.setFloatValue(new Double(charValue));
            } else if ("integer".equals(this.elementType)) {
                prop.setIntegerValue(new Long(charValue));
            } else {
                prop.setStringValue(charValue);
            }
            if (this.propMap == null) {
                this.propMap = new Hashtable();
                this.currentNode.setPropMap(this.propMap);
            }
            this.propMap.put(this.elementName.toLowerCase(), prop);
            this.elementName = null;
            this.elementType = null;
            charValue = null;
        }
    }

    private NodeHandle makeNodeHandle(Attributes atts) {
        String idref = atts.getValue("idref");
        String protoref = atts.getValue("prototyperef");
        DbMapping dbmap = null;
        if (protoref != null) {
            dbmap = this.nmgr.getDbMapping(protoref);
        }
        return new NodeHandle(new DbKey(dbmap, idref));
    }
}

