/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.dom;

import helma.framework.core.Application;
import helma.objectmodel.DatabaseException;
import helma.objectmodel.IDatabase;
import helma.objectmodel.INode;
import helma.objectmodel.ITransaction;
import helma.objectmodel.ObjectNotFoundException;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeManager;
import helma.objectmodel.dom.XmlDatabaseReader;
import helma.objectmodel.dom.XmlIDGenerator;
import helma.objectmodel.dom.XmlWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class XmlDatabase
implements IDatabase {
    protected File dbHomeDir;
    protected Application app;
    protected NodeManager nmgr;
    protected XmlIDGenerator idgen;
    protected String encoding = null;

    public void init(File dbHome, Application app) throws DatabaseException {
        long idBaseValue;
        this.app = app;
        this.nmgr = app.getNodeManager();
        this.dbHomeDir = dbHome;
        if (!this.dbHomeDir.exists() && !this.dbHomeDir.mkdirs()) {
            throw new DatabaseException("Can't create database directory " + this.dbHomeDir);
        }
        if (!this.dbHomeDir.canWrite()) {
            throw new DatabaseException("No write permission for database directory " + this.dbHomeDir);
        }
        File stylesheet = new File(this.dbHomeDir, "helma.xsl");
        if (!stylesheet.exists()) {
            this.copyStylesheet(stylesheet);
        }
        this.encoding = app.getCharset();
        try {
            idBaseValue = Long.parseLong(app.getProperty("idBaseValue", "1"));
            idBaseValue = Math.max(1L, idBaseValue);
        }
        catch (NumberFormatException ignore) {
            idBaseValue = 1L;
        }
        ITransaction txn = null;
        try {
            txn = this.beginTransaction();
            try {
                this.idgen = this.getIDGenerator(txn);
                if (this.idgen.getValue() < idBaseValue) {
                    this.idgen.setValue(idBaseValue);
                }
            }
            catch (ObjectNotFoundException notfound) {
                this.idgen = new XmlIDGenerator(idBaseValue);
            }
            Node node = null;
            try {
                this.getNode(txn, "0");
            }
            catch (ObjectNotFoundException notfound) {
                node = new Node("root", "0", "Root", this.nmgr.safe);
                node.setDbMapping(app.getDbMapping("root"));
                this.insertNode(txn, node.getID(), node);
            }
            try {
                this.getNode(txn, "1");
            }
            catch (ObjectNotFoundException notfound) {
                node = new Node("users", "1", null, this.nmgr.safe);
                node.setDbMapping(app.getDbMapping("__userroot__"));
                this.insertNode(txn, node.getID(), node);
            }
            this.commitTransaction(txn);
        }
        catch (Exception x) {
            x.printStackTrace();
            try {
                this.abortTransaction(txn);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new DatabaseException("Error initializing db");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStylesheet(File destination) {
        InputStream in = null;
        FileOutputStream out = null;
        byte[] buffer = new byte[1024];
        try {
            int read;
            in = this.getClass().getResourceAsStream("helma.xsl");
            out = new FileOutputStream(destination);
            while ((read = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException iox) {
            System.err.println("Error copying db style sheet: " + iox);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    public void shutdown() {
    }

    public ITransaction beginTransaction() throws DatabaseException {
        return new Transaction();
    }

    public void commitTransaction(ITransaction txn) throws DatabaseException {
        if (this.idgen.dirty) {
            try {
                this.saveIDGenerator(txn);
                this.idgen.dirty = false;
            }
            catch (IOException x) {
                throw new DatabaseException(x.toString());
            }
        }
        txn.commit();
    }

    public void abortTransaction(ITransaction txn) throws DatabaseException {
        txn.abort();
    }

    public String nextID() throws ObjectNotFoundException {
        if (this.idgen == null) {
            this.getIDGenerator(null);
        }
        return this.idgen.newID();
    }

    public XmlIDGenerator getIDGenerator(ITransaction txn) throws ObjectNotFoundException {
        File file = new File(this.dbHomeDir, "idgen.xml");
        this.idgen = XmlIDGenerator.getIDGenerator(file);
        return this.idgen;
    }

    public void saveIDGenerator(ITransaction txn) throws IOException {
        File tmp = File.createTempFile("idgen.xml.", ".tmp", this.dbHomeDir);
        XmlIDGenerator.saveIDGenerator(this.idgen, tmp);
        File file = new File(this.dbHomeDir, "idgen.xml");
        if (file.exists() && !file.canWrite()) {
            throw new IOException("No write permission for " + file);
        }
        Resource res = new Resource(file, tmp);
        txn.addResource(res, 0);
    }

    public INode getNode(ITransaction txn, String kstr) throws IOException, ObjectNotFoundException {
        File f = new File(this.dbHomeDir, kstr + ".xml");
        if (!f.exists()) {
            throw new ObjectNotFoundException("Object not found for key " + kstr);
        }
        try {
            XmlDatabaseReader reader = new XmlDatabaseReader(this.nmgr);
            Node node = reader.read(f);
            return node;
        }
        catch (ParserConfigurationException x) {
            this.app.logError("Error reading " + f, x);
            throw new IOException(x.toString());
        }
        catch (SAXException x) {
            this.app.logError("Error reading " + f, x);
            throw new IOException(x.toString());
        }
    }

    public void insertNode(ITransaction txn, String kstr, INode node) throws IOException {
        File f = new File(this.dbHomeDir, kstr + ".xml");
        if (f.exists()) {
            throw new IOException("Object already exists for key " + kstr);
        }
        this.updateNode(txn, kstr, node);
    }

    public void updateNode(ITransaction txn, String kstr, INode node) throws IOException {
        XmlWriter writer = null;
        File tmp = File.createTempFile(kstr + ".xml.", ".tmp", this.dbHomeDir);
        writer = this.encoding != null ? new XmlWriter(tmp, this.encoding) : new XmlWriter(tmp);
        writer.setMaxLevels(1);
        writer.write(node);
        writer.close();
        File file = new File(this.dbHomeDir, kstr + ".xml");
        if (file.exists() && !file.canWrite()) {
            throw new IOException("No write permission for " + file);
        }
        Resource res = new Resource(file, tmp);
        txn.addResource(res, 0);
    }

    public void deleteNode(ITransaction txn, String kstr) throws IOException {
        Resource res = new Resource(new File(this.dbHomeDir, kstr + ".xml"), null);
        txn.addResource(res, 2);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    class IDGenerator {
        IDGenerator() {
        }
    }

    class Resource {
        File tmpfile;
        File file;

        public Resource(File file, File tmpfile) {
            this.file = file;
            this.tmpfile = tmpfile;
        }
    }

    class Transaction
    implements ITransaction {
        ArrayList writeFiles = new ArrayList();
        ArrayList deleteFiles = new ArrayList();

        Transaction() {
        }

        public void commit() throws DatabaseException {
            Resource res;
            int i;
            int l = this.writeFiles.size();
            for (i = 0; i < l; ++i) {
                res = (Resource)this.writeFiles.get(i);
                try {
                    if (res.file.exists()) {
                        res.file.delete();
                    }
                    if (res.tmpfile.renameTo(res.file)) {
                        res.tmpfile.delete();
                        continue;
                    }
                    XmlDatabase.this.app.logError("*** Error committing " + res.file);
                    XmlDatabase.this.app.logError("*** Committed version is in " + res.tmpfile);
                    continue;
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
            l = this.deleteFiles.size();
            for (i = 0; i < l; ++i) {
                res = (Resource)this.deleteFiles.get(i);
                try {
                    res.file.delete();
                    continue;
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
            this.writeFiles.clear();
            this.deleteFiles.clear();
        }

        public void abort() throws DatabaseException {
            int l = this.writeFiles.size();
            for (int i = 0; i < l; ++i) {
                Resource res = (Resource)this.writeFiles.get(i);
                try {
                    res.tmpfile.delete();
                    continue;
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
            this.writeFiles.clear();
            this.deleteFiles.clear();
        }

        public void addResource(Object res, int status) throws DatabaseException {
            if (status == 2) {
                this.deleteFiles.add(res);
            } else {
                this.writeFiles.add(res);
            }
        }
    }
}

