/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.dom;

import helma.objectmodel.INode;
import helma.objectmodel.TransientNode;
import helma.objectmodel.dom.XmlConstants;
import helma.objectmodel.dom.XmlUtil;
import helma.util.SystemProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlConverter
implements XmlConstants {
    private boolean DEBUG = false;
    private boolean sparse = false;
    private Properties props;
    private char defaultSeparator = (char)95;
    private int offset = 0;

    public XmlConverter() {
        this.props = new SystemProperties();
    }

    public XmlConverter(String propFile) {
        this.props = new SystemProperties(propFile);
        this.extractProperties(this.props);
    }

    public XmlConverter(File propFile) {
        this(propFile.getAbsolutePath());
    }

    public XmlConverter(Properties props) {
        this.props = props;
        this.extractProperties(props);
    }

    public INode convert(String desc) {
        return this.convert(desc, (INode)new TransientNode());
    }

    public INode convert(String desc, INode helmaNode) throws RuntimeException {
        try {
            return this.convert(new URL(desc), helmaNode);
        }
        catch (MalformedURLException notanurl) {
            try {
                return this.convert(new File(desc), helmaNode);
            }
            catch (FileNotFoundException notfound) {
                throw new RuntimeException("couldn't read xml: " + desc);
            }
        }
        catch (IOException ioerror) {
            throw new RuntimeException("couldn't read xml: " + desc);
        }
    }

    public INode convert(File file, INode helmaNode) throws RuntimeException, FileNotFoundException {
        return this.convert(new FileInputStream(file), helmaNode);
    }

    public INode convert(URL url, INode helmaNode) throws RuntimeException, IOException, MalformedURLException {
        return this.convert(url.openConnection().getInputStream(), helmaNode);
    }

    public INode convert(InputStream in, INode helmaNode) throws RuntimeException {
        Document document = XmlUtil.parse(in);
        if (document != null && document.getDocumentElement() != null) {
            return this.convert(document.getDocumentElement(), helmaNode, new HashMap());
        }
        return helmaNode;
    }

    public INode convertFromString(String xml, INode helmaNode) throws RuntimeException {
        Document document = XmlUtil.parse(new InputSource(new StringReader(xml)));
        if (document != null && document.getDocumentElement() != null) {
            return this.convert(document.getDocumentElement(), helmaNode, new HashMap());
        }
        return helmaNode;
    }

    public INode convert(Element element, INode helmaNode, Map nodeCache) {
        String prototype;
        ++this.offset;
        INode previousNode = null;
        if (this.DEBUG) {
            this.debug("reading " + element.getNodeName());
        }
        if ((prototype = this.props.getProperty(element.getNodeName() + "._prototype")) == null && !this.sparse) {
            prototype = "HopObject";
        }
        if (prototype != null) {
            helmaNode.setName(element.getNodeName());
            helmaNode.setPrototype(prototype);
            previousNode = nodeCache.put(prototype, helmaNode);
        }
        this.attributes(element, helmaNode, nodeCache);
        if (element.hasChildNodes()) {
            this.children(element, helmaNode, nodeCache);
        }
        if (previousNode != null) {
            nodeCache.put(prototype, previousNode);
        }
        --this.offset;
        return helmaNode;
    }

    private INode children(Element element, INode helmaNode, Map nodeCache) {
        String helmaKey;
        NodeList list = element.getChildNodes();
        int len = list.getLength();
        boolean nodeIsInitialized = !nodeCache.isEmpty();
        StringBuffer textcontent = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            INode node;
            Node childNode = list.item(i);
            if (!nodeIsInitialized) {
                if (childNode.getNodeType() != 1) continue;
                this.convert((Element)childNode, helmaNode, nodeCache);
                if (helmaNode.getPrototype() == null) continue;
                return helmaNode;
            }
            if (childNode.getNodeType() == 3 || childNode.getNodeType() == 4) {
                textcontent.append(childNode.getNodeValue().trim());
                continue;
            }
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            String domKey = element.getNodeName() + "." + childElement.getNodeName();
            if (this.props != null && this.props.containsKey(domKey + "._text")) {
                int dot;
                helmaKey = this.props.getProperty(domKey + "._text");
                if (helmaKey.equals("")) {
                    helmaKey = childElement.getNodeName().replace(':', this.defaultSeparator);
                }
                if (this.DEBUG) {
                    this.debug("childtext-2-property mapping, helmaKey " + helmaKey + " for domKey " + domKey);
                }
                if ((dot = helmaKey.indexOf(".")) > -1) {
                    String prototype = helmaKey.substring(0, dot);
                    node = (INode)nodeCache.get(prototype);
                    helmaKey = helmaKey.substring(dot + 1);
                    if (node == null || node.getString(helmaKey) != null) continue;
                    node.setString(helmaKey, XmlUtil.getTextContent(childNode));
                    continue;
                }
                if (helmaNode.getString(helmaKey) != null) continue;
                helmaNode.setString(helmaKey, XmlUtil.getTextContent(childNode));
                if (!this.DEBUG) continue;
                this.debug("childtext-2-property mapping, setting " + helmaKey + " as string");
                continue;
            }
            if (this.props != null && this.props.containsKey(domKey + "._property")) {
                helmaKey = this.props.getProperty(domKey + "._property");
                if (helmaKey.equals("")) {
                    helmaKey = childElement.getNodeName().replace(':', this.defaultSeparator);
                }
                if (this.DEBUG) {
                    this.debug("child-2-property mapping, helmaKey " + helmaKey + " for domKey " + domKey);
                }
                INode node2 = helmaNode;
                int dot = helmaKey.indexOf(".");
                if (dot > -1) {
                    String prototype = helmaKey.substring(0, dot);
                    if (!prototype.equalsIgnoreCase(node2.getPrototype())) {
                        node2 = (INode)nodeCache.get(prototype);
                    }
                    helmaKey = helmaKey.substring(dot + 1);
                }
                if (node2 == null || node2.getNode(helmaKey) != null) continue;
                this.convert(childElement, node2.createNode(helmaKey), nodeCache);
                if (!this.DEBUG) continue;
                this.debug("read " + childElement.toString() + node2.getNode(helmaKey).toString());
                continue;
            }
            INode newHelmaNode = null;
            String childrenMapping = this.props.getProperty(element.getNodeName() + "._children");
            if (childrenMapping != null && (childrenMapping.equals("_all") || childrenMapping.equals(childElement.getNodeName()))) {
                newHelmaNode = this.convert(childElement, helmaNode.createNode(null), nodeCache);
            }
            if ((helmaKey = this.props.getProperty(domKey)) == null && !this.sparse) {
                helmaKey = childElement.getNodeName().replace(':', this.defaultSeparator);
            }
            if (helmaKey == null) {
                this.attributes(childElement, helmaNode, nodeCache);
                this.children(childElement, helmaNode, nodeCache);
                continue;
            }
            node = helmaNode;
            int dot = helmaKey.indexOf(".");
            if (dot > -1) {
                String prototype = helmaKey.substring(0, dot);
                if (!prototype.equalsIgnoreCase(node.getPrototype())) {
                    node = (INode)nodeCache.get(prototype);
                }
                helmaKey = helmaKey.substring(dot + 1);
            }
            if (node == null) continue;
            INode worknode = null;
            if ("_children".equals(helmaKey)) {
                worknode = node;
            } else {
                worknode = node.getNode(helmaKey);
                if (worknode == null) {
                    worknode = helmaNode.createNode(helmaKey);
                }
            }
            if (this.DEBUG) {
                this.debug("mounting child " + childElement.getNodeName() + " at worknode " + worknode.toString());
            }
            if (newHelmaNode != null) {
                worknode.addNode(newHelmaNode);
                continue;
            }
            this.convert(childElement, worknode.createNode(null), nodeCache);
        }
        if (textcontent.length() > 0 && !this.sparse) {
            helmaKey = this.props.getProperty(element.getNodeName() + "._text");
            if (helmaKey == null) {
                helmaKey = "text";
            }
            if (this.DEBUG) {
                this.debug("setting text " + textcontent + " to property " + helmaKey + " of object " + helmaNode);
            }
            helmaNode.setString(helmaKey, textcontent.toString().trim());
        }
        return helmaNode;
    }

    private INode attributes(Element element, INode helmaNode, Map nodeCache) {
        NamedNodeMap nnm = element.getAttributes();
        int len = nnm.getLength();
        for (int i = 0; i < len; ++i) {
            Node attr = nnm.item(i);
            String helmaKey = this.props.getProperty(element.getNodeName() + "._attribute." + attr.getNodeName());
            if (helmaKey == null && !this.sparse) {
                helmaKey = attr.getNodeName().replace(':', this.defaultSeparator);
            }
            if (helmaKey == null) continue;
            int dot = helmaKey.indexOf(".");
            if (dot > -1) {
                String prototype = helmaKey.substring(0, dot);
                INode node = (INode)nodeCache.get(prototype);
                if (node == null) continue;
                node.setString(helmaKey.substring(dot + 1), attr.getNodeValue());
                continue;
            }
            if (helmaNode.getPrototype() == null) continue;
            helmaNode.setString(helmaKey, attr.getNodeValue());
        }
        return helmaNode;
    }

    private void extractProperties(Properties props) {
        if (props.containsKey("separator")) {
            this.defaultSeparator = props.getProperty("separator").charAt(0);
        }
        this.sparse = "sparse".equalsIgnoreCase(props.getProperty("_mode"));
    }

    void debug(Object msg) {
        for (int i = 0; i < this.offset; ++i) {
            System.out.print("   ");
        }
        System.out.println(msg.toString());
    }

    public static void main(String[] args) {
    }
}

