/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.ObjectNotFoundException;
import helma.objectmodel.db.DbKey;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Key;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeManager;
import helma.objectmodel.db.Relation;
import helma.objectmodel.db.SubnodeList;
import java.util.Vector;

public final class WrappedNodeManager {
    NodeManager nmgr;

    public WrappedNodeManager(NodeManager nmgr) {
        this.nmgr = nmgr;
    }

    public Node getNode(String id, DbMapping dbmap) {
        return this.getNode(new DbKey(dbmap, id));
    }

    public Node getNode(Key key) {
        try {
            return this.nmgr.getNode(key);
        }
        catch (ObjectNotFoundException x) {
            return null;
        }
        catch (Exception x) {
            this.nmgr.app.logError("Error retrieving Node for " + key, x);
            throw new RuntimeException("Error retrieving Node", x);
        }
    }

    public Node getNode(Node home, String id, Relation rel) {
        try {
            return this.nmgr.getNode(home, id, rel);
        }
        catch (ObjectNotFoundException x) {
            return null;
        }
        catch (Exception x) {
            this.nmgr.app.logError("Error retrieving Node \"" + id + "\" from " + home, x);
            throw new RuntimeException("Error retrieving Node", x);
        }
    }

    public SubnodeList getNodes(Node home, Relation rel) {
        try {
            return this.nmgr.getNodes(home, rel);
        }
        catch (Exception x) {
            throw new RuntimeException("Error retrieving Nodes", x);
        }
    }

    public SubnodeList getNodeIDs(Node home, Relation rel) {
        try {
            return this.nmgr.getNodeIDs(home, rel);
        }
        catch (Exception x) {
            throw new RuntimeException("Error retrieving NodeIDs", x);
        }
    }

    public int updateSubnodeList(Node home, Relation rel) {
        try {
            return this.nmgr.updateSubnodeList(home, rel);
        }
        catch (Exception x) {
            throw new RuntimeException("Error retrieving NodeIDs", x);
        }
    }

    public int countNodes(Node home, Relation rel) {
        try {
            return this.nmgr.countNodes(home, rel);
        }
        catch (Exception x) {
            throw new RuntimeException("Error counting Nodes", x);
        }
    }

    public void deleteNode(Node node) {
        try {
            this.nmgr.deleteNode(node);
        }
        catch (Exception x) {
            throw new RuntimeException("Error deleting Node", x);
        }
    }

    public Vector getPropertyNames(Node home, Relation rel) {
        try {
            return this.nmgr.getPropertyNames(home, rel);
        }
        catch (Exception x) {
            throw new RuntimeException("Error retrieving property names ", x);
        }
    }

    public void registerNode(Node node) {
        this.nmgr.registerNode(node);
    }

    public void registerNode(Node node, Key key) {
        this.nmgr.registerNode(node, key);
    }

    public void evictNode(Node node) {
        this.nmgr.evictNode(node);
    }

    public void evictNodeByKey(Key key) {
        this.nmgr.evictNodeByKey(key);
    }

    public void evictKey(Key key) {
        this.nmgr.evictKey(key);
    }

    public String generateID(DbMapping map) {
        try {
            return this.nmgr.generateID(map);
        }
        catch (Exception x) {
            throw new RuntimeException(x.toString(), x);
        }
    }

    public Node getRootNode() {
        try {
            return this.nmgr.getRootNode();
        }
        catch (Exception x) {
            throw new RuntimeException(x.toString(), x);
        }
    }

    public boolean isRootNode(Node node) {
        return this.nmgr.isRootNode(node);
    }

    public Object[] getCacheEntries() {
        return this.nmgr.getCacheEntries();
    }

    public void logEvent(String msg) {
        this.nmgr.app.logEvent(msg);
    }

    public DbMapping getDbMapping(String name) {
        return this.nmgr.app.getDbMapping(name);
    }
}

