/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.db.DbColumn;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeHandle;
import helma.objectmodel.db.OrderedSubnodeList;
import helma.objectmodel.db.Property;
import helma.objectmodel.db.Relation;
import helma.objectmodel.db.WrappedNodeManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;

public class UpdateableSubnodeList
extends OrderedSubnodeList {
    private final String[] updateCriteria;
    private final String[] updateProperty;
    private final boolean[] updateTypeDesc;
    private Object[] highestValues = null;
    private Object[] lowestValues = null;

    public UpdateableSubnodeList(WrappedNodeManager nmgr, Relation rel) {
        super(nmgr, rel);
        if (rel.updateCriteria == null) {
            this.updateCriteria = new String[1];
            this.updateCriteria[0] = rel.otherType.getIDField();
            this.updateProperty = null;
            this.updateTypeDesc = new boolean[1];
            this.updateTypeDesc[0] = false;
            this.highestValues = new Object[1];
            this.lowestValues = new Object[1];
        } else {
            String[] singleCriterias = rel.updateCriteria.split(",");
            this.updateCriteria = new String[singleCriterias.length];
            this.updateProperty = new String[singleCriterias.length];
            this.updateTypeDesc = new boolean[singleCriterias.length];
            this.highestValues = new Object[singleCriterias.length];
            this.lowestValues = new Object[singleCriterias.length];
            for (int i = 0; i < singleCriterias.length; ++i) {
                this.parseCriteria(i, singleCriterias[i]);
            }
        }
    }

    private void parseCriteria(int idx, String criteria) {
        String[] criteriaParts = criteria.trim().split(" ");
        this.updateCriteria[idx] = criteriaParts[0].trim();
        this.updateProperty[idx] = this.rel.otherType.columnNameToProperty(this.updateCriteria[idx]);
        if (this.updateProperty[idx] == null && !this.updateCriteria[idx].equalsIgnoreCase(this.rel.otherType.getIDField())) {
            throw new RuntimeException("updateCriteria has to be mapped as Property of this Prototype (" + this.updateCriteria[idx] + ")");
        }
        if (criteriaParts.length < 2) {
            this.updateTypeDesc[idx] = false;
            return;
        }
        String direction = criteriaParts[1].trim().toLowerCase();
        this.updateTypeDesc[idx] = "desc".equals(direction);
    }

    public String getUpdateCriteria() throws SQLException, ClassNotFoundException {
        StringBuffer criteria = new StringBuffer();
        for (int i = 0; i < this.updateCriteria.length; ++i) {
            if (!this.updateTypeDesc[i] && this.highestValues[i] == null || this.updateTypeDesc[i] && this.lowestValues[i] == null) continue;
            if (criteria.length() > 0) {
                criteria.append(" OR ");
            }
            this.renderUpdateCriteria(i, criteria);
        }
        if (criteria.length() < 1) {
            return null;
        }
        criteria.insert(0, "(");
        criteria.append(")");
        return criteria.toString();
    }

    private void renderUpdateCriteria(int idx, StringBuffer sb) throws SQLException, ClassNotFoundException {
        if (!this.updateTypeDesc[idx]) {
            sb.append(this.updateCriteria[idx]);
            sb.append(" > ");
            this.renderValue(idx, this.highestValues, sb);
        } else {
            sb.append(this.updateCriteria[idx]);
            sb.append(" < ");
            this.renderValue(idx, this.lowestValues, sb);
        }
    }

    private void renderValue(int idx, Object[] values, StringBuffer sb) throws SQLException, ClassNotFoundException {
        DbColumn dbc = this.rel.otherType.getColumn(this.updateCriteria[idx]);
        if (this.rel.otherType.getIDField().equalsIgnoreCase(this.updateCriteria[idx])) {
            if (this.rel.otherType.needsQuotes(this.updateCriteria[idx])) {
                sb.append("'").append(values[idx]).append("'");
            } else {
                sb.append(values[idx]);
            }
            return;
        }
        Property p = (Property)values[idx];
        String strgVal = p.getStringValue();
        switch (dbc.getType()) {
            case 91: 
            case 92: 
            case 93: {
                Timestamp ts = p.getTimestampValue();
                sb.append("{ts '");
                sb.append(ts.toString());
                sb.append("'}");
                return;
            }
        }
        if (this.rel.otherType.needsQuotes(this.updateCriteria[idx])) {
            sb.append("'").append(strgVal).append("'");
        } else {
            sb.append(strgVal);
        }
    }

    public boolean add(Object obj) {
        NodeHandle nh = (NodeHandle)obj;
        this.updateBorders(nh);
        return super.add(nh);
    }

    public void add(int idx, Object obj) {
        NodeHandle nh = (NodeHandle)obj;
        super.add(idx, nh);
        this.updateBorders(nh);
    }

    private void updateBorders(NodeHandle nh) {
        Node node = null;
        for (int i = 0; i < this.updateCriteria.length; ++i) {
            node = this.updateBorder(i, nh, node);
        }
    }

    private Node updateBorder(int idx, NodeHandle nh, Node node) {
        String cret = this.updateCriteria[idx];
        if (this.rel.otherType.getIDField().equalsIgnoreCase(cret)) {
            String nid = nh.getID();
            if (this.updateTypeDesc[idx] && OrderedSubnodeList.compareNumericString(nid, (String)this.lowestValues[idx]) < 0) {
                this.lowestValues[idx] = nid;
            } else if (!this.updateTypeDesc[idx] && OrderedSubnodeList.compareNumericString(nid, (String)this.highestValues[idx]) > 0) {
                this.highestValues[idx] = nid;
            }
        } else {
            if (node == null) {
                node = nh.getNode(this.rel.otherType.getWrappedNodeManager());
            }
            Property np = node.getProperty(this.rel.otherType.columnNameToProperty(cret));
            if (this.updateTypeDesc[idx]) {
                Property lp = (Property)this.lowestValues[idx];
                if (lp == null || np.compareTo(lp) < 0) {
                    this.lowestValues[idx] = np;
                }
            } else {
                Property hp = (Property)this.highestValues[idx];
                if (hp == null || np.compareTo(hp) > 0) {
                    this.highestValues[idx] = np;
                }
            }
        }
        return node;
    }

    private void rebuildBorders(NodeHandle nh) {
        int i;
        boolean[] check = new boolean[this.updateCriteria.length];
        Node node = nh.getNode(this.rel.otherType.getWrappedNodeManager());
        for (i = 0; i < this.updateCriteria.length; ++i) {
            String cret = this.updateCriteria[i];
            if (cret.equalsIgnoreCase(this.rel.otherType.getIDField())) {
                check[i] = this.updateTypeDesc[i] && nh.getID().equals(this.lowestValues[i]) || !this.updateTypeDesc[i] && nh.getID().equals(this.highestValues[i]);
                continue;
            }
            Property p = node.getProperty(this.updateProperty[i]);
            check[i] = this.updateTypeDesc[i] && p.equals(this.lowestValues[i]) || !this.updateTypeDesc[i] && p.equals(this.highestValues[i]);
        }
        for (i = 0; i < this.updateCriteria.length; ++i) {
            if (!check[i]) continue;
            this.rebuildBorder(i);
        }
    }

    public void rebuildBorders() {
        for (int i = 0; i < this.updateCriteria.length; ++i) {
            this.rebuildBorder(i);
        }
    }

    private void rebuildBorder(int idx) {
        if (this.updateTypeDesc[idx]) {
            this.lowestValues[idx] = null;
        } else {
            this.highestValues[idx] = null;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.updateBorder(idx, (NodeHandle)this.get(i), null);
        }
    }

    public Object remove(int idx) {
        Object obj = super.remove(idx);
        if (obj == null) {
            return null;
        }
        this.rebuildBorders((NodeHandle)obj);
        return obj;
    }

    public boolean remove(Object obj) {
        if (!super.remove(obj)) {
            return false;
        }
        this.rebuildBorders((NodeHandle)obj);
        return true;
    }

    public boolean removeAll(Collection c) {
        if (!super.removeAll(c)) {
            return false;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.rebuildBorders((NodeHandle)i.next());
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        if (!super.retainAll(c)) {
            return false;
        }
        this.rebuildBorders();
        return true;
    }

    public Object set(int idx, Object obj) {
        Object prevObj = super.set(idx, obj);
        this.rebuildBorders((NodeHandle)prevObj);
        this.updateBorders((NodeHandle)obj);
        return prevObj;
    }

    public boolean addAll(Collection col) {
        return this.sortIn(col, true) > 0;
    }
}

