/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.DatabaseException;
import helma.objectmodel.ITransaction;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.DbSource;
import helma.objectmodel.db.Key;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Transactor
extends Thread {
    NodeManager nmgr;
    private HashMap dirtyNodes;
    private HashMap cleanNodes;
    private HashSet parentNodes;
    private volatile boolean active;
    private volatile boolean killed;
    protected ITransaction txn;
    private HashMap sqlConnections;
    private HashSet testedConnections;
    private long tstart;
    private String tname;

    public Transactor(Runnable runnable, ThreadGroup group, NodeManager nmgr) {
        super(group, runnable, group.getName());
        this.nmgr = nmgr;
        this.dirtyNodes = new HashMap();
        this.cleanNodes = new HashMap();
        this.parentNodes = new HashSet();
        this.sqlConnections = new HashMap();
        this.testedConnections = new HashSet();
        this.active = false;
        this.killed = false;
    }

    public void visitNode(Node node) {
        Key key;
        if (node != null && !this.dirtyNodes.containsKey(key = node.getKey())) {
            this.dirtyNodes.put(key, node);
        }
    }

    public void dropNode(Node node) {
        if (node != null) {
            Key key = node.getKey();
            this.dirtyNodes.remove(key);
        }
    }

    public void visitCleanNode(Node node) {
        Key key;
        if (node != null && !this.cleanNodes.containsKey(key = node.getKey())) {
            this.cleanNodes.put(key, node);
        }
    }

    public void visitCleanNode(Key key, Node node) {
        if (node != null && !this.cleanNodes.containsKey(key)) {
            this.cleanNodes.put(key, node);
        }
    }

    public Node getVisitedNode(Object key) {
        return key == null ? null : (Node)this.cleanNodes.get(key);
    }

    public void visitParentNode(Node node) {
        this.parentNodes.add(node);
    }

    public boolean isActive() {
        return this.active;
    }

    public void registerConnection(DbSource src, Connection con) {
        this.sqlConnections.put(src, con);
        this.testedConnections.add(src);
    }

    public Connection getConnection(DbSource src) {
        Connection con = (Connection)this.sqlConnections.get(src);
        if (con != null && !this.testedConnections.contains(src)) {
            try {
                Statement stmt = con.createStatement();
                stmt.execute("SELECT 1");
                stmt.close();
                this.testedConnections.add(src);
            }
            catch (SQLException sx) {
                try {
                    con.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                return null;
            }
        }
        return con;
    }

    public synchronized void begin(String name) throws Exception {
        if (this.killed) {
            throw new DatabaseException("Transaction started on killed thread");
        }
        if (this.active) {
            this.abort();
        }
        this.dirtyNodes.clear();
        this.cleanNodes.clear();
        this.parentNodes.clear();
        this.testedConnections.clear();
        this.txn = this.nmgr.db.beginTransaction();
        this.active = true;
        this.tstart = System.currentTimeMillis();
        this.tname = name;
    }

    public synchronized void commit() throws Exception {
        Iterator i;
        Node node;
        if (this.killed) {
            throw new DatabaseException("commit() called on killed transactor thread");
        }
        if (!this.active) {
            return;
        }
        int inserted = 0;
        int updated = 0;
        int deleted = 0;
        ArrayList<Node> insertedNodes = null;
        ArrayList<Node> updatedNodes = null;
        ArrayList<Node> deletedNodes = null;
        ArrayList<Node> modifiedParentNodes = null;
        boolean hasListeners = this.nmgr.hasNodeChangeListeners();
        if (hasListeners) {
            insertedNodes = new ArrayList<Node>();
            updatedNodes = new ArrayList<Node>();
            deletedNodes = new ArrayList<Node>();
            modifiedParentNodes = new ArrayList<Node>();
        }
        if (!this.dirtyNodes.isEmpty()) {
            Object[] dirty = this.dirtyNodes.values().toArray();
            HashSet<DbMapping> dirtyDbMappings = new HashSet<DbMapping>();
            for (int i2 = 0; i2 < dirty.length; ++i2) {
                node = (Node)dirty[i2];
                int nstate = node.getState();
                if (nstate == 1) {
                    this.nmgr.insertNode(this.nmgr.db, this.txn, node);
                    dirtyDbMappings.add(node.getDbMapping());
                    node.setState(0);
                    this.nmgr.registerNode(node);
                    if (hasListeners) {
                        insertedNodes.add(node);
                    }
                    ++inserted;
                    this.nmgr.app.logEvent("inserted: Node " + node.getPrototype() + "/" + node.getID());
                } else if (nstate == 2) {
                    if (this.nmgr.updateNode(this.nmgr.db, this.txn, node)) {
                        dirtyDbMappings.add(node.getDbMapping());
                    }
                    node.setState(0);
                    this.nmgr.registerNode(node);
                    if (hasListeners) {
                        updatedNodes.add(node);
                    }
                    ++updated;
                    this.nmgr.app.logEvent("updated: Node " + node.getPrototype() + "/" + node.getID());
                } else if (nstate == 3) {
                    this.nmgr.deleteNode(this.nmgr.db, this.txn, node);
                    dirtyDbMappings.add(node.getDbMapping());
                    this.nmgr.evictNode(node);
                    if (hasListeners) {
                        deletedNodes.add(node);
                    }
                    ++deleted;
                }
                node.clearWriteLock();
            }
            i = dirtyDbMappings.iterator();
            while (i.hasNext()) {
                DbMapping dbm = (DbMapping)i.next();
                if (dbm == null) continue;
                dbm.setLastDataChange();
            }
        }
        long now = System.currentTimeMillis();
        if (!this.parentNodes.isEmpty()) {
            i = this.parentNodes.iterator();
            while (i.hasNext()) {
                node = (Node)i.next();
                node.markSubnodesChanged();
                if (!hasListeners) continue;
                modifiedParentNodes.add(node);
            }
        }
        if (hasListeners) {
            this.nmgr.fireNodeChangeEvent(insertedNodes, updatedNodes, deletedNodes, modifiedParentNodes);
        }
        this.recycle();
        if (this.active) {
            this.active = false;
            this.nmgr.db.commitTransaction(this.txn);
            this.txn = null;
        }
        this.nmgr.app.logAccess(this.tname + " " + inserted + " inserted, " + updated + " updated, " + deleted + " deleted in " + (now - this.tstart) + " millis");
        this.tname = null;
    }

    public synchronized void abort() {
        Object[] dirty = this.dirtyNodes.values().toArray();
        for (int i = 0; i < dirty.length; ++i) {
            Node node = (Node)dirty[i];
            this.nmgr.evictNode(node);
            node.clearWriteLock();
        }
        long now = System.currentTimeMillis();
        Iterator i = this.parentNodes.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            node.markSubnodesChanged();
        }
        this.recycle();
        this.closeConnections();
        if (this.active) {
            this.active = false;
            if (this.txn != null) {
                this.nmgr.db.abortTransaction(this.txn);
                this.txn = null;
            }
            this.nmgr.app.logAccess(this.tname + " aborted after " + (System.currentTimeMillis() - this.tstart) + " millis");
        }
        this.tname = null;
    }

    public synchronized void kill() {
        this.killed = true;
        this.interrupt();
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join(1000L);
            }
            catch (InterruptedException ir) {
                // empty catch block
            }
        }
        if (this.isAlive() && "true".equals(this.nmgr.app.getProperty("requestTimeoutStop"))) {
            try {
                Thread.sleep(2000L);
                if (this.isAlive()) {
                    this.nmgr.app.logEvent("Stopping Thread for Transactor " + this);
                    this.stop();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void closeConnections() {
        if (this.sqlConnections != null) {
            Iterator i = this.sqlConnections.values().iterator();
            while (i.hasNext()) {
                try {
                    Connection con = (Connection)i.next();
                    con.close();
                    this.nmgr.app.logEvent("Closing DB connection: " + con);
                }
                catch (Exception exception) {}
            }
            this.sqlConnections.clear();
        }
    }

    private synchronized void recycle() {
        this.dirtyNodes.clear();
        this.cleanNodes.clear();
        this.parentNodes.clear();
        this.testedConnections.clear();
    }

    public String getTransactionName() {
        return this.tname;
    }

    public String toString() {
        return "Transactor[" + this.tname + "]";
    }
}

