/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.db.IReplicationListener;
import helma.objectmodel.db.NodeChangeListener;
import helma.objectmodel.db.NodeManager;
import java.rmi.Naming;
import java.util.List;
import java.util.Vector;

public class Replicator
implements Runnable,
NodeChangeListener {
    Vector urls = new Vector();
    Vector add = new Vector();
    Vector delete = new Vector();
    Vector currentAdd;
    Vector currentDelete;
    Thread runner;
    NodeManager nmgr;

    public Replicator(NodeManager nmgr) {
        this.nmgr = nmgr;
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void addUrl(String url) {
        this.urls.addElement(url);
        if (this.nmgr.logReplication) {
            this.nmgr.app.logEvent("Adding replication listener: " + url);
        }
    }

    public void run() {
        while (Thread.currentThread() == this.runner) {
            if (this.prepareReplication()) {
                for (int i = 0; i < this.urls.size(); ++i) {
                    try {
                        String url = (String)this.urls.elementAt(i);
                        IReplicationListener listener = (IReplicationListener)Naming.lookup(url);
                        if (listener == null) {
                            throw new NullPointerException("Replication listener not bound for URL " + url);
                        }
                        listener.replicateCache(this.currentAdd, this.currentDelete);
                        if (!this.nmgr.logReplication) continue;
                        this.nmgr.app.logEvent("Sent cache replication event: " + this.currentAdd.size() + " added, " + this.currentDelete.size() + " deleted");
                        continue;
                    }
                    catch (Exception x) {
                        this.nmgr.app.logEvent("Error sending cache replication event: " + x);
                        if (!this.nmgr.app.debug()) continue;
                        x.printStackTrace();
                    }
                }
            }
            try {
                if (this.runner == null) continue;
                Thread.sleep(1000L);
            }
            catch (InterruptedException ir) {
                this.runner = null;
            }
        }
    }

    public synchronized void nodesChanged(List inserted, List updated, List deleted, List parents) {
        this.add.addAll(inserted);
        this.add.addAll(updated);
        this.delete.addAll(deleted);
    }

    private synchronized boolean prepareReplication() {
        if (this.add.size() == 0 && this.delete.size() == 0) {
            return false;
        }
        this.currentAdd = this.add;
        this.currentDelete = this.delete;
        this.add = new Vector();
        this.delete = new Vector();
        return true;
    }
}

