/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.framework.core.Application;
import helma.objectmodel.INode;
import helma.objectmodel.IProperty;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.DbSource;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.Property;
import helma.util.ResourceProperties;
import helma.util.StringUtils;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public final class Relation {
    public static final int INVALID = -1;
    public static final int PRIMITIVE = 0;
    public static final int REFERENCE = 1;
    public static final int COLLECTION = 2;
    public static final int COMPLEX_REFERENCE = 3;
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String XOR = " XOR ";
    private String logicalOperator = " AND ";
    static final String JOIN_PREFIX = "JOIN_";
    DbMapping ownType;
    DbMapping otherType;
    int columnType;
    DbMapping virtualMapping;
    String propName;
    String columnName;
    int reftype;
    Constraint[] constraints;
    boolean virtual;
    boolean readonly;
    boolean aggressiveLoading;
    boolean aggressiveCaching;
    boolean isPrivate = false;
    boolean referencesPrimaryKey = false;
    String updateCriteria;
    String accessName;
    String order;
    boolean autoSorted = false;
    String groupbyOrder;
    String groupby;
    String prototype;
    String groupbyPrototype;
    String filter;
    private String additionalTables;
    private boolean additionalTablesJoined = false;
    String queryHints;
    Vector filterFragments;
    Vector filterPropertyRefs;
    int maxSize = 0;

    private Relation(Relation rel) {
        this.ownType = rel.ownType;
        this.otherType = rel.otherType;
        this.propName = rel.propName;
        this.columnName = rel.columnName;
        this.reftype = rel.reftype;
        this.order = rel.order;
        this.filter = rel.filter;
        this.filterFragments = rel.filterFragments;
        this.filterPropertyRefs = rel.filterPropertyRefs;
        this.additionalTables = rel.additionalTables;
        this.additionalTablesJoined = rel.additionalTablesJoined;
        this.queryHints = rel.queryHints;
        this.maxSize = rel.maxSize;
        this.constraints = rel.constraints;
        this.accessName = rel.accessName;
        this.maxSize = rel.maxSize;
        this.logicalOperator = rel.logicalOperator;
        this.aggressiveLoading = rel.aggressiveLoading;
        this.aggressiveCaching = rel.aggressiveCaching;
        this.updateCriteria = rel.updateCriteria;
        this.autoSorted = rel.autoSorted;
    }

    public Relation(String propName, DbMapping ownType) {
        this.ownType = ownType;
        this.propName = propName;
        this.otherType = null;
    }

    public void update(String desc, ResourceProperties props) {
        Application app = this.ownType.getApplication();
        if (desc == null || "".equals(desc.trim())) {
            if (this.propName != null) {
                this.reftype = 0;
                this.columnName = this.propName;
            } else {
                this.reftype = -1;
                this.columnName = this.propName;
            }
        } else {
            desc = desc.trim();
            int open = desc.indexOf("(");
            int close = desc.indexOf(")");
            if (open > -1 && close > open) {
                String ref = desc.substring(0, open).trim();
                String proto = desc.substring(open + 1, close).trim();
                if ("collection".equalsIgnoreCase(ref)) {
                    this.virtual = !"_children".equalsIgnoreCase(this.propName);
                    this.reftype = 2;
                } else if ("mountpoint".equalsIgnoreCase(ref)) {
                    this.virtual = true;
                    this.reftype = 2;
                    this.prototype = proto;
                } else if ("object".equalsIgnoreCase(ref)) {
                    this.virtual = false;
                    if (this.reftype != 3) {
                        this.reftype = 1;
                    }
                } else {
                    throw new RuntimeException("Invalid property Mapping: " + desc);
                }
                this.otherType = app.getDbMapping(proto);
                if (this.otherType == null) {
                    throw new RuntimeException("DbMapping for " + proto + " not found from " + this.ownType.getTypeName());
                }
                if (this.otherType.needsUpdate()) {
                    this.otherType.update();
                }
            } else {
                this.virtual = false;
                this.columnName = desc;
                this.reftype = 0;
            }
        }
        ResourceProperties config = props.getSubProperties(this.propName + '.');
        this.readonly = "true".equalsIgnoreCase(config.getProperty("readonly"));
        this.isPrivate = "true".equalsIgnoreCase(config.getProperty("private"));
        if (this.reftype != 0 && this.reftype != -1) {
            Vector newConstraints = new Vector();
            this.parseOptions(newConstraints, config);
            this.constraints = new Constraint[newConstraints.size()];
            newConstraints.copyInto(this.constraints);
            if (this.reftype == 1 || this.reftype == 3) {
                if (this.constraints.length == 0) {
                    this.referencesPrimaryKey = true;
                } else {
                    boolean rprim = false;
                    for (int i = 0; i < this.constraints.length; ++i) {
                        if (!this.constraints[i].foreignKeyIsPrimary()) continue;
                        rprim = true;
                        break;
                    }
                    this.referencesPrimaryKey = rprim;
                }
                this.reftype = this.constraints.length > 1 || !this.usesPrimaryKey() ? 3 : 1;
            }
            if (this.reftype == 2) {
                boolean bl = this.referencesPrimaryKey = this.accessName == null || this.accessName.equalsIgnoreCase(this.otherType.getIDField());
            }
            if (this.virtualMapping != null) {
                this.virtualMapping.lastTypeChange = this.ownType.lastTypeChange;
                this.virtualMapping.subRelation = this.getVirtualSubnodeRelation();
                this.virtualMapping.propRelation = this.getVirtualPropertyRelation();
            }
        } else {
            this.referencesPrimaryKey = false;
        }
    }

    protected void parseOptions(Vector cnst, Properties config) {
        String logic;
        int i;
        String loading = config.getProperty("loadmode");
        this.aggressiveLoading = loading != null && "aggressive".equalsIgnoreCase(loading.trim());
        String caching = config.getProperty("cachemode");
        this.aggressiveCaching = caching != null && "aggressive".equalsIgnoreCase(caching.trim());
        this.order = config.getProperty("order");
        if (this.order != null && this.order.trim().length() == 0) {
            this.order = null;
        }
        this.updateCriteria = config.getProperty("updatecriteria");
        this.autoSorted = "auto".equalsIgnoreCase(config.getProperty("sortmode"));
        this.filter = config.getProperty("filter");
        if (this.filter != null) {
            if (this.filter.trim().length() == 0) {
                this.filter = null;
                this.filterPropertyRefs = null;
                this.filterFragments = null;
            } else {
                Vector fragments = new Vector();
                Vector propertyRefs = new Vector();
                this.parsePropertyString(this.filter, fragments, propertyRefs);
                if (propertyRefs.size() > 0) {
                    this.filterFragments = fragments;
                    this.filterPropertyRefs = propertyRefs;
                } else {
                    this.filterPropertyRefs = null;
                    this.filterFragments = null;
                }
            }
        }
        this.additionalTables = config.getProperty("filter.additionalTables");
        if (this.additionalTables != null) {
            if (this.additionalTables.trim().length() == 0) {
                this.additionalTables = null;
            } else {
                String ucTables = this.additionalTables.toUpperCase();
                DbSource dbsource = this.otherType.getDbSource();
                if (dbsource != null) {
                    String[] tables = StringUtils.split(ucTables, ", ");
                    for (i = 0; i < tables.length; ++i) {
                        DbMapping dbmap;
                        if ("AS".equals(tables[i]) || "ON".equals(tables[i]) || (dbmap = dbsource.getDbMapping(tables[i])) == null) continue;
                        dbmap.addDependency(this.otherType);
                    }
                }
                this.additionalTablesJoined = ucTables.indexOf(" JOIN ") != -1 || ucTables.startsWith("STRAIGHT_JOIN ") || ucTables.startsWith("JOIN ");
            }
        }
        this.queryHints = config.getProperty("hints");
        String max = config.getProperty("maxSize");
        if (max != null) {
            try {
                this.maxSize = Integer.parseInt(max);
            }
            catch (NumberFormatException nfe) {
                this.maxSize = 0;
            }
        } else {
            this.maxSize = 0;
        }
        this.groupby = config.getProperty("group");
        if (this.groupby != null && this.groupby.trim().length() == 0) {
            this.groupby = null;
        }
        if (this.groupby != null) {
            this.groupbyOrder = config.getProperty("group.order");
            if (this.groupbyOrder != null && this.groupbyOrder.trim().length() == 0) {
                this.groupbyOrder = null;
            }
            this.groupbyPrototype = config.getProperty("group.prototype");
            if (this.groupbyPrototype != null && this.groupbyPrototype.trim().length() == 0) {
                this.groupbyPrototype = null;
            }
        }
        this.accessName = config.getProperty("accessname");
        String local = config.getProperty("local");
        String foreign = config.getProperty("foreign");
        if (local != null && foreign != null) {
            cnst.addElement(new Constraint(local, foreign, false));
            this.columnName = local;
        }
        for (i = 1; i < 10; ++i) {
            local = config.getProperty("local." + i);
            foreign = config.getProperty("foreign." + i);
            if (local == null || foreign == null) continue;
            cnst.addElement(new Constraint(local, foreign, false));
        }
        this.logicalOperator = cnst.size() > 1 ? ("and".equalsIgnoreCase(logic = config.getProperty("logicalOperator")) ? AND : ("or".equalsIgnoreCase(logic) ? OR : ("xor".equalsIgnoreCase(logic) ? XOR : AND))) : AND;
    }

    public ResourceProperties getConfig() {
        return this.ownType.getProperties().getSubProperties(this.propName + '.');
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public DbMapping getTargetType() {
        return this.otherType;
    }

    public int getRefType() {
        return this.reftype;
    }

    public boolean isPrimitive() {
        return this.reftype == 0;
    }

    public boolean isReference() {
        return this.reftype == 1;
    }

    public boolean isPrimitiveOrReference() {
        return this.reftype == 0 || this.reftype == 1;
    }

    public boolean isCollection() {
        return this.reftype == 2;
    }

    public boolean isComplexReference() {
        return this.reftype == 3;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean loadAggressively() {
        return this.aggressiveLoading;
    }

    public int countConstraints() {
        if (this.constraints == null) {
            return 0;
        }
        return this.constraints.length;
    }

    public boolean createOnDemand() {
        if (this.otherType == null) {
            return false;
        }
        return this.virtual || this.otherType.isRelational() && this.accessName != null || this.groupby != null || this.isComplexReference();
    }

    public boolean needsPersistence() {
        if (!this.virtual) {
            return true;
        }
        if (this.prototype == null) {
            return !this.otherType.isRelational();
        }
        DbMapping sub = this.otherType.getSubnodeMapping();
        return sub != null && !sub.isRelational();
    }

    public String getPrototype() {
        return this.prototype;
    }

    public String getPropName() {
        return this.propName;
    }

    public void setColumnType(int ct) {
        this.columnType = ct;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public String getGroup() {
        return this.groupby;
    }

    protected void addConstraint(Constraint c) {
        if (this.constraints == null) {
            this.constraints = new Constraint[1];
            this.constraints[0] = c;
        } else {
            Constraint[] nc = new Constraint[this.constraints.length + 1];
            System.arraycopy(this.constraints, 0, nc, 0, this.constraints.length);
            nc[nc.length - 1] = c;
            this.constraints = nc;
        }
    }

    public boolean usesPrimaryKey() {
        return this.referencesPrimaryKey;
    }

    public boolean hasAccessName() {
        return this.accessName != null;
    }

    public String getAccessName() {
        return this.accessName;
    }

    public Relation getSubnodeRelation() {
        return null;
    }

    public String getDbField() {
        return this.columnName;
    }

    protected void parsePropertyString(String value, Vector fragments, Vector propertyRefs) {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                fragments.addElement(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.addElement("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                if (value.charAt(pos + 1) == '$') {
                    fragments.addElement("$");
                    prev = pos + 2;
                    continue;
                }
                fragments.addElement(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new RuntimeException("Syntax error in property: " + value);
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.addElement(null);
            propertyRefs.addElement(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.addElement(value.substring(prev));
        }
    }

    public DbMapping getVirtualMapping() {
        if (!this.virtual) {
            return null;
        }
        if (this.prototype != null) {
            return this.otherType;
        }
        if (this.virtualMapping == null) {
            this.virtualMapping = new DbMapping(this.ownType.app, null);
            this.virtualMapping.subRelation = this.getVirtualSubnodeRelation();
            this.virtualMapping.propRelation = this.getVirtualPropertyRelation();
        }
        return this.virtualMapping;
    }

    public DbMapping getPropertyMapping() {
        if (!this.virtual || this.prototype != null) {
            return this.otherType;
        }
        return null;
    }

    Relation getVirtualSubnodeRelation() {
        if (!this.virtual) {
            throw new RuntimeException("getVirtualSubnodeRelation called on non-virtual relation");
        }
        Relation vr = new Relation(this);
        vr.groupby = this.groupby;
        vr.groupbyOrder = this.groupbyOrder;
        vr.groupbyPrototype = this.groupbyPrototype;
        return vr;
    }

    Relation getVirtualPropertyRelation() {
        if (!this.virtual) {
            throw new RuntimeException("getVirtualPropertyRelation called on non-virtual relation");
        }
        Relation vr = new Relation(this);
        vr.groupby = this.groupby;
        vr.groupbyOrder = this.groupbyOrder;
        vr.groupbyPrototype = this.groupbyPrototype;
        return vr;
    }

    Relation getGroupbySubnodeRelation() {
        if (this.groupby == null) {
            throw new RuntimeException("getGroupbySubnodeRelation called on non-group-by relation");
        }
        Relation vr = new Relation(this);
        vr.prototype = this.groupbyPrototype;
        vr.addConstraint(new Constraint(null, this.groupby, true));
        return vr;
    }

    Relation getGroupbyPropertyRelation() {
        if (this.groupby == null) {
            throw new RuntimeException("getGroupbyPropertyRelation called on non-group-by relation");
        }
        Relation vr = new Relation(this);
        vr.prototype = this.groupbyPrototype;
        vr.addConstraint(new Constraint(null, this.groupby, true));
        return vr;
    }

    public String buildQuery(INode home, INode nonvirtual, String kstr, String pre, boolean useOrder) throws SQLException, ClassNotFoundException {
        return this.buildQuery(home, nonvirtual, this.otherType, kstr, pre, useOrder);
    }

    public String buildQuery(INode home, INode nonvirtual, DbMapping otherDbm, String kstr, String pre, boolean useOrder) throws SQLException, ClassNotFoundException {
        StringBuffer q = new StringBuffer();
        String prefix = pre;
        if (kstr != null && !this.isComplexReference()) {
            q.append(prefix);
            String accessColumn = this.accessName == null ? otherDbm.getIDField() : this.accessName;
            otherDbm.appendCondition(q, accessColumn, kstr);
            prefix = AND;
        }
        this.renderConstraints(q, home, nonvirtual, otherDbm, prefix);
        this.ownType.addJoinConstraints(q, prefix);
        if (this.groupby != null) {
            q.append(" GROUP BY ").append(this.groupby);
            if (useOrder && this.groupbyOrder != null) {
                q.append(" ORDER BY ").append(this.groupbyOrder);
            }
        } else if (useOrder && this.order != null) {
            q.append(" ORDER BY ").append(this.order);
        }
        return q.toString();
    }

    protected void appendAdditionalTables(StringBuffer q) {
        if (this.additionalTables != null) {
            q.append(this.additionalTablesJoined ? (char)' ' : ',');
            q.append(this.additionalTables);
        }
    }

    protected void appendFilter(StringBuffer q, INode nonvirtual, String prefix) {
        q.append(prefix);
        q.append('(');
        if (this.filterFragments == null) {
            q.append(this.filter);
        } else {
            Enumeration i = this.filterFragments.elements();
            Enumeration j = this.filterPropertyRefs.elements();
            while (i.hasMoreElements()) {
                String fragment = (String)i.nextElement();
                if (fragment == null) {
                    String columnName = (String)j.nextElement();
                    Object value = null;
                    if (columnName != null) {
                        IProperty property;
                        DbMapping dbmap = nonvirtual.getDbMapping();
                        String propertyName = dbmap.columnNameToProperty(columnName);
                        if (propertyName != null && (property = nonvirtual.get(propertyName)) != null) {
                            value = property.getStringValue();
                        }
                        if (value == null) {
                            if (columnName.equalsIgnoreCase(dbmap.getIDField())) {
                                value = nonvirtual.getID();
                            } else if (columnName.equalsIgnoreCase(dbmap.getNameField())) {
                                value = nonvirtual.getName();
                            } else if (columnName.equalsIgnoreCase(dbmap.getPrototypeField())) {
                                value = dbmap.getExtensionId();
                            }
                        }
                    }
                    if (value != null) {
                        q.append(DbMapping.escape(value.toString()));
                        continue;
                    }
                    q.append("NULL");
                    continue;
                }
                q.append(fragment);
            }
        }
        q.append(')');
    }

    public void renderConstraints(StringBuffer q, INode home, INode nonvirtual, String prefix) throws SQLException, ClassNotFoundException {
        this.renderConstraints(q, home, nonvirtual, this.otherType, prefix);
    }

    public void renderConstraints(StringBuffer q, INode home, INode nonvirtual, DbMapping otherDbm, String prefix) throws SQLException, ClassNotFoundException {
        if (this.constraints.length > 1 && this.logicalOperator != AND) {
            q.append(prefix);
            q.append("(");
            prefix = "";
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            if (this.constraints[i].foreignKeyIsPrototype()) continue;
            q.append(prefix);
            this.constraints[i].addToQuery(q, home, nonvirtual, otherDbm);
            prefix = this.logicalOperator;
        }
        if (this.constraints.length > 1 && this.logicalOperator != AND) {
            q.append(")");
            prefix = AND;
        }
        if (otherDbm.inheritsStorage()) {
            String protoField = otherDbm.getPrototypeField();
            String[] extensions = otherDbm.getExtensions();
            if (extensions != null && protoField != null) {
                q.append(prefix);
                otherDbm.appendCondition(q, protoField, extensions);
                prefix = AND;
            }
        }
        if (this.filter != null) {
            this.appendFilter(q, nonvirtual, prefix);
        }
    }

    public void renderJoinConstraints(StringBuffer select, boolean isOracle) {
        for (int i = 0; i < this.constraints.length; ++i) {
            select.append(this.ownType.getTableName());
            select.append(".");
            select.append(this.constraints[i].localKey);
            select.append(" = ");
            select.append(JOIN_PREFIX);
            select.append(this.propName);
            select.append(".");
            select.append(this.constraints[i].foreignKey);
            if (isOracle) {
                select.append("(+)");
            }
            if (i == this.constraints.length - 1) {
                select.append(" ");
                continue;
            }
            select.append(AND);
        }
    }

    public String getOrder() {
        if (this.groupby != null) {
            return this.groupbyOrder;
        }
        return this.order;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean checkConstraints(Node parent, Node child) {
        if (this.filter != null && child.lastModified() > child.created()) {
            return false;
        }
        int count = 0;
        int satisfied = 0;
        Node nonvirtual = parent.getNonVirtualParent();
        DbMapping otherDbm = child.getDbMapping();
        if (otherDbm == null) {
            otherDbm = this.otherType;
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            Constraint cnst = this.constraints[i];
            String propname = cnst.foreignProperty(otherDbm);
            if (propname == null) continue;
            Node home = cnst.isGroupby ? parent : nonvirtual;
            String value = null;
            value = cnst.localKeyIsPrimary(home.getDbMapping()) ? home.getID() : (cnst.localKeyIsPrototype() ? home.getDbMapping().getStorageTypeName() : (this.ownType.isRelational() ? home.getString(cnst.localProperty()) : home.getString(cnst.localKey)));
            ++count;
            if (value == null || !value.equals(child.getString(propname))) continue;
            ++satisfied;
        }
        if (this.logicalOperator == OR) {
            return satisfied > 0;
        }
        if (this.logicalOperator == XOR) {
            return satisfied == 1;
        }
        return satisfied == count;
    }

    public void setConstraints(Node parent, Node child) {
        if (this.logicalOperator != AND) {
            return;
        }
        Node home = parent.getNonVirtualParent();
        for (int i = 0; i < this.constraints.length; ++i) {
            Relation crel;
            Constraint cnst = this.constraints[i];
            if (cnst.isGroupby) continue;
            boolean foreignIsPrimary = cnst.foreignKeyIsPrimary();
            if (foreignIsPrimary || cnst.foreignKeyIsPrototype()) {
                String localProp = cnst.localProperty();
                if (localProp == null) {
                    this.ownType.app.logError("Error: column " + cnst.localKey + " must be mapped in order to be used as constraint in " + this);
                    continue;
                }
                String value = foreignIsPrimary ? child.getID() : child.getDbMapping().getStorageTypeName();
                home.setString(localProp, value);
                continue;
            }
            DbMapping otherDbm = child.getDbMapping();
            if (otherDbm == null) {
                otherDbm = this.otherType;
            }
            if ((crel = otherDbm.columnNameToRelation(cnst.foreignKey)) == null) continue;
            if (cnst.localKeyIsPrimary(home.getDbMapping())) {
                if (crel.reftype == 1) {
                    INode currentValue = child.getNode(crel.propName);
                    if (currentValue != null && (currentValue == home || currentValue.getState() != -3 && home.getState() == -3)) continue;
                    try {
                        child.setNode(crel.propName, home);
                    }
                    catch (Exception ignore) {}
                    continue;
                }
                if (crel.reftype != 0) continue;
                child.setString(crel.propName, home.getID());
                continue;
            }
            if (crel.reftype != 0) continue;
            if (cnst.localKeyIsPrototype()) {
                child.setString(crel.propName, home.getDbMapping().getStorageTypeName());
                continue;
            }
            Property prop = home.getProperty(cnst.localProperty());
            if (prop == null) continue;
            child.set(crel.propName, prop.getValue(), prop.getType());
        }
    }

    public void unsetConstraints(Node parent, INode child) {
        Node home = parent.getNonVirtualParent();
        for (int i = 0; i < this.constraints.length; ++i) {
            Relation crel;
            Constraint cnst = this.constraints[i];
            if (cnst.isGroupby) continue;
            if (cnst.foreignKeyIsPrimary() || cnst.foreignKeyIsPrototype()) {
                String localProp = cnst.localProperty();
                if (localProp == null) continue;
                home.setString(localProp, null);
                continue;
            }
            DbMapping otherDbm = child.getDbMapping();
            if (otherDbm == null) {
                otherDbm = this.otherType;
            }
            if ((crel = otherDbm.columnNameToRelation(cnst.foreignKey)) == null) continue;
            if (cnst.localKeyIsPrimary(home.getDbMapping())) {
                if (crel.reftype == 1) {
                    INode currentValue = child.getNode(crel.propName);
                    if (currentValue != home) continue;
                    child.setString(crel.propName, null);
                    continue;
                }
                if (crel.reftype != 0) continue;
                child.setString(crel.propName, null);
                continue;
            }
            if (crel.reftype != 0) continue;
            child.setString(crel.propName, null);
        }
    }

    public Map getKeyParts(INode home) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.constraints.length; ++i) {
            Constraint cnst = this.constraints[i];
            if (cnst.localKeyIsPrimary(this.ownType)) {
                map.put(cnst.foreignKey, home.getID());
                continue;
            }
            if (cnst.localKeyIsPrototype()) {
                map.put(cnst.foreignKey, home.getDbMapping().getStorageTypeName());
                continue;
            }
            map.put(cnst.foreignKey, home.getString(cnst.localProperty()));
        }
        return map;
    }

    public String toString() {
        String c = "";
        String spacer = "";
        if (this.constraints != null) {
            c = " constraints: ";
            for (int i = 0; i < this.constraints.length; ++i) {
                c = c + spacer;
                c = c + this.constraints[i].toString();
                spacer = ", ";
            }
        }
        String target = this.otherType == null ? this.columnName : this.otherType.toString();
        return "Relation " + this.ownType + "." + this.propName + " -> " + target + c;
    }

    class Constraint {
        String localKey;
        String foreignKey;
        boolean isGroupby;

        Constraint(String local, String foreign, boolean groupby) {
            this.localKey = local;
            this.foreignKey = foreign;
            this.isGroupby = groupby;
        }

        public void addToQuery(StringBuffer q, INode home, INode nonvirtual, DbMapping otherDbm) throws SQLException, ClassNotFoundException {
            String local;
            INode ref;
            INode iNode = ref = this.isGroupby ? home : nonvirtual;
            if (this.localKeyIsPrimary(ref.getDbMapping())) {
                local = ref.getID();
            } else if (this.localKeyIsPrototype()) {
                local = ref.getDbMapping().getStorageTypeName();
            } else {
                String homeprop = Relation.this.ownType.columnNameToProperty(this.localKey);
                if (homeprop == null) {
                    throw new SQLException("Invalid local name '" + this.localKey + "' on " + Relation.this.ownType);
                }
                local = ref.getString(homeprop);
            }
            String columnName = this.foreignKeyIsPrimary() ? otherDbm.getIDField() : this.foreignKey;
            otherDbm.appendCondition(q, columnName, local);
        }

        public boolean foreignKeyIsPrimary() {
            return this.foreignKey == null || "$id".equalsIgnoreCase(this.foreignKey) || this.foreignKey.equalsIgnoreCase(Relation.this.otherType.getIDField());
        }

        public boolean foreignKeyIsPrototype() {
            return "$prototype".equalsIgnoreCase(this.foreignKey);
        }

        public boolean localKeyIsPrimary(DbMapping homeMapping) {
            return homeMapping == null || this.localKey == null || "$id".equalsIgnoreCase(this.localKey) || this.localKey.equalsIgnoreCase(homeMapping.getIDField());
        }

        public boolean localKeyIsPrototype() {
            return "$prototype".equalsIgnoreCase(this.localKey);
        }

        public String foreignProperty(DbMapping otherDbm) {
            if (otherDbm.isRelational()) {
                return otherDbm.columnNameToProperty(this.foreignKey);
            }
            return this.foreignKey;
        }

        public String localProperty() {
            if (Relation.this.ownType.isRelational()) {
                return Relation.this.ownType.columnNameToProperty(this.localKey);
            }
            return this.localKey;
        }

        public String toString() {
            return this.localKey + "=" + Relation.this.otherType.getTypeName() + "." + this.foreignKey;
        }
    }
}

