/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.INode;
import helma.objectmodel.IProperty;
import helma.objectmodel.db.DbKey;
import helma.objectmodel.db.DbMapping;
import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeHandle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Property
implements IProperty,
Serializable,
Cloneable,
Comparable {
    static final long serialVersionUID = -1022221688349192379L;
    private String propname;
    private Node node;
    private Object value;
    private int type;
    transient boolean dirty;

    public Property(Node node) {
        this.node = node;
        this.dirty = true;
    }

    public Property(String propname, Node node) {
        this.propname = propname;
        this.node = node;
        this.dirty = true;
    }

    public Property(String propname, Node node, Node valueNode) {
        this(propname, node);
        this.type = 6;
        this.value = valueNode == null ? null : valueNode.getHandle();
        this.dirty = true;
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            this.propname = in.readUTF();
            this.node = (Node)in.readObject();
            this.type = in.readInt();
            switch (this.type) {
                case 1: {
                    this.value = in.readObject();
                    break;
                }
                case 2: {
                    this.value = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 4: {
                    this.value = new Long(in.readLong());
                    break;
                }
                case 3: {
                    this.value = new Date(in.readLong());
                    break;
                }
                case 5: {
                    this.value = new Double(in.readDouble());
                    break;
                }
                case 6: {
                    this.value = in.readObject();
                    break;
                }
                case 7: {
                    this.value = in.readObject();
                }
            }
        }
        catch (ClassNotFoundException x) {
            throw new IOException(x.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.propname);
        out.writeObject(this.node);
        out.writeInt(this.type);
        switch (this.type) {
            case 1: {
                out.writeObject(this.value);
                break;
            }
            case 2: {
                out.writeBoolean((Boolean)this.value);
                break;
            }
            case 4: {
                out.writeLong((Long)this.value);
                break;
            }
            case 3: {
                out.writeLong(((Date)this.value).getTime());
                break;
            }
            case 5: {
                out.writeDouble((Double)this.value);
                break;
            }
            case 6: {
                out.writeObject(this.value);
                break;
            }
            case 7: {
                if (this.value != null && !(this.value instanceof Serializable)) {
                    out.writeObject(null);
                    break;
                }
                out.writeObject(this.value);
            }
        }
    }

    public String getName() {
        return this.propname;
    }

    protected void setName(String name) {
        this.propname = name;
    }

    public Object getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    protected void setValue(Object value, int type) {
        this.value = value;
        this.type = type;
        this.dirty = true;
    }

    public void setStringValue(String str) {
        this.type = 1;
        this.value = str;
        this.dirty = true;
    }

    public void setIntegerValue(long l) {
        this.type = 4;
        this.value = new Long(l);
        this.dirty = true;
    }

    public void setFloatValue(double d) {
        this.type = 5;
        this.value = new Double(d);
        this.dirty = true;
    }

    public void setDateValue(Date date) {
        this.type = 3;
        this.value = date != null && date.getClass() != Date.class ? new Date(date.getTime()) : date;
        this.dirty = true;
    }

    public void setBooleanValue(boolean bool) {
        this.type = 2;
        this.value = bool ? Boolean.TRUE : Boolean.FALSE;
        this.dirty = true;
    }

    public void setNodeValue(Node node) {
        this.type = 6;
        this.value = node == null ? null : node.getHandle();
        this.dirty = true;
    }

    public void setNodeHandle(NodeHandle handle) {
        this.type = 6;
        this.value = handle;
        this.dirty = true;
    }

    public NodeHandle getNodeHandle() {
        if (this.type == 6) {
            return (NodeHandle)this.value;
        }
        return null;
    }

    public void convertToNodeReference(DbMapping dbm) {
        if (this.value != null && !(this.value instanceof NodeHandle)) {
            this.value = new NodeHandle(new DbKey(dbm, this.value.toString()));
        }
        this.type = 6;
    }

    public void setJavaObjectValue(Object obj) {
        this.type = 7;
        this.value = obj;
        this.dirty = true;
    }

    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        switch (this.type) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                return this.value.toString();
            }
            case 3: {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return format.format((Date)this.value);
            }
            case 6: {
                return ((NodeHandle)this.value).getID();
            }
        }
        return "";
    }

    public String toString() {
        return this.getStringValue();
    }

    public long getIntegerValue() {
        if (this.type == 4) {
            return (Long)this.value;
        }
        if (this.type == 5) {
            return ((Double)this.value).longValue();
        }
        if (this.type == 2) {
            return (Boolean)this.value != false ? 1L : 0L;
        }
        try {
            return Long.parseLong(this.getStringValue());
        }
        catch (Exception x) {
            return 0L;
        }
    }

    public double getFloatValue() {
        if (this.type == 5) {
            return (Double)this.value;
        }
        if (this.type == 4) {
            return ((Long)this.value).doubleValue();
        }
        try {
            return Double.parseDouble(this.getStringValue());
        }
        catch (Exception x) {
            return 0.0;
        }
    }

    public Date getDateValue() {
        if (this.type == 3) {
            return (Date)this.value;
        }
        return null;
    }

    public Timestamp getTimestampValue() {
        if (this.type == 3 && this.value != null) {
            return new Timestamp(((Date)this.value).getTime());
        }
        return null;
    }

    public boolean getBooleanValue() {
        if (this.type == 2) {
            return (Boolean)this.value;
        }
        if (this.type == 4) {
            return 0L != this.getIntegerValue();
        }
        return false;
    }

    public INode getNodeValue() {
        if (this.type == 6 && this.value != null) {
            NodeHandle nhandle = (NodeHandle)this.value;
            return nhandle.getNode(this.node.nmgr);
        }
        return null;
    }

    public Object getJavaObjectValue() {
        if (this.type == 7) {
            return this.value;
        }
        return null;
    }

    public int compareTo(Object obj) {
        Property p = (Property)obj;
        int ptype = p.getType();
        Object pvalue = p.getValue();
        if (this.type == 6 || ptype == 6 || this.type == 2 || ptype == 2) {
            throw new ClassCastException("uncomparable values " + this + "(" + this.type + ") : " + p + "(" + ptype + ")");
        }
        if (this.value == null && pvalue == null) {
            return 0;
        }
        if (this.value == null) {
            return 1;
        }
        if (pvalue == null) {
            return -1;
        }
        if (this.type != ptype) {
            if (this.type == 5 && ptype == 4 || this.type == 4 && ptype == 5) {
                return Double.compare(((Number)this.value).doubleValue(), ((Number)pvalue).doubleValue());
            }
            throw new ClassCastException("uncomparable values " + this + "(" + this.type + ") : " + p + "(" + ptype + ")");
        }
        if (!(this.value instanceof Comparable)) {
            throw new ClassCastException("uncomparable value " + this.value + "(" + this.value.getClass() + ")");
        }
        return ((Comparable)this.value).compareTo(pvalue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property p = (Property)obj;
        return this.value == null ? p.value == null : this.value.equals(p.value);
    }
}

