/*
 * Decompiled with CFR 0.152.
 */
package helma.objectmodel.db;

import helma.objectmodel.db.Node;
import helma.objectmodel.db.NodeHandle;
import helma.objectmodel.db.Property;
import helma.objectmodel.db.Relation;
import helma.objectmodel.db.SubnodeList;
import helma.objectmodel.db.WrappedNodeManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OrderedSubnodeList
extends SubnodeList {
    private SubnodeList origin;
    private String[] orderProperties;
    private boolean[] orderIsDesc;

    public OrderedSubnodeList(WrappedNodeManager nmgr, Relation rel) {
        super(nmgr, rel);
        this.origin = null;
        this.initOrder(rel.order);
    }

    public OrderedSubnodeList(WrappedNodeManager nmgr, Relation rel, SubnodeList origin, String expr) {
        super(nmgr, rel);
        this.origin = origin;
        this.initOrder(expr);
        if (origin != null) {
            this.sortIn(origin, false);
        }
    }

    private void initOrder(String order) {
        if (order == null) {
            this.orderProperties = null;
            this.orderIsDesc = null;
        } else {
            String[] orderParts = order.split(",");
            this.orderProperties = new String[orderParts.length];
            this.orderIsDesc = new boolean[orderParts.length];
            for (int i = 0; i < orderParts.length; ++i) {
                String[] part = orderParts[i].trim().split(" ");
                this.orderProperties[i] = part[0].equals("_id") ? null : part[0];
                this.orderIsDesc[i] = part.length == 2 && "DESC".equalsIgnoreCase(part[1]);
            }
        }
    }

    public boolean add(Object obj) {
        return this.add(obj, true);
    }

    public void add(int idx, Object obj) {
        if (this.orderProperties != null) {
            throw new RuntimeException("Indexed add isn't alowed for ordered subnodes");
        }
        super.add(idx, obj);
        this.addToViews(obj);
    }

    public boolean addSorted(Object obj) {
        return this.add(obj, false);
    }

    boolean add(Object obj, boolean sort) {
        int maxSize;
        if (this.origin != null) {
            return this.origin.add(obj);
        }
        this.addToViews(obj);
        int n = maxSize = this.rel == null ? 0 : this.rel.maxSize;
        while (maxSize > 0 && this.size() >= maxSize) {
            this.remove(this.size() - 1);
        }
        if (sort && (this.rel == null || this.rel.groupby == null)) {
            this.sortIn(obj);
        } else {
            super.add(obj);
        }
        return true;
    }

    public boolean sortIn(Object obj) {
        if (this.orderProperties == null) {
            return super.add(obj);
        }
        this.addToViews(obj);
        Node node = ((NodeHandle)obj).getNode(this.nmgr);
        int idx = this.determineNodePosition(node, 0);
        if (idx < 0) {
            return super.add(obj);
        }
        super.add(idx, obj);
        return true;
    }

    public boolean addAll(Collection col) {
        return this.sortIn(col, true) > 0;
    }

    private void addAllToViews(Collection col) {
        if (this.views == null || this.origin != null || this.views.isEmpty()) {
            return;
        }
        Iterator i = this.views.values().iterator();
        while (i.hasNext()) {
            OrderedSubnodeList osl = (OrderedSubnodeList)i.next();
            osl.addAll(col);
        }
    }

    public int sortIn(Collection col, boolean colHasDefaultOrder) {
        int cntr;
        block10: {
            block9: {
                int diff;
                int maxSize;
                this.addAllToViews(col);
                cntr = 0;
                if (this.orderProperties != null) break block9;
                Iterator i = col.iterator();
                while (i.hasNext()) {
                    super.add(cntr, i.next());
                    ++cntr;
                }
                int n = maxSize = this.rel == null ? 0 : this.rel.maxSize;
                if (maxSize <= 0 || (diff = this.size() - maxSize) <= 0) break block10;
                super.removeRange(this.size() - 1 - diff, this.size() - 1);
                break block10;
            }
            if (!colHasDefaultOrder || this.origin != null) {
                Iterator i = col.iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    if (obj == null) continue;
                    this.sortIn(obj);
                    ++cntr;
                }
            } else {
                NodeHandle[] nhArr = col.toArray(new NodeHandle[0]);
                Node node = nhArr[0].getNode(this.nmgr);
                int locIdx = this.determineNodePosition(node, 0);
                if (locIdx == -1) {
                    locIdx = this.size();
                }
                for (int addIdx = 0; addIdx < nhArr.length; ++addIdx) {
                    node = nhArr[addIdx].getNode(this.nmgr);
                    while (locIdx < this.size() && this.compareNodes(node, (NodeHandle)this.get(locIdx)) >= 0) {
                        ++locIdx;
                    }
                    if (locIdx < this.size()) {
                        this.add(locIdx, nhArr[addIdx]);
                    } else {
                        this.add(nhArr[addIdx]);
                    }
                    ++cntr;
                }
            }
        }
        return cntr;
    }

    public boolean removeAll(Collection c) {
        this.removeAllFromViews(c);
        return super.removeAll(c);
    }

    private void removeAllFromViews(Collection c) {
        if (this.views == null || this.origin != null || this.views.isEmpty()) {
            return;
        }
        Iterator i = this.views.values().iterator();
        while (i.hasNext()) {
            OrderedSubnodeList osl = (OrderedSubnodeList)i.next();
            osl.removeAll(c);
        }
    }

    public boolean retainAll(Collection c) {
        this.retainAllInViews(c);
        return super.retainAll(c);
    }

    private void retainAllInViews(Collection c) {
        if (this.views == null || this.origin != null || this.views.isEmpty()) {
            return;
        }
        Iterator i = this.views.values().iterator();
        while (i.hasNext()) {
            OrderedSubnodeList osl = (OrderedSubnodeList)i.next();
            osl.retainAll(c);
        }
    }

    private int determineNodePosition(Node node, int startIdx) {
        int cntr;
        int size = this.size();
        int interval = Math.max(1, (size - startIdx) / 2);
        boolean dirUp = true;
        int maxSize = this.rel == null ? 0 : this.rel.maxSize;
        int i = 0;
        for (cntr = 0; i < size && (i < maxSize || maxSize <= 0) && cntr < size * 2; ++cntr) {
            NodeHandle curr = (NodeHandle)this.get(i);
            int comp = this.compareNodes(node, curr);
            if (comp < 0 && interval == 1 && (i == 0 || this.compareNodes(node, (NodeHandle)this.get(i - 1)) >= 0)) {
                return i;
            }
            if (comp < 0) {
                dirUp = false;
            } else if (comp > 0) {
                dirUp = true;
            } else if (comp == 0) {
                dirUp = true;
                interval = 1;
            }
            if (dirUp) {
                if ((i += interval) >= this.size()) {
                    if (this.compareNodes(node, (NodeHandle)this.get(size - 1)) >= 0) break;
                    interval = Math.max(1, (i - size - 1) / 2);
                    i = this.size() - 1;
                    continue;
                }
                interval = Math.max(1, interval / 2);
                continue;
            }
            if ((i -= interval) >= 0) continue;
            interval = Math.max(1, (interval + i) / 2);
            i = 0;
        }
        if (cntr >= size * 2 && size > 1) {
            System.err.println("determineNodePosition needed more than the allowed iterations");
        }
        return -1;
    }

    private int compareNodes(Node node, NodeHandle nodeHandle) {
        for (int i = 0; i < this.orderProperties.length; ++i) {
            int j;
            if (this.orderProperties[i] == null) {
                String s2;
                String s1 = node.getID();
                j = OrderedSubnodeList.compareNumericString(s1, s2 = nodeHandle.getID());
                if (j == 0) continue;
                if (this.orderIsDesc[i]) {
                    j *= -1;
                }
                return j;
            }
            Property p1 = node.getProperty(this.orderProperties[i]);
            Property p2 = nodeHandle.getNode(this.nmgr).getProperty(this.orderProperties[i]);
            if (p1 == null && p2 == null || (j = p1 == null ? 1 : (p2 == null ? -1 : p1.compareTo(p2))) == 0) continue;
            if (this.orderIsDesc[i]) {
                j *= -1;
            }
            return j;
        }
        return -1;
    }

    public static int compareNumericString(String a, String b) {
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a == null && b == null) {
            return 0;
        }
        if (a.length() < b.length()) {
            return -1;
        }
        if (a.length() > b.length()) {
            return 1;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) < b.charAt(i)) {
                return -1;
            }
            if (a.charAt(i) <= b.charAt(i)) continue;
            return 1;
        }
        return 0;
    }

    public List getOrderedView(String order) {
        if (this.origin != null) {
            return this.origin.getOrderedView(order);
        }
        return super.getOrderedView(order);
    }
}

